/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2445;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.valuedefinitions.rfc2445.DateOrDateTimeValueDefinition;
import com.openexchange.tools.versit.values.DateTimeValue;
import com.openexchange.tools.versit.values.RecurrenceValue;
import java.io.IOException;
import java.util.Iterator;

public class RecurrenceValueDefinition
extends ValueDefinition {
    public static final ValueDefinition Default = new RecurrenceValueDefinition();
    private static final String[] freqs = new String[]{"SECONDLY", "MINUTELY", "HOURLY", "DAILY", "WEEKLY", "MONTHLY", "YEARLY"};
    private static final String[] weekdays = new String[]{"SU", "MO", "TU", "WE", "TH", "FR", "SA"};

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        RecurrenceValue recur;
        block50: {
            recur = new RecurrenceValue();
            if (!s.imatch("FREQ=")) {
                throw new VersitException(s, "Invalid recurrence");
            }
            String freq = s.parseName().toUpperCase();
            for (int i = 0; i < freqs.length; ++i) {
                if (!freq.equals(freqs[i])) continue;
                recur.Freq = i;
                break block50;
            }
            throw new VersitException(s, "Invalid recurrence");
        }
        block28: while (s.peek == 59) {
            s.read();
            switch (s.peek) {
                case 73: {
                    if (!s.imatch("INTERVAL=")) {
                        throw new VersitException(s, "Invalid recurrence");
                    }
                    recur.Interval = s.parseNumber();
                    continue block28;
                }
                case 66: {
                    if (!s.imatch("BY")) {
                        throw new VersitException(s, "Invalid recurrence");
                    }
                    switch (s.peek) {
                        case 83: {
                            if (!s.imatch("SE")) {
                                throw new VersitException(s, "Invalid recurrence");
                            }
                            switch (s.peek) {
                                case 67: {
                                    if (!s.imatch("COND=")) {
                                        throw new VersitException(s, "Invalid recurrence");
                                    }
                                    recur.BySecond = s.parseNumList();
                                    continue block28;
                                }
                                case 84: {
                                    if (!s.imatch("TPOS=")) {
                                        throw new VersitException(s, "Invalid recurrence");
                                    }
                                    recur.BySetPos = s.parseNumList();
                                    continue block28;
                                }
                            }
                            throw new VersitException(s, "Invalid recurrence");
                        }
                        case 77: {
                            s.read();
                            switch (s.peek) {
                                case 73: {
                                    if (!s.imatch("INUTE=")) {
                                        throw new VersitException(s, "Invalid recurrence");
                                    }
                                    recur.ByMinute = s.parseNumList();
                                    continue block28;
                                }
                                case 79: {
                                    if (!s.imatch("ONTH")) {
                                        throw new VersitException(s, "Invalid recurrence");
                                    }
                                    switch (s.peek) {
                                        case 68: {
                                            if (!s.imatch("DAY=")) {
                                                throw new VersitException(s, "Invalid recurrence");
                                            }
                                            recur.ByMonthDay = s.parseNumList();
                                            continue block28;
                                        }
                                        case 61: {
                                            s.read();
                                            recur.ByMonth = s.parseNumList();
                                            continue block28;
                                        }
                                    }
                                    throw new VersitException(s, "Invalid recurrence");
                                }
                            }
                            throw new VersitException(s, "Invalid recurrence");
                        }
                        case 72: {
                            if (!s.imatch("HOUR=")) {
                                throw new VersitException(s, "Invalid recurrence");
                            }
                            recur.ByHour = s.parseNumList();
                            continue block28;
                        }
                        case 68: {
                            if (!s.imatch("DAY=")) {
                                throw new VersitException(s, "Invalid recurrence");
                            }
                            while (true) {
                                int week = 0;
                                if (s.peek == 43 || s.peek == 45 || s.peek >= 48 && s.peek <= 57) {
                                    int sign = 1;
                                    if (s.peek == 43) {
                                        s.read();
                                    } else if (s.peek == 45) {
                                        sign = -1;
                                        s.read();
                                    }
                                    week = sign * s.parseNumber();
                                }
                                recur.ByDay.add(new RecurrenceValue.Weekday(week, this.parseWeekday(s)));
                                if (s.peek != 44) continue block28;
                                s.read();
                            }
                        }
                        case 89: {
                            if (!s.imatch("YEARDAY=")) {
                                throw new VersitException(s, "Invalid recurrence");
                            }
                            recur.ByYearDay = s.parseNumList();
                            continue block28;
                        }
                        case 87: {
                            if (!s.imatch("WEEKNO=")) {
                                throw new VersitException(s, "Invalid recurrence");
                            }
                            recur.ByWeekNo = s.parseNumList();
                            continue block28;
                        }
                    }
                    throw new VersitException(s, "Invalid recurrence");
                }
                case 67: {
                    if (!s.imatch("COUNT=")) {
                        throw new VersitException(s, "Invalid recurrence");
                    }
                    recur.Count = s.parseNumber();
                    continue block28;
                }
                case 85: {
                    if (!s.imatch("UNTIL=")) {
                        throw new VersitException(s, "Invalid recurrence");
                    }
                    recur.Until = (DateTimeValue)DateOrDateTimeValueDefinition.Default.createValue(s, property);
                    if (recur.Until.isUTC) continue block28;
                    throw new VersitException(s, "UTC time expected");
                }
                case 87: {
                    if (!s.imatch("WKST=")) {
                        throw new VersitException(s, "Invalid recurrence");
                    }
                    recur.WeekStart = this.parseWeekday(s);
                    continue block28;
                }
            }
            throw new VersitException(s, "Invalid recurrence");
        }
        return recur;
    }

    private int parseWeekday(StringScanner s) throws IOException {
        String weekday = s.parseName();
        for (int i = 0; i < 7; ++i) {
            if (!weekday.equals(weekdays[i])) continue;
            return 1 + i;
        }
        throw new VersitException(s, "Invalid recurrence");
    }

    @Override
    public String writeValue(Object value) {
        RecurrenceValue recur = (RecurrenceValue)value;
        StringBuilder sb = new StringBuilder();
        sb.append("FREQ=");
        sb.append(freqs[recur.Freq]);
        if (recur.Until != null) {
            sb.append(";UNTIL=");
            sb.append(DateOrDateTimeValueDefinition.Default.writeValue(recur.Until));
        } else if (recur.Count != -1) {
            sb.append(";COUNT=");
            sb.append(recur.Count);
        }
        if (recur.Interval != 1) {
            sb.append(";INTERVAL=");
            sb.append(recur.Interval);
        }
        this.appendList(sb, ";BYSECOND=", recur.BySecond);
        this.appendList(sb, ";BYMINUTE=", recur.ByMinute);
        this.appendList(sb, ";BYHOUR=", recur.ByHour);
        if (!recur.ByDay.isEmpty()) {
            sb.append(";BYDAY=");
            int size = recur.ByDay.size();
            Iterator<RecurrenceValue.Weekday> i = recur.ByDay.iterator();
            if (size > 0) {
                this.appendWeekday(sb, i.next());
                for (int k = 1; k < size; ++k) {
                    sb.append(',');
                    this.appendWeekday(sb, i.next());
                }
            }
        }
        this.appendList(sb, ";BYMONTHDAY=", recur.ByMonthDay);
        this.appendList(sb, ";BYYEARDAY=", recur.ByYearDay);
        this.appendList(sb, ";BYWEEKNO=", recur.ByWeekNo);
        this.appendList(sb, ";BYMONTH=", recur.ByMonth);
        this.appendList(sb, ";BYSETPOS=", recur.BySetPos);
        if (recur.WeekStart != 2) {
            sb.append(";WKST=");
            sb.append(weekdays[recur.WeekStart - 1]);
        }
        return sb.toString();
    }

    private void appendList(StringBuilder sb, String header, int[] list) {
        if (list.length == 0) {
            return;
        }
        sb.append(header);
        sb.append(list[0]);
        for (int i = 1; i < list.length; ++i) {
            sb.append(',');
            sb.append(list[i]);
        }
    }

    private void appendWeekday(StringBuilder sb, Object weekday) {
        RecurrenceValue.Weekday wd = (RecurrenceValue.Weekday)weekday;
        if (wd.week != 0) {
            sb.append(wd.week);
        }
        sb.append(weekdays[wd.day - 1]);
    }
}

