/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.console;

import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.oxfolder.GABRestorerMBeanImpl;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.oxfolder.console.JMXAuthenticatorImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;

public class GABRestorerCLT {
    private static final Options toolkitOptions = new Options();

    private static void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("restoregabdefaults", toolkitOptions);
    }

    private GABRestorerCLT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        int contextId = -1;
        boolean error = true;
        try {
            HashMap<String, JMXAuthenticatorImpl> environment;
            String val;
            CommandLine cmd = parser.parse(toolkitOptions, args);
            if (cmd.hasOption('h')) {
                GABRestorerCLT.printHelp();
                System.exit(0);
            }
            int port = 9999;
            if (cmd.hasOption('p') && null != (val = cmd.getOptionValue('p'))) {
                try {
                    port = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Port parameter is not a number: " + val);
                    GABRestorerCLT.printHelp();
                    System.exit(1);
                }
                if (port < 1 || port > 65535) {
                    System.err.println("Port parameter is out of range: " + val + ". Valid range is from 1 to 65535.");
                    GABRestorerCLT.printHelp();
                    System.exit(1);
                }
            }
            if (!cmd.hasOption('c')) {
                System.err.println("Missing context identifier.");
                GABRestorerCLT.printHelp();
                System.exit(1);
            } else {
                String optionValue = cmd.getOptionValue('c');
                try {
                    contextId = Integer.parseInt(optionValue.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Context parameter is not a number: " + optionValue);
                    GABRestorerCLT.printHelp();
                    System.exit(1);
                }
            }
            String jmxLogin = null;
            if (cmd.hasOption('l')) {
                jmxLogin = cmd.getOptionValue('l');
            }
            String jmxPassword = null;
            if (cmd.hasOption('s')) {
                jmxPassword = cmd.getOptionValue('s');
            }
            if (jmxLogin == null || jmxPassword == null) {
                environment = null;
            } else {
                environment = new HashMap<String, JMXAuthenticatorImpl>(1);
                environment.put("jmx.remote.authenticator", new JMXAuthenticatorImpl(new String[]{jmxLogin, jmxPassword}));
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, environment);
            try {
                MBeanServerConnection mbsc = jmxConnector.getMBeanServerConnection();
                String[] signature = new String[]{Integer.TYPE.getName()};
                Object[] params = new Object[]{contextId};
                mbsc.invoke(OXFolderProperties.getObjectName(GABRestorerMBeanImpl.class.getName(), "com.openexchange.globaladdressbook"), "restoreDefaultPermissions", params, signature);
            }
            catch (MalformedObjectNameException e) {
                com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(GABRestorerCLT.class)).error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (null != jmxConnector) {
                    try {
                        jmxConnector.close();
                    }
                    catch (Exception e) {}
                }
            }
            error = false;
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            GABRestorerCLT.printHelp();
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            System.err.println("Instance is not available: " + e.getMessage());
        }
        catch (MBeanException e) {
            Throwable t = e.getCause();
            String message = null == t ? e.getMessage() : (t instanceof OXException ? "Cannot find context " + contextId : t.getMessage());
            System.err.println(null == message ? "Unexpected error." : "Unexpected error: " + message);
        }
        catch (ReflectionException e) {
            System.err.println("Problem with reflective type handling: " + e.getMessage());
        }
        catch (RuntimeException e) {
            System.err.println("Problem in runtime: " + e.getMessage());
            GABRestorerCLT.printHelp();
        }
        finally {
            if (error) {
                System.exit(1);
            }
        }
    }

    static {
        toolkitOptions.addOption("h", "help", false, "Prints a help text");
        toolkitOptions.addOption("c", "context", true, "A valid context identifier contained in target schema");
        toolkitOptions.addOption("p", "port", true, "The optional JMX port (default:9999)");
        toolkitOptions.addOption("l", "login", true, "The optional JMX login (if JMX has authentication enabled)");
        toolkitOptions.addOption("s", "password", true, "The optional JMX password (if JMX has authentication enabled)");
    }
}

