/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.memory.ConditionTreeMapManagement;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.linked.TIntLinkedList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public final class OXFolderSQL {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(OXFolderSQL.class));
    private static final String SQL_SELECT_WITH_NON_EXISTING_PARENT = "SELECT ot1.fuid FROM oxfolder_tree AS ot1 where ot1.cid = ? AND ot1.parent <> 0 AND NOT EXISTS (SELECT ot2.fuid FROM oxfolder_tree AS ot2 where ot2.cid = ? AND ot1.parent = ot2.fuid)";
    private static final String SQL_SELECT_ADMIN = "SELECT user FROM user_setting_admin WHERE cid = ?";
    private static final String SQL_DEFAULTFLD = "SELECT ot.fuid FROM oxfolder_tree AS ot WHERE ot.cid = ? AND ot.created_from = ? AND ot.module = ? AND ot.default_flag = 1";
    private static final String SQL_SELECT_ALL_SHARED_FLDS = "SELECT ot.fuid FROM oxfolder_tree AS ot WHERE ot.cid = ? AND ot.type = ? AND ot.created_from = ? AND (SELECT COUNT(op.permission_id) FROM oxfolder_permissions AS op WHERE op.cid = ot.cid AND op.fuid = ot.fuid) > 1 GROUP BY ot.fuid";
    private static final String SQL_UPDATE_LAST_MOD = "UPDATE oxfolder_tree SET changing_date = ?, changed_from = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_UPDATE_LAST_MOD2 = "UPDATE oxfolder_tree SET changing_date = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_UPDATE_NAME = "UPDATE oxfolder_tree SET fname = ?, changing_date = ?, changed_from = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_LOOKUPFOLDER = "SELECT fuid,fname FROM oxfolder_tree WHERE cid=? AND parent=? AND fname=? AND module=?";
    private static final String SQL_EXISTS = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND fuid = ?";
    private static final String SQL_UPDATE_PERMS = "UPDATE oxfolder_permissions SET fp = ?, orp = ?, owp = ?, odp = ? WHERE cid = ? AND fuid = ? AND permission_id = ?";
    private static final String SQL_ADD_PERMS = "INSERT INTO oxfolder_permissions (cid, fuid, permission_id, group_flag, fp, orp, owp, odp, admin_flag, system) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_REM_SINGLE_SYS_PERM = "DELETE FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND permission_id = ? AND system = 1";
    private static final String SQL_REM_ALL_SYS_PERM = "DELETE FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND system = 1";
    private static final String SQL_GETSUBFLDIDS = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND parent = ?";
    private static final String SQL_UDTSUBFLDFLG = "UPDATE oxfolder_tree SET subfolder_flag = ?, changing_date = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_NUMSUB = "SELECT COUNT(ot.fuid) FROM oxfolder_tree AS ot JOIN oxfolder_permissions AS op ON ot.fuid = op.fuid AND ot.cid = ? AND op.cid = ? WHERE op.permission_id IN #IDS# AND op.admin_flag > 0 AND ot.parent = ?";
    private static final String SQL_INSERT_NEW_FOLDER = "INSERT INTO oxfolder_tree VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_INSERT_NEW_PERMISSIONS = "INSERT INTO oxfolder_permissions (cid, fuid, permission_id, fp, orp, owp, odp, admin_flag, group_flag) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String SQL_UPDATE_PARENT_SUBFOLDER_FLAG = "UPDATE oxfolder_tree SET subfolder_flag = 1, changing_date = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_UPDATE_WITH_FOLDERNAME = "UPDATE oxfolder_tree SET fname = ?, changing_date = ?, changed_from = ?, permission_flag = ?, module = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_UPDATE_WITHOUT_FOLDERNAME = "UPDATE oxfolder_tree SET changing_date = ?, changed_from = ?, permission_flag = ?, module = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_EXISTING_PERMISSIONS = "DELETE FROM oxfolder_permissions WHERE cid = ? AND fuid = ? AND system = 0";
    private static final String SQL_MOVE_UPDATE = "UPDATE oxfolder_tree SET parent = ?, changing_date = ?, changed_from = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_MOVE_SELECT = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND parent = ?";
    private static final String SQL_MOVE_UPDATE2 = "UPDATE oxfolder_tree SET subfolder_flag = ?, changing_date = ?, changed_from = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_RENAME_UPDATE = "UPDATE oxfolder_tree SET fname = ?, changing_date = ?, changed_from = ? where cid = ? AND fuid = ?";
    private static final String STR_OXFOLDERTREE = "oxfolder_tree";
    private static final String STR_OXFOLDERPERMS = "oxfolder_permissions";
    private static final String STR_DELOXFOLDERTREE = "del_oxfolder_tree";
    private static final String STR_DELOXFOLDERPERMS = "del_oxfolder_permissions";
    private static final String SQL_DELETE_INSERT_OT = "INSERT INTO del_oxfolder_tree SELECT * FROM oxfolder_tree WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_INSERT_OP = "INSERT INTO del_oxfolder_permissions SELECT * FROM oxfolder_permissions WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_DELETE_SF = "DELETE FROM oxfolder_specialfolders WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_DELETE = "DELETE FROM #TABLE# WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_UPDATE = "UPDATE del_oxfolder_tree SET changing_date = ?, changed_from = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_RESTORE_OT = "INSERT INTO oxfolder_tree SELECT * FROM del_oxfolder_tree WHERE cid = ? AND fuid = ?";
    private static final String SQL_RESTORE_OP = "INSERT INTO oxfolder_permissions SELECT * FROM del_oxfolder_permissions WHERE cid = ? AND fuid = ?";
    private static final Lock NEXTSERIAL_LOCK = new ReentrantLock();
    private static final String TMPL_FOLDER_TABLE = "#FOLDER#";
    private static final String TMPL_PERM_TABLE = "#PERM#";
    private static final String TMPL_IDS = "#IDS#";
    private static final String SQL_DROP_SYS_PERMS = "DELETE FROM #PERM# WHERE cid = ? AND permission_id = ? AND system > 0";
    private static final String SQL_GET_CONTEXT_MAILADMIN = "SELECT user FROM user_setting_admin WHERE cid = ?";
    private static final String SQL_SEL_PERMS = "SELECT ot.fuid, ot.type FROM #PERM# AS op JOIN #FOLDER# AS ot ON op.fuid = ot.fuid AND op.cid = ? AND ot.cid = ? WHERE op.permission_id IN #IDS# GROUP BY ot.fuid";
    private static final String SQL_DELETE_PERMS = "DELETE FROM #PERM# WHERE cid = ? AND fuid = ? AND permission_id = ?";
    private static final String SQL_REASSIGN_PERMS = "UPDATE #PERM# SET permission_id = ?, group_flag = 0 WHERE cid = ? AND fuid = ? AND permission_id = ?";
    private static final String SQL_REASSIGN_UPDATE_TIMESTAMP = "UPDATE #FOLDER# SET changed_from = ?, changing_date = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_REASSIGN_DEL_PERM = "DELETE FROM #PERM# WHERE cid = ? AND permission_id = ? AND fuid = ?";
    private static final String SQL_REASSIGN_UPDATE_PERM = "UPDATE #PERM# SET fp = ?, orp = ?, owp = ?, odp = ?, admin_flag = ?, group_flag = ? WHERE cid = ? AND permission_id = ? AND fuid = ?";
    private static final String SQL_REASSIGN_SEL_PERM = "SELECT fp, orp, owp, odp, admin_flag FROM #PERM# WHERE cid = ? AND permission_id = ? AND fuid = ?";
    private static final String SQL_SEL_FOLDERS = "SELECT ot.fuid, ot.type FROM #FOLDER# AS ot WHERE ot.cid = ? AND ot.created_from = ?";
    private static final String SQL_SEL_FOLDERS2 = "SELECT ot.fuid FROM #FOLDER# AS ot WHERE ot.cid = ? AND ot.changed_from = ?";
    private static final String SQL_DELETE_FOLDER = "DELETE FROM #FOLDER# WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_SPECIAL_REFS = "DELETE FROM oxfolder_specialfolders WHERE cid = ? AND fuid = ?";
    private static final String SQL_DELETE_FOLDER_PERMS = "DELETE FROM #PERM# WHERE cid = ? AND fuid = ?";
    private static final String SQL_REASSIGN_FOLDERS = "UPDATE #FOLDER# SET created_from = ?, changed_from = ?, changing_date = ?, default_flag = 0 WHERE cid = ? AND fuid = ?";
    private static final String SQL_REASSIGN_FOLDERS_WITH_NAME = "UPDATE #FOLDER# SET created_from = ?, changed_from = ?, changing_date = ?, default_flag = 0, fname = ? WHERE cid = ? AND fuid = ?";
    private static final String SQL_DEF_INF = "SELECT fname FROM #FOLDER# WHERE cid = ? AND fuid = ? AND module = ? AND created_from = ? AND default_flag = 1";

    private OXFolderSQL() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getNonExistingParents(Context ctx) throws OXException {
        Connection con = DBPool.pickup(ctx);
        try {
            int[] nArray = OXFolderSQL.getNonExistingParents(ctx, con);
            return nArray;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    public static int[] getNonExistingParents(Context ctx, Connection con) throws OXException {
        int[] nArray;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_WITH_NON_EXISTING_PARENT);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            rs = OXFolderSQL.executeQuery(stmt);
            TIntHashSet set = new TIntHashSet(16);
            while (rs.next()) {
                set.add(rs.getInt(1));
            }
            nArray = set.toArray();
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getContextAdminID(Context ctx, Connection readConArg) throws OXException, SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection readCon;
        block4: {
            int n;
            readCon = readConArg;
            closeReadCon = false;
            stmt = null;
            rs = null;
            try {
                if (readCon == null) {
                    readCon = DBPool.pickup(ctx);
                    closeReadCon = true;
                }
                stmt = readCon.prepareStatement("SELECT user FROM user_setting_admin WHERE cid = ?");
                stmt.setInt(1, ctx.getContextId());
                rs = OXFolderSQL.executeQuery(stmt);
                if (rs.next()) break block4;
                n = -1;
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
                throw throwable;
            }
            return n;
        }
        int n = rs.getInt(1);
        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUserDefaultFolder(int userId, int module, Connection readCon, Context ctx) throws OXException, SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection rc;
        block4: {
            int n;
            rc = readCon;
            closeReadCon = false;
            stmt = null;
            rs = null;
            try {
                if (rc == null) {
                    rc = DBPool.pickup(ctx);
                    closeReadCon = true;
                }
                stmt = rc.prepareStatement(SQL_DEFAULTFLD);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, userId);
                stmt.setInt(3, module);
                rs = OXFolderSQL.executeQuery(stmt);
                if (!rs.next()) break block4;
                n = rs.getInt(1);
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
                throw throwable;
            }
            return n;
        }
        int n = -1;
        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? rc : null, true, ctx);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TIntCollection getSharedFoldersOf(int owner, Connection readConArg, Context ctx) throws OXException, SQLException {
        TIntArrayList tIntArrayList;
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection readCon;
        block5: {
            readCon = readConArg;
            closeReadCon = false;
            stmt = null;
            rs = null;
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement(SQL_SELECT_ALL_SHARED_FLDS);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, 1);
            stmt.setInt(3, owner);
            rs = OXFolderSQL.executeQuery(stmt);
            if (rs.next()) break block5;
            TIntArrayList tIntArrayList2 = new TIntArrayList(0);
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            return tIntArrayList2;
        }
        try {
            TIntArrayList sia = new TIntArrayList(16);
            do {
                sia.add(rs.getInt(1));
            } while (rs.next());
            tIntArrayList = sia;
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return tIntArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLastModified(int folderId, long lastModified, int modifiedBy, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection writeCon = writeConArg;
        boolean closeWriteCon = false;
        PreparedStatement stmt = null;
        try {
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            stmt = writeCon.prepareStatement(SQL_UPDATE_LAST_MOD);
            stmt.setLong(1, lastModified);
            stmt.setInt(2, modifiedBy);
            stmt.setInt(3, ctx.getContextId());
            stmt.setInt(4, folderId);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLastModified(int folderId, long lastModified, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection writeCon = writeConArg;
        boolean closeWriteCon = false;
        PreparedStatement stmt = null;
        try {
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            stmt = writeCon.prepareStatement(SQL_UPDATE_LAST_MOD2);
            stmt.setLong(1, lastModified);
            stmt.setInt(2, ctx.getContextId());
            stmt.setInt(3, folderId);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateName(int folderId, String newName, long lastModified, int modifiedBy, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection writeCon = writeConArg;
        boolean closeWriteCon = false;
        PreparedStatement stmt = null;
        try {
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            stmt = writeCon.prepareStatement(SQL_UPDATE_NAME);
            stmt.setString(1, newName);
            stmt.setLong(2, lastModified);
            stmt.setInt(3, modifiedBy);
            stmt.setInt(4, ctx.getContextId());
            stmt.setInt(5, folderId);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TIntList lookUpFolders(int parent, String folderName, int module, Connection readConArg, Context ctx) throws OXException, SQLException {
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        TIntLinkedList folderList = new TIntLinkedList();
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement(SQL_LOOKUPFOLDER);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, parent);
            stmt.setString(3, folderName);
            stmt.setInt(4, module);
            rs = OXFolderSQL.executeQuery(stmt);
            while (rs.next()) {
                int fuid = rs.getInt(1);
                String fname = rs.getString(2);
                if (!folderName.equals(fname)) continue;
                folderList.add(fuid);
            }
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return folderList;
    }

    public static int lookUpFolder(int parent, String folderName, int module, Connection readConArg, Context ctx) throws OXException, SQLException {
        return OXFolderSQL.lookUpFolderOnUpdate(-1, parent, folderName, module, readConArg, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int lookUpFolderOnUpdate(int folderId, int parent, String folderName, int module, Connection readConArg, Context ctx) throws OXException, SQLException {
        int n;
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ConfigurationService service;
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            StringBuilder stmtBuilder = new StringBuilder("SELECT fuid,fname FROM oxfolder_tree WHERE cid=? AND parent=? AND fname=?");
            if (module > 0 && null != (service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class)) && service.getBoolProperty("com.openexchange.oxfolder.considerModuleOnDuplicateCheck", false)) {
                stmtBuilder.append(" AND module=").append(module);
            }
            if (folderId > 0) {
                stmtBuilder.append(" AND fuid!=").append(folderId);
            }
            stmt = readCon.prepareStatement(stmtBuilder.toString());
            stmtBuilder = null;
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, parent);
            stmt.setString(3, folderName);
            rs = OXFolderSQL.executeQuery(stmt);
            while (rs.next()) {
                int fuid = rs.getInt(1);
                String fname = rs.getString(2);
                if (!folderName.equals(fname)) break block7;
                n = fuid;
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        {
            block7: {
                return n;
            }
            continue;
        }
        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(int folderId, Connection readConArg, Context ctx) throws OXException, SQLException {
        boolean bl;
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement(SQL_EXISTS);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = OXFolderSQL.executeQuery(stmt);
            bl = rs.next();
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(int folderId, Connection readConArg, Context ctx, String table) throws OXException, SQLException {
        boolean bl;
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement(new StringBuilder(40).append("SELECT fuid FROM ").append(table).append(" WHERE cid = ? AND fuid = ?").toString());
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = OXFolderSQL.executeQuery(stmt);
            bl = rs.next();
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateSinglePermission(int folderId, int permissionId, int folderPermission, int objectReadPermission, int objectWritePermission, int objectDeletePermission, Connection writeCon, Context ctx) throws OXException, SQLException {
        PreparedStatement stmt;
        boolean closeWriteCon;
        Connection wc;
        block4: {
            boolean bl;
            wc = writeCon;
            closeWriteCon = false;
            stmt = null;
            try {
                if (wc == null) {
                    wc = DBPool.pickupWriteable(ctx);
                    closeWriteCon = true;
                }
                stmt = wc.prepareStatement(SQL_UPDATE_PERMS);
                int pos = 1;
                stmt.setInt(pos++, folderPermission);
                stmt.setInt(pos++, objectReadPermission);
                stmt.setInt(pos++, objectWritePermission);
                stmt.setInt(pos++, objectDeletePermission);
                stmt.setInt(pos++, ctx.getContextId());
                stmt.setInt(pos++, folderId);
                stmt.setInt(pos++, permissionId);
                if (OXFolderSQL.executeUpdate(stmt) == 1) break block4;
                bl = false;
                DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
                throw throwable;
            }
            return bl;
        }
        DBUtils.closeSQLStuff(null, stmt);
        stmt = null;
        OXFolderSQL.updateLastModified(folderId, System.currentTimeMillis(), wc, ctx);
        boolean bl = true;
        DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addSinglePermission(int folderId, int permissionId, boolean isGroup, int folderPermission, int objectReadPermission, int objectWritePermission, int objectDeletePermission, boolean isAdmin, int system, Connection writeCon, Context ctx) throws OXException, SQLException {
        boolean bl;
        Connection wc = writeCon;
        boolean closeWriteCon = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            stmt = wc.prepareStatement(SQL_ADD_PERMS);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, folderId);
            stmt.setInt(pos++, permissionId);
            stmt.setInt(pos++, isGroup ? 1 : 0);
            stmt.setInt(pos++, folderPermission);
            stmt.setInt(pos++, objectReadPermission);
            stmt.setInt(pos++, objectWritePermission);
            stmt.setInt(pos++, objectDeletePermission);
            stmt.setInt(pos++, isAdmin ? 1 : 0);
            stmt.setInt(pos++, system);
            bl = OXFolderSQL.executeUpdate(stmt) == 1;
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteSingleSystemPermission(int folderId, int permissionId, Connection writeCon, Context ctx) throws OXException, SQLException {
        boolean bl;
        Connection wc = writeCon;
        boolean closeWriteCon = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            stmt = wc.prepareStatement(SQL_REM_SINGLE_SYS_PERM);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, folderId);
            stmt.setInt(pos++, permissionId);
            bl = OXFolderSQL.executeUpdate(stmt) == 1;
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllSystemPermission(int folderId, Connection writeCon, Context ctx) throws OXException, SQLException {
        Connection wc = writeCon;
        boolean closeWriteCon = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            stmt = wc.prepareStatement(SQL_REM_ALL_SYS_PERM);
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, folderId);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TIntList getSubfolderIDs(int folderId, Connection readConArg, Context ctx) throws OXException, SQLException {
        TIntArrayList retval = new TIntArrayList();
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid = ? AND parent = ?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            rs = OXFolderSQL.executeQuery(stmt);
            while (rs.next()) {
                retval.add(rs.getInt(1));
            }
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateSubfolderFlag(int folderId, boolean hasSubfolders, long lastModified, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection writeCon = writeConArg;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        try {
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeCon = true;
            }
            stmt = writeCon.prepareStatement(SQL_UDTSUBFLDFLG);
            stmt.setInt(1, hasSubfolders ? 1 : 0);
            stmt.setLong(2, lastModified);
            stmt.setInt(3, ctx.getContextId());
            stmt.setInt(4, folderId);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeCon ? writeCon : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeCon ? writeCon : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumOfMoveableSubfolders(int folderId, int userId, int[] groups, Connection readConArg, Context ctx) throws OXException, SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection readCon;
        block3: {
            int n;
            readCon = readConArg;
            closeReadCon = false;
            stmt = null;
            rs = null;
            try {
                if (readCon == null) {
                    readCon = DBPool.pickup(ctx);
                    closeReadCon = true;
                }
                stmt = readCon.prepareStatement(SQL_NUMSUB.replaceFirst(TMPL_IDS, StringCollection.getSqlInString(userId, groups)));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, ctx.getContextId());
                stmt.setInt(3, folderId);
                rs = OXFolderSQL.executeQuery(stmt);
                if (!rs.next()) break block3;
                n = rs.getInt(1);
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, stmt, closeReadCon ? readCon : null, true, ctx);
                throw throwable;
            }
            return n;
        }
        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        return 0;
    }

    static void insertFolderSQL(int newFolderID, int userId, FolderObject folderObj, long creatingTime, Context ctx, Connection writeConArg) throws SQLException, OXException {
        OXFolderSQL.insertFolderSQL(newFolderID, userId, folderObj, creatingTime, false, ctx, writeConArg);
    }

    static void insertDefaultFolderSQL(int newFolderID, int userId, FolderObject folderObj, long creatingTime, Context ctx, Connection writeConArg) throws SQLException, OXException {
        OXFolderSQL.insertFolderSQL(newFolderID, userId, folderObj, creatingTime, true, ctx, writeConArg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertFolderSQL(int newFolderID, int userId, FolderObject folderObj, long creatingTime, boolean acceptDefaultFlag, Context ctx, Connection writeConArg) throws SQLException, OXException {
        int permissionFlag;
        Connection writeCon;
        block23: {
            block22: {
                writeCon = writeConArg;
                permissionFlag = 3;
                if (folderObj.getType() != 1) break block22;
                if (folderObj.getPermissions().size() != 1) break block23;
                permissionFlag = 1;
                break block23;
            }
            if (folderObj.getType() == 2) {
                int permissionsSize = folderObj.getPermissions().size();
                Iterator<OCLPermission> iter = folderObj.getPermissions().iterator();
                for (int i = 0; i < permissionsSize; ++i) {
                    OCLPermission oclPerm = iter.next();
                    if (oclPerm.getEntity() != 0 || oclPerm.getFolderPermission() <= 0) continue;
                    permissionFlag = 2;
                    break;
                }
            }
        }
        boolean closeWriteCon = false;
        try {
            boolean isAuto;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            if (isAuto = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            try {
                PreparedStatement stmt = null;
                try {
                    OCLPermission[] permissions;
                    stmt = writeCon.prepareStatement(SQL_INSERT_NEW_FOLDER);
                    stmt.setInt(1, newFolderID);
                    stmt.setInt(2, ctx.getContextId());
                    stmt.setInt(3, folderObj.getParentFolderID());
                    stmt.setString(4, folderObj.getFolderName());
                    stmt.setInt(5, folderObj.getModule());
                    stmt.setInt(6, folderObj.getType());
                    stmt.setLong(7, creatingTime);
                    stmt.setInt(8, folderObj.containsCreatedBy() ? folderObj.getCreatedBy() : userId);
                    stmt.setLong(9, creatingTime);
                    stmt.setInt(10, userId);
                    stmt.setInt(11, permissionFlag);
                    stmt.setInt(12, 0);
                    if (acceptDefaultFlag) {
                        stmt.setInt(13, folderObj.isDefaultFolder() ? 1 : 0);
                    } else {
                        stmt.setInt(13, 0);
                    }
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                    stmt = writeCon.prepareStatement(SQL_UPDATE_PARENT_SUBFOLDER_FLAG);
                    stmt.setLong(1, creatingTime);
                    stmt.setInt(2, ctx.getContextId());
                    stmt.setInt(3, folderObj.getParentFolderID());
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                    stmt = writeCon.prepareStatement(SQL_INSERT_NEW_PERMISSIONS);
                    for (OCLPermission ocl : permissions = folderObj.getNonSystemPermissionsAsArray()) {
                        stmt.setInt(1, ctx.getContextId());
                        stmt.setInt(2, newFolderID);
                        stmt.setInt(3, ocl.getEntity());
                        stmt.setInt(4, ocl.getFolderPermission());
                        stmt.setInt(5, ocl.getReadPermission());
                        stmt.setInt(6, ocl.getWritePermission());
                        stmt.setInt(7, ocl.getDeletePermission());
                        stmt.setInt(8, ocl.isFolderAdmin() ? 1 : 0);
                        stmt.setInt(9, ocl.isGroupPermission() ? 1 : 0);
                        stmt.addBatch();
                    }
                    OXFolderSQL.executeBatch(stmt);
                    stmt.close();
                    stmt = null;
                    Date creatingDate = new Date(creatingTime);
                    folderObj.setObjectID(newFolderID);
                    folderObj.setCreationDate(creatingDate);
                    folderObj.setCreatedBy(userId);
                    folderObj.setLastModified(creatingDate);
                    folderObj.setModifiedBy(userId);
                    folderObj.setSubfolderFlag(false);
                    if (!acceptDefaultFlag) {
                        folderObj.setDefaultFolder(false);
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
            }
            catch (SQLException e) {
                if (isAuto) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
                throw e;
            }
            if (isAuto) {
                writeCon.commit();
                writeCon.setAutoCommit(true);
            }
        }
        finally {
            if (closeWriteCon && writeCon != null) {
                DBPool.closeWriterSilent(ctx, writeCon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateFolderSQL(int userId, FolderObject folderObj, long lastModified, Context ctx, Connection writeConArg) throws SQLException, OXException {
        int permissionFlag;
        Connection writeCon;
        block22: {
            block21: {
                writeCon = writeConArg;
                permissionFlag = 3;
                if (folderObj.getType() != 1) break block21;
                if (folderObj.getPermissions().size() != 1) break block22;
                permissionFlag = 1;
                break block22;
            }
            if (folderObj.getType() == 2) {
                int permissionsSize = folderObj.getPermissions().size();
                Iterator<OCLPermission> iter = folderObj.getPermissions().iterator();
                for (int i = 0; i < permissionsSize; ++i) {
                    OCLPermission oclPerm = iter.next();
                    if (oclPerm.getEntity() != 0 || oclPerm.getFolderPermission() <= 0) continue;
                    permissionFlag = 2;
                    break;
                }
            }
        }
        boolean closeWriteCon = false;
        try {
            boolean isAuto;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            if (isAuto = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            Statement stmt = null;
            try {
                OCLPermission[] permissions;
                int pos = 1;
                if (folderObj.containsFolderName()) {
                    stmt = writeCon.prepareStatement(SQL_UPDATE_WITH_FOLDERNAME);
                    stmt.setString(pos++, folderObj.getFolderName());
                    stmt.setLong(pos++, lastModified);
                    stmt.setInt(pos++, userId);
                    stmt.setInt(pos++, permissionFlag);
                    stmt.setInt(pos++, folderObj.getModule());
                    stmt.setInt(pos++, ctx.getContextId());
                    stmt.setInt(pos++, folderObj.getObjectID());
                    OXFolderSQL.executeUpdate((PreparedStatement)stmt);
                    stmt.close();
                    stmt = null;
                } else {
                    stmt = writeCon.prepareStatement(SQL_UPDATE_WITHOUT_FOLDERNAME);
                    stmt.setLong(pos++, lastModified);
                    stmt.setInt(pos++, userId);
                    stmt.setInt(pos++, permissionFlag);
                    stmt.setInt(pos++, folderObj.getModule());
                    stmt.setInt(pos++, ctx.getContextId());
                    stmt.setInt(pos++, folderObj.getObjectID());
                    OXFolderSQL.executeUpdate((PreparedStatement)stmt);
                    stmt.close();
                    stmt = null;
                }
                stmt = writeCon.prepareStatement(SQL_DELETE_EXISTING_PERMISSIONS);
                pos = 1;
                stmt.setInt(pos++, ctx.getContextId());
                stmt.setInt(pos++, folderObj.getObjectID());
                OXFolderSQL.executeUpdate((PreparedStatement)stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_INSERT_NEW_PERMISSIONS);
                for (OCLPermission oclPerm : permissions = folderObj.getNonSystemPermissionsAsArray()) {
                    pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    stmt.setInt(pos++, folderObj.getObjectID());
                    stmt.setInt(pos++, oclPerm.getEntity());
                    stmt.setInt(pos++, oclPerm.getFolderPermission());
                    stmt.setInt(pos++, oclPerm.getReadPermission());
                    stmt.setInt(pos++, oclPerm.getWritePermission());
                    stmt.setInt(pos++, oclPerm.getDeletePermission());
                    stmt.setInt(pos++, oclPerm.isFolderAdmin() ? 1 : 0);
                    stmt.setInt(pos++, oclPerm.isGroupPermission() ? 1 : 0);
                    stmt.addBatch();
                }
                OXFolderSQL.executeBatch((PreparedStatement)stmt);
                stmt.close();
                stmt = null;
            }
            catch (SQLException e) {
                if (isAuto) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
                throw e;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            if (isAuto) {
                writeCon.commit();
                writeCon.setAutoCommit(true);
            }
        }
        finally {
            if (closeWriteCon && writeCon != null) {
                DBPool.closeWriterSilent(ctx, writeCon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void moveFolderSQL(int userId, FolderObject src, FolderObject dest, long lastModified, Context ctx, Connection readConArg, Connection writeConArg) throws SQLException, OXException {
        ResultSet subFolderRS;
        PreparedStatement pst;
        boolean closeWriteCon;
        Connection writeCon;
        block10: {
            writeCon = writeConArg;
            closeWriteCon = false;
            Connection readCon = readConArg;
            pst = null;
            subFolderRS = null;
            try {
                boolean isAuto;
                if (writeCon == null) {
                    writeCon = DBPool.pickupWriteable(ctx);
                    closeWriteCon = true;
                }
                if (readCon == null) {
                    readCon = writeCon;
                }
                if (isAuto = writeCon.getAutoCommit()) {
                    writeCon.setAutoCommit(false);
                }
                try {
                    pst = writeCon.prepareStatement(SQL_MOVE_UPDATE);
                    pst.setInt(1, dest.getObjectID());
                    pst.setLong(2, lastModified);
                    pst.setInt(3, src.getType() == 5 ? ctx.getMailadmin() : userId);
                    pst.setInt(4, ctx.getContextId());
                    pst.setInt(5, src.getObjectID());
                    OXFolderSQL.executeUpdate(pst);
                    pst.close();
                    pst = null;
                    pst = readCon.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid = ? AND parent = ?");
                    pst.setInt(1, ctx.getContextId());
                    pst.setInt(2, src.getParentFolderID());
                    subFolderRS = OXFolderSQL.executeQuery(pst);
                    boolean srcParentHasSubfolders = subFolderRS.next();
                    subFolderRS.close();
                    subFolderRS = null;
                    pst.close();
                    pst = null;
                    pst = writeCon.prepareStatement(SQL_MOVE_UPDATE2);
                    pst.setInt(1, 1);
                    pst.setLong(2, lastModified);
                    pst.setInt(3, dest.getType() == 5 ? ctx.getMailadmin() : userId);
                    pst.setInt(4, ctx.getContextId());
                    pst.setInt(5, dest.getObjectID());
                    pst.addBatch();
                    pst.setInt(1, srcParentHasSubfolders ? 1 : 0);
                    pst.setLong(2, lastModified);
                    pst.setInt(3, src.getType() == 5 ? ctx.getMailadmin() : userId);
                    pst.setInt(4, ctx.getContextId());
                    pst.setInt(5, src.getParentFolderID());
                    pst.addBatch();
                    OXFolderSQL.executeBatch(pst);
                    pst.close();
                    pst = null;
                }
                catch (SQLException se) {
                    if (isAuto) {
                        writeCon.rollback();
                        writeCon.setAutoCommit(true);
                    }
                    throw se;
                }
                if (!isAuto) break block10;
                writeCon.commit();
                writeCon.setAutoCommit(true);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(subFolderRS, pst);
                if (closeWriteCon && writeCon != null) {
                    DBPool.closeWriterSilent(ctx, writeCon);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(subFolderRS, pst);
        if (closeWriteCon && writeCon != null) {
            DBPool.closeWriterSilent(ctx, writeCon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renameFolderSQL(int userId, FolderObject folderObj, long lastModified, Context ctx, Connection writeConArg) throws SQLException, OXException {
        Connection writeCon = writeConArg;
        boolean closeWriteCon = false;
        try {
            boolean isAuto;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            if (isAuto = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            try {
                pst = writeCon.prepareStatement(SQL_RENAME_UPDATE);
                pst.setString(1, folderObj.getFolderName());
                pst.setLong(2, lastModified);
                pst.setInt(3, userId);
                pst.setInt(4, ctx.getContextId());
                pst.setInt(5, folderObj.getObjectID());
                OXFolderSQL.executeUpdate(pst);
                pst.close();
                pst = null;
            }
            catch (SQLException sqle) {
                if (isAuto) {
                    writeCon.rollback();
                    writeCon.setAutoCommit(true);
                }
                throw sqle;
            }
            finally {
                if (pst != null) {
                    pst.close();
                    pst = null;
                }
            }
            if (isAuto) {
                writeCon.commit();
                writeCon.setAutoCommit(true);
            }
        }
        finally {
            if (closeWriteCon && writeCon != null) {
                DBPool.closeWriterSilent(ctx, writeCon);
            }
        }
    }

    static void delWorkingOXFolder(int folderId, int userId, long lastModified, Context ctx, Connection writeConArg) throws SQLException, OXException {
        OXFolderSQL.delOXFolder(folderId, userId, lastModified, true, true, ctx, writeConArg);
    }

    static void delOXFolder(int folderId, int userId, long lastModified, boolean deleteWorking, boolean createBackup, Context ctx, Connection writeConArg) throws SQLException, OXException {
        PreparedStatement stmt;
        boolean isAuto;
        boolean closeWriteCon;
        Connection writeCon;
        block14: {
            writeCon = writeConArg;
            closeWriteCon = false;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            if (isAuto = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            String folderTable = deleteWorking ? STR_OXFOLDERTREE : STR_DELOXFOLDERTREE;
            String permTable = deleteWorking ? STR_OXFOLDERPERMS : STR_DELOXFOLDERPERMS;
            boolean backup = createBackup && deleteWorking;
            stmt = null;
            try {
                if (backup) {
                    stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERPERMS));
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                    stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERTREE));
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                    stmt = writeCon.prepareStatement(SQL_DELETE_INSERT_OT);
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                    stmt = writeCon.prepareStatement(SQL_DELETE_INSERT_OP);
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                }
                if (deleteWorking) {
                    stmt = writeCon.prepareStatement("DELETE FROM oxfolder_specialfolders WHERE cid = ? AND fuid = ?");
                    stmt.setInt(1, ctx.getContextId());
                    stmt.setInt(2, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                }
                stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", permTable));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", folderTable));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                if (backup) {
                    stmt = writeCon.prepareStatement(SQL_DELETE_UPDATE);
                    stmt.setLong(1, lastModified);
                    stmt.setInt(2, userId);
                    stmt.setInt(3, ctx.getContextId());
                    stmt.setInt(4, folderId);
                    OXFolderSQL.executeUpdate(stmt);
                    stmt.close();
                    stmt = null;
                }
                if (!isAuto) break block14;
                writeCon.commit();
            }
            catch (SQLException e) {
                try {
                    if (isAuto) {
                        DBUtils.rollback(writeCon);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(stmt);
                    if (isAuto) {
                        DBUtils.autocommit(writeCon);
                    }
                    if (closeWriteCon) {
                        DBPool.closeWriterSilent(ctx, writeCon);
                    }
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(stmt);
        if (isAuto) {
            DBUtils.autocommit(writeCon);
        }
        if (closeWriteCon) {
            DBPool.closeWriterSilent(ctx, writeCon);
        }
    }

    static void backupOXFolder(int folderId, int userId, long lastModified, Context ctx, Connection writeConArg) throws SQLException, OXException {
        PreparedStatement stmt;
        boolean isAuto;
        boolean closeWriteCon;
        Connection writeCon;
        block11: {
            writeCon = writeConArg;
            closeWriteCon = false;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            if (isAuto = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            stmt = null;
            try {
                stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERPERMS));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERTREE));
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_INSERT_OT);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_INSERT_OP);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                stmt = writeCon.prepareStatement(SQL_DELETE_UPDATE);
                stmt.setLong(1, lastModified);
                stmt.setInt(2, userId);
                stmt.setInt(3, ctx.getContextId());
                stmt.setInt(4, folderId);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                if (!isAuto) break block11;
                writeCon.commit();
            }
            catch (SQLException e) {
                try {
                    if (isAuto) {
                        DBUtils.rollback(writeCon);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(stmt);
                    if (isAuto) {
                        DBUtils.autocommit(writeCon);
                    }
                    if (closeWriteCon) {
                        DBPool.closeWriterSilent(ctx, writeCon);
                    }
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(stmt);
        if (isAuto) {
            DBUtils.autocommit(writeCon);
        }
        if (closeWriteCon) {
            DBPool.closeWriterSilent(ctx, writeCon);
        }
    }

    public static void restore(int folderId, Context ctx, Connection writeConArg) throws OXException, SQLException {
        boolean isAuto;
        Connection writeCon = writeConArg;
        boolean closeWriteCon = false;
        if (writeCon == null) {
            writeCon = DBPool.pickupWriteable(ctx);
            closeWriteCon = true;
        }
        if (isAuto = writeCon.getAutoCommit()) {
            writeCon.setAutoCommit(false);
        }
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_RESTORE_OT);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            OXFolderSQL.executeUpdate(stmt);
            stmt.close();
            stmt = null;
            stmt = writeCon.prepareStatement(SQL_RESTORE_OP);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            OXFolderSQL.executeUpdate(stmt);
            stmt.close();
            stmt = null;
            stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERPERMS));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            OXFolderSQL.executeUpdate(stmt);
            stmt.close();
            stmt = null;
            stmt = writeCon.prepareStatement(SQL_DELETE_DELETE.replaceFirst("#TABLE#", STR_DELOXFOLDERTREE));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, folderId);
            OXFolderSQL.executeUpdate(stmt);
            stmt.close();
            stmt = null;
            if (isAuto) {
                writeCon.commit();
            }
        }
        catch (SQLException e) {
            if (isAuto) {
                DBUtils.rollback(writeCon);
            }
            throw e;
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            if (isAuto) {
                DBUtils.autocommit(writeCon);
            }
            if (closeWriteCon) {
                DBPool.closeWriterSilent(ctx, writeCon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextSerial(Context ctx, Connection callWriteConArg) throws SQLException, OXException {
        NEXTSERIAL_LOCK.lock();
        try {
            int n;
            block16: {
                Connection callWriteCon = callWriteConArg;
                boolean closeCon = false;
                boolean isAuto = false;
                try {
                    if (callWriteCon == null) {
                        callWriteCon = DBPool.pickupWriteable(ctx);
                        closeCon = true;
                    }
                    if (isAuto = callWriteCon.getAutoCommit()) {
                        callWriteCon.setAutoCommit(false);
                    } else {
                        callWriteCon.commit();
                    }
                    int id = IDGenerator.getId(ctx, 20, callWriteCon);
                    if (isAuto) {
                        callWriteCon.commit();
                        callWriteCon.setAutoCommit(true);
                    } else {
                        callWriteCon.commit();
                    }
                    n = id;
                    if (!closeCon || callWriteCon == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (closeCon && callWriteCon != null) {
                            DBPool.pushWrite(ctx, callWriteCon);
                        }
                        throw throwable;
                    }
                    catch (OXException e) {
                        if (isAuto && callWriteCon != null) {
                            callWriteCon.rollback();
                            callWriteCon.setAutoCommit(true);
                        }
                        throw e;
                    }
                }
                DBPool.pushWrite(ctx, callWriteCon);
            }
            return n;
        }
        finally {
            NEXTSERIAL_LOCK.unlock();
        }
    }

    public static int getNextSerialForAdmin(Context ctx, Connection con) throws SQLException {
        return IDGenerator.getId(ctx, 20, con);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void hardDeleteOXFolder(int folderId, Context ctx, Connection writeConArg) throws SQLException, OXException {
        Statement stmt;
        boolean closeWrite;
        Connection writeCon;
        block10: {
            boolean isAuto;
            writeCon = writeConArg;
            closeWrite = false;
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            if (isAuto = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            stmt = null;
            try {
                String andClause = " AND fuid = ";
                stmt = writeCon.createStatement();
                stmt.addBatch("DELETE FROM oxfolder_specialfolders WHERE cid = " + ctx.getContextId() + " AND fuid = " + folderId);
                stmt.addBatch("DELETE FROM oxfolder_permissions WHERE cid = " + ctx.getContextId() + " AND fuid = " + folderId);
                stmt.addBatch("DELETE FROM oxfolder_tree WHERE cid = " + ctx.getContextId() + " AND fuid = " + folderId);
                stmt.executeBatch();
                if (isAuto) {
                    writeCon.commit();
                }
                if (!isAuto) break block10;
            }
            catch (SQLException e) {
                try {
                    if (!isAuto) throw e;
                    writeCon.rollback();
                    throw e;
                }
                catch (Throwable throwable) {
                    if (isAuto) {
                        DBUtils.autocommit(writeCon);
                    }
                    DBUtils.closeResources(null, stmt, closeWrite ? writeCon : null, false, ctx);
                    throw throwable;
                }
            }
            DBUtils.autocommit(writeCon);
        }
        DBUtils.closeResources(null, stmt, closeWrite ? writeCon : null, false, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanseSystemPermissions(int entity, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection writeCon = writeConArg;
        boolean createReadCon = false;
        PreparedStatement stmt = null;
        try {
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                createReadCon = true;
            }
            stmt = writeCon.prepareStatement(SQL_DROP_SYS_PERMS.replaceFirst(TMPL_PERM_TABLE, permTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, entity);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, createReadCon ? writeCon : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, createReadCon ? writeCon : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getContextMailAdmin(Connection readConArg, Context ctx) throws OXException, SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean createReadCon;
        Connection readCon;
        block4: {
            int n;
            readCon = readConArg;
            createReadCon = false;
            stmt = null;
            rs = null;
            try {
                if (readCon == null) {
                    readCon = DBPool.pickup(ctx);
                    createReadCon = true;
                }
                stmt = readCon.prepareStatement("SELECT user FROM user_setting_admin WHERE cid = ?");
                stmt.setInt(1, ctx.getContextId());
                rs = OXFolderSQL.executeQuery(stmt);
                if (!rs.next()) break block4;
                n = rs.getInt(1);
                DBUtils.closeResources(rs, (Statement)stmt, createReadCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, createReadCon ? readCon : null, true, ctx);
                throw throwable;
            }
            return n;
        }
        int n = -1;
        DBUtils.closeResources(rs, (Statement)stmt, createReadCon ? readCon : null, true, ctx);
        return n;
    }

    static void handleMailAdminPermissions(int mailAdmin, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        OXFolderSQL.handleEntityPermissions(mailAdmin, null, -1L, folderTable, permTable, readConArg, writeConArg, ctx);
    }

    static void handleEntityPermissions(int entity, int mailAdmin, long lastModified, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        OXFolderSQL.handleEntityPermissions(entity, (Integer)mailAdmin, lastModified, folderTable, permTable, readConArg, writeConArg, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleEntityPermissions(int entity, Integer mailAdmin, long lastModified, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isMailAdmin = mailAdmin == null;
        try {
            EventAdmin eventAdmin;
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            String permissionsIDs = isMailAdmin ? "" + '(' + entity + ',' + 0 + ')' : "" + '(' + entity + ')';
            stmt = readCon.prepareStatement(SQL_SEL_PERMS.replaceFirst(TMPL_PERM_TABLE, permTable).replaceFirst(TMPL_FOLDER_TABLE, folderTable).replaceFirst(TMPL_IDS, permissionsIDs));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, ctx.getContextId());
            rs = OXFolderSQL.executeQuery(stmt);
            TIntHashSet deletePerms = new TIntHashSet();
            TIntHashSet reassignPerms = new TIntHashSet();
            while (rs.next()) {
                int fuid = rs.getInt(1);
                int type = rs.getInt(2);
                if (isMailAdmin || OXFolderSQL.markForDeletion(type)) {
                    deletePerms.add(fuid);
                    continue;
                }
                reassignPerms.add(fuid);
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            OXFolderSQL.deletePermissions((TIntSet)deletePerms, entity, permTable, writeConArg, ctx);
            if (!isMailAdmin) {
                OXFolderSQL.reassignPermissions((TIntSet)reassignPerms, entity, mailAdmin, lastModified, folderTable, permTable, readCon, writeConArg, ctx);
            }
            ConditionTreeMapManagement.dropFor(ctx.getContextId());
            if (FolderCacheManager.isInitialized()) {
                try {
                    TIntIterator iter = deletePerms.iterator();
                    int i = deletePerms.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iter.next(), ctx);
                    }
                    iter = reassignPerms.iterator();
                    i = reassignPerms.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iter.next(), ctx);
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (null != (eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class))) {
                TIntIterator iter = deletePerms.iterator();
                int i = deletePerms.size();
                while (i-- > 0) {
                    OXFolderSQL.broadcastEvent(iter.next(), false, entity, ctx.getContextId(), eventAdmin);
                }
                iter = reassignPerms.iterator();
                i = reassignPerms.size();
                while (i-- > 0) {
                    OXFolderSQL.broadcastEvent(iter.next(), false, entity, ctx.getContextId(), eventAdmin);
                }
            }
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
    }

    private static void broadcastEvent(int fuid, boolean deleted, int entity, int contextId, EventAdmin eventAdmin) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(6);
        ((Dictionary)properties).put("com.openexchange.folderstorage.context", contextId);
        ((Dictionary)properties).put("com.openexchange.folderstorage.user", entity);
        ((Dictionary)properties).put("com.openexchange.folderstorage.folder", Integer.toString(fuid));
        ((Dictionary)properties).put("com.openexchange.folderstorage.content-related", !deleted);
        Event event = new Event("com/openexchange/folderstorage", properties);
        eventAdmin.sendEvent(event);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringBuilder(64).append("Notified ").append("content-related").append("-wise changed folder \"").append(fuid).append(" in context ").append(contextId).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deletePermissions(TIntSet deletePerms, int entity, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        int size = deletePerms.size();
        if (size == 0) {
            return;
        }
        TIntIterator iter = deletePerms.iterator();
        Connection wc = writeConArg;
        boolean closeWrite = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            stmt = wc.prepareStatement(SQL_DELETE_PERMS.replaceFirst(TMPL_PERM_TABLE, permTable));
            for (int i = 0; i < size; ++i) {
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, iter.next());
                stmt.setInt(3, entity);
                stmt.addBatch();
            }
            OXFolderSQL.executeBatch(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reassignPermissions(TIntSet reassignPerms, int entity, int mailAdmin, long lastModified, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        int size = reassignPerms.size();
        if (size == 0) {
            return;
        }
        Connection wc = writeConArg;
        boolean closeWrite = false;
        Connection rc = readConArg;
        boolean closeRead = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int i;
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            if (rc == null) {
                rc = DBPool.pickup(ctx);
                closeRead = true;
            }
            TIntIterator iter = reassignPerms.iterator();
            for (i = 0; i < size; ++i) {
                int fuid = iter.next();
                stmt = rc.prepareStatement("SELECT 1 FROM " + permTable + " WHERE cid = ? AND permission_id = ? AND fuid = ?");
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, mailAdmin);
                stmt.setInt(3, fuid);
                rs = OXFolderSQL.executeQuery(stmt);
                boolean hasPerm = rs.next();
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
                if (hasPerm) {
                    try {
                        OCLPermission mergedPerm = OXFolderSQL.getMergedPermission(entity, mailAdmin, fuid, permTable, readConArg, ctx);
                        OXFolderSQL.deleteSingleEntityPermission(entity, fuid, permTable, wc, ctx);
                        OXFolderSQL.updateSingleEntityPermission(mergedPerm, mailAdmin, fuid, permTable, wc, ctx);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                stmt = wc.prepareStatement(SQL_REASSIGN_PERMS.replaceFirst(TMPL_PERM_TABLE, permTable));
                stmt.setInt(1, mailAdmin);
                stmt.setInt(2, ctx.getContextId());
                stmt.setInt(3, fuid);
                stmt.setInt(4, entity);
                try {
                    OXFolderSQL.executeUpdate(stmt);
                    continue;
                }
                catch (SQLException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                finally {
                    stmt.close();
                }
            }
            stmt = wc.prepareStatement(SQL_REASSIGN_UPDATE_TIMESTAMP.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            iter = reassignPerms.iterator();
            for (i = 0; i < size; ++i) {
                stmt.setInt(1, mailAdmin);
                stmt.setLong(2, lastModified);
                stmt.setInt(3, ctx.getContextId());
                stmt.setInt(4, iter.next());
                stmt.addBatch();
            }
            OXFolderSQL.executeBatch(stmt);
            DBUtils.closeResources(rs, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, stmt, closeWrite ? wc : null, false, ctx);
            if (closeRead && rc != null) {
                DBPool.closeReaderSilent(ctx, rc);
            }
            throw throwable;
        }
        if (closeRead && rc != null) {
            DBPool.closeReaderSilent(ctx, rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteSingleEntityPermission(int entity, int fuid, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection wc = writeConArg;
        boolean close = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                close = true;
            }
            stmt = wc.prepareStatement(SQL_REASSIGN_DEL_PERM.replaceFirst(TMPL_PERM_TABLE, permTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, entity);
            stmt.setInt(3, fuid);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, close ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, close ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSingleEntityPermission(OCLPermission mergedPerm, int mailAdmin, int fuid, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection wc = writeConArg;
        boolean close = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                close = true;
            }
            stmt = wc.prepareStatement(SQL_REASSIGN_UPDATE_PERM.replaceFirst(TMPL_PERM_TABLE, permTable));
            stmt.setInt(1, mergedPerm.getFolderPermission());
            stmt.setInt(2, mergedPerm.getReadPermission());
            stmt.setInt(3, mergedPerm.getWritePermission());
            stmt.setInt(4, mergedPerm.getDeletePermission());
            stmt.setInt(5, mergedPerm.isFolderAdmin() ? 1 : 0);
            stmt.setInt(6, mergedPerm.isGroupPermission() ? 1 : 0);
            stmt.setInt(7, ctx.getContextId());
            stmt.setInt(8, mailAdmin);
            stmt.setInt(9, fuid);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, close ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, close ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OCLPermission getMergedPermission(int entity, int mailAdmin, int fuid, String permTable, Connection readConArg, Context ctx) throws SQLException, OXException {
        OCLPermission adminPerm;
        ResultSet innerRs;
        PreparedStatement innerStmt;
        boolean closeRead;
        Connection readCon;
        block8: {
            block6: {
                block7: {
                    OCLPermission oCLPermission;
                    readCon = readConArg;
                    closeRead = false;
                    innerStmt = null;
                    innerRs = null;
                    try {
                        if (readCon == null) {
                            readCon = DBPool.pickup(ctx);
                            closeRead = true;
                        }
                        innerStmt = readCon.prepareStatement(SQL_REASSIGN_SEL_PERM.replaceFirst(TMPL_PERM_TABLE, permTable));
                        innerStmt.setInt(1, ctx.getContextId());
                        innerStmt.setInt(2, mailAdmin);
                        innerStmt.setInt(3, fuid);
                        innerRs = OXFolderSQL.executeQuery(innerStmt);
                        if (innerRs.next()) break block6;
                        innerRs.close();
                        innerStmt.close();
                        innerStmt = readCon.prepareStatement(SQL_REASSIGN_SEL_PERM.replaceFirst(TMPL_PERM_TABLE, permTable));
                        innerStmt.setInt(1, ctx.getContextId());
                        innerStmt.setInt(2, entity);
                        innerStmt.setInt(3, fuid);
                        innerRs = OXFolderSQL.executeQuery(innerStmt);
                        if (innerRs.next()) break block7;
                        oCLPermission = new OCLPermission(mailAdmin, fuid);
                        DBUtils.closeResources(innerRs, (Statement)innerStmt, closeRead ? readCon : null, true, ctx);
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeResources(innerRs, (Statement)innerStmt, closeRead ? readCon : null, true, ctx);
                        throw throwable;
                    }
                    return oCLPermission;
                }
                OCLPermission adminPerm2 = new OCLPermission(mailAdmin, fuid);
                adminPerm2.setAllPermission(innerRs.getInt(1), innerRs.getInt(2), innerRs.getInt(3), innerRs.getInt(4));
                adminPerm2.setFolderAdmin(innerRs.getInt(5) > 0);
                adminPerm2.setGroupPermission(false);
                OCLPermission oCLPermission = adminPerm2;
                DBUtils.closeResources(innerRs, (Statement)innerStmt, closeRead ? readCon : null, true, ctx);
                return oCLPermission;
            }
            adminPerm = new OCLPermission(mailAdmin, fuid);
            adminPerm.setAllPermission(innerRs.getInt(1), innerRs.getInt(2), innerRs.getInt(3), innerRs.getInt(4));
            adminPerm.setFolderAdmin(innerRs.getInt(5) > 0);
            adminPerm.setGroupPermission(false);
            innerRs.close();
            innerStmt.close();
            innerStmt = readCon.prepareStatement(SQL_REASSIGN_SEL_PERM.replaceFirst(TMPL_PERM_TABLE, permTable));
            innerStmt.setInt(1, ctx.getContextId());
            innerStmt.setInt(2, entity);
            innerStmt.setInt(3, fuid);
            innerRs = OXFolderSQL.executeQuery(innerStmt);
            if (innerRs.next()) break block8;
            OCLPermission oCLPermission = adminPerm;
            DBUtils.closeResources(innerRs, (Statement)innerStmt, closeRead ? readCon : null, true, ctx);
            return oCLPermission;
        }
        OCLPermission entityPerm = new OCLPermission(entity, fuid);
        entityPerm.setAllPermission(innerRs.getInt(1), innerRs.getInt(2), innerRs.getInt(3), innerRs.getInt(4));
        entityPerm.setFolderAdmin(innerRs.getInt(5) > 0);
        OCLPermission mergedPerm = new OCLPermission(mailAdmin, fuid);
        mergedPerm.setFolderPermission(Math.max(adminPerm.getFolderPermission(), entityPerm.getFolderPermission()));
        mergedPerm.setReadObjectPermission(Math.max(adminPerm.getReadPermission(), entityPerm.getReadPermission()));
        mergedPerm.setWriteObjectPermission(Math.max(adminPerm.getWritePermission(), entityPerm.getWritePermission()));
        mergedPerm.setDeleteObjectPermission(Math.max(adminPerm.getDeletePermission(), entityPerm.getDeletePermission()));
        mergedPerm.setFolderAdmin(adminPerm.isFolderAdmin() || entityPerm.isFolderAdmin());
        mergedPerm.setGroupPermission(false);
        OCLPermission oCLPermission = mergedPerm;
        DBUtils.closeResources(innerRs, (Statement)innerStmt, closeRead ? readCon : null, true, ctx);
        return oCLPermission;
    }

    static void handleMailAdminFolders(int mailAdmin, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        OXFolderSQL.handleEntityFolders(mailAdmin, null, -1L, folderTable, permTable, readConArg, writeConArg, ctx);
    }

    static void handleEntityFolders(int entity, int mailAdmin, long lastModified, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        OXFolderSQL.handleEntityFolders(entity, (Integer)mailAdmin, lastModified, folderTable, permTable, readConArg, writeConArg, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleEntityFolders(int entity, Integer mailAdmin, long lastModified, String folderTable, String permTable, Connection readConArg, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isMailAdmin = mailAdmin == null;
        try {
            EventAdmin eventAdmin;
            int i;
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement(SQL_SEL_FOLDERS.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, entity);
            rs = OXFolderSQL.executeQuery(stmt);
            TIntHashSet deleteFolders = new TIntHashSet();
            TIntHashSet reassignFolders = new TIntHashSet();
            while (rs.next()) {
                int fuid = rs.getInt(1);
                int type = rs.getInt(2);
                if (isMailAdmin || OXFolderSQL.markForDeletion(type)) {
                    deleteFolders.add(fuid);
                    continue;
                }
                reassignFolders.add(fuid);
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            OXFolderSQL.deleteFolders((TIntSet)deleteFolders, folderTable, permTable, writeConArg, ctx);
            if (!isMailAdmin) {
                OXFolderSQL.reassignFolders((TIntSet)reassignFolders, entity, mailAdmin, lastModified, folderTable, writeConArg, ctx);
            }
            ConditionTreeMapManagement.dropFor(ctx.getContextId());
            if (FolderCacheManager.isInitialized()) {
                try {
                    TIntIterator iterator = deleteFolders.iterator();
                    i = deleteFolders.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iterator.next(), ctx);
                    }
                    iterator = reassignFolders.iterator();
                    i = reassignFolders.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iterator.next(), ctx);
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            stmt = readCon.prepareStatement(SQL_SEL_FOLDERS2.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, entity);
            rs = OXFolderSQL.executeQuery(stmt);
            deleteFolders = new TIntHashSet();
            reassignFolders = new TIntHashSet();
            while (rs.next()) {
                int fuid = rs.getInt(1);
                if (isMailAdmin) {
                    deleteFolders.add(fuid);
                    continue;
                }
                reassignFolders.add(fuid);
            }
            OXFolderSQL.deleteFolders((TIntSet)deleteFolders, folderTable, permTable, writeConArg, ctx);
            if (!isMailAdmin) {
                OXFolderSQL.reassignFolders((TIntSet)reassignFolders, entity, mailAdmin, lastModified, folderTable, writeConArg, ctx);
            }
            if (FolderCacheManager.isInitialized()) {
                try {
                    TIntIterator iterator = deleteFolders.iterator();
                    i = deleteFolders.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iterator.next(), ctx);
                    }
                    iterator = reassignFolders.iterator();
                    i = reassignFolders.size();
                    while (i-- > 0) {
                        FolderCacheManager.getInstance().removeFolderObject(iterator.next(), ctx);
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (null != (eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class))) {
                TIntIterator iterator = deleteFolders.iterator();
                int i2 = deleteFolders.size();
                while (i2-- > 0) {
                    OXFolderSQL.broadcastEvent(iterator.next(), true, entity, ctx.getContextId(), eventAdmin);
                }
                iterator = reassignFolders.iterator();
                i2 = reassignFolders.size();
                while (i2-- > 0) {
                    OXFolderSQL.broadcastEvent(iterator.next(), false, entity, ctx.getContextId(), eventAdmin);
                }
            }
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFolders(TIntSet deleteFolders, String folderTable, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        int size = deleteFolders.size();
        Connection wc = writeConArg;
        boolean closeWrite = false;
        PreparedStatement stmt = null;
        try {
            int fuid;
            int i;
            TIntIterator iter = deleteFolders.iterator();
            for (i = 0; i < size; ++i) {
                fuid = iter.next();
                OXFolderSQL.checkFolderPermissions(fuid, permTable, writeConArg, ctx);
            }
            iter = deleteFolders.iterator();
            for (i = 0; i < size; ++i) {
                fuid = iter.next();
                OXFolderSQL.deleteSpecialfoldersRefs(fuid, writeConArg, ctx);
            }
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            stmt = wc.prepareStatement(SQL_DELETE_FOLDER.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            iter = deleteFolders.iterator();
            for (i = 0; i < size; ++i) {
                fuid = iter.next();
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, fuid);
                stmt.addBatch();
            }
            OXFolderSQL.executeBatch(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, stmt, closeWrite ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteSpecialfoldersRefs(int fuid, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection wc = writeConArg;
        boolean closeWrite = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            stmt = wc.prepareStatement("DELETE FROM oxfolder_specialfolders WHERE cid = ? AND fuid = ?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, fuid);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkFolderPermissions(int fuid, String permTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection wc = writeConArg;
        boolean closeWrite = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            stmt = wc.prepareStatement(SQL_DELETE_FOLDER_PERMS.replaceFirst(TMPL_PERM_TABLE, permTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, fuid);
            OXFolderSQL.executeUpdate(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reassignFolders(TIntSet reassignFolders, int entity, int mailAdmin, long lastModified, String folderTable, Connection writeConArg, Context ctx) throws OXException, SQLException {
        Connection wc = writeConArg;
        boolean closeWrite = false;
        PreparedStatement stmt = null;
        try {
            if (wc == null) {
                wc = DBPool.pickupWriteable(ctx);
                closeWrite = true;
            }
            int size = reassignFolders.size();
            TIntIterator iter = reassignFolders.iterator();
            boolean found = false;
            for (int i = 0; i < size && !found; ++i) {
                int fuid = iter.next();
                String fname = OXFolderSQL.isDefaultInfostoreFolder(fuid, entity, folderTable, wc, ctx);
                if (fname == null) continue;
                iter.remove();
                --size;
                stmt = wc.prepareStatement(SQL_REASSIGN_FOLDERS_WITH_NAME.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
                stmt.setInt(1, mailAdmin);
                stmt.setInt(2, mailAdmin);
                stmt.setLong(3, lastModified);
                stmt.setString(4, fname + fuid);
                stmt.setInt(5, ctx.getContextId());
                stmt.setInt(6, fuid);
                OXFolderSQL.executeUpdate(stmt);
                stmt.close();
                stmt = null;
                found = true;
            }
            iter = reassignFolders.iterator();
            stmt = wc.prepareStatement(SQL_REASSIGN_FOLDERS.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            for (int i = 0; i < size; ++i) {
                stmt.setInt(1, mailAdmin);
                stmt.setInt(2, mailAdmin);
                stmt.setLong(3, lastModified);
                stmt.setInt(4, ctx.getContextId());
                stmt.setInt(5, iter.next());
                stmt.addBatch();
            }
            OXFolderSQL.executeBatch(stmt);
            DBUtils.closeResources(null, (Statement)stmt, closeWrite ? wc : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, stmt, closeWrite ? wc : null, false, ctx);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String isDefaultInfostoreFolder(int fuid, int entity, String folderTable, Connection con, Context ctx) throws SQLException {
        String string;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(SQL_DEF_INF.replaceFirst(TMPL_FOLDER_TABLE, folderTable));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, fuid);
            stmt.setInt(3, 8);
            stmt.setInt(4, entity);
            rs = OXFolderSQL.executeQuery(stmt);
            string = rs.next() ? rs.getString(1) : null;
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, null, true, ctx);
            throw throwable;
        }
        DBUtils.closeResources(rs, (Statement)stmt, null, true, ctx);
        return string;
    }

    private static boolean markForDeletion(int type) {
        return type == 1;
    }

    private static int executeUpdate(PreparedStatement stmt) throws SQLException {
        try {
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            if ("MySQLSyntaxErrorException".equals(e.getClass().getSimpleName())) {
                String sql = stmt.toString();
                LOG.error((Object)("\nFollowing SQL query contains syntax errors:\n" + sql.substring(sql.indexOf(": ") + 2)));
            }
            throw e;
        }
    }

    private static int[] executeBatch(PreparedStatement stmt) throws SQLException {
        try {
            return stmt.executeBatch();
        }
        catch (SQLException e) {
            if ("MySQLSyntaxErrorException".equals(e.getClass().getSimpleName())) {
                String sql = stmt.toString();
                LOG.error((Object)("\nFollowing SQL query contains syntax errors:\n" + sql.substring(sql.indexOf(": ") + 2)));
            }
            throw e;
        }
    }

    private static ResultSet executeQuery(PreparedStatement stmt) throws SQLException {
        try {
            return stmt.executeQuery();
        }
        catch (SQLException e) {
            if ("MySQLSyntaxErrorException".equals(e.getClass().getSimpleName())) {
                String sql = stmt.toString();
                LOG.error((Object)("\nFollowing SQL query contains syntax errors:\n" + sql.substring(sql.indexOf(": ") + 2)));
            }
            throw e;
        }
    }
}

