/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public final class OXFolderBatchLoader {
    private static final int IN_LIMIT = 1000;
    private static final String TABLE_OT = "oxfolder_tree";
    private static final String TABLE_OP = "oxfolder_permissions";
    private static final Pattern PAT_RPL_TABLE = Pattern.compile("#TABLE#");

    private OXFolderBatchLoader() {
    }

    public static List<FolderObject> loadFolderObjectsFromDB(int[] folderIds, Context ctx) throws OXException {
        return OXFolderBatchLoader.loadFolderObjectsFromDB(folderIds, ctx, null, true, false);
    }

    public static List<FolderObject> loadFolderObjectsFromDB(int[] folderIds, Context ctx, Connection readCon) throws OXException {
        return OXFolderBatchLoader.loadFolderObjectsFromDB(folderIds, ctx, readCon, true, false);
    }

    public static final List<FolderObject> loadFolderObjectsFromDB(int[] folderIds, Context ctx, Connection readConArg, boolean loadPermissions, boolean loadSubfolderList) throws OXException {
        return OXFolderBatchLoader.loadFolderObjectsFromDB(folderIds, ctx, readConArg, loadPermissions, loadSubfolderList, TABLE_OT, TABLE_OP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<FolderObject> loadFolderObjectsFromDB(int[] folderIds, Context ctx, Connection readConArg, boolean loadPermissions, boolean loadSubfolderList, String table, String permTable) throws OXException {
        Connection readCon = readConArg;
        boolean closeCon = false;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            FolderObject[] array = new FolderObject[folderIds.length];
            TIntObjectMap<FolderObject> map = OXFolderBatchLoader.loadFolderObjectsFromDB0(folderIds, ctx, readCon, loadPermissions, loadSubfolderList, table, permTable);
            for (int i = 0; i < folderIds.length; ++i) {
                FolderObject fo;
                int fuid = folderIds[i];
                array[i] = fo = (FolderObject)map.get(fuid);
            }
            List<FolderObject> list = java.util.Arrays.asList(array);
            return list;
        }
        finally {
            if (closeCon) {
                DBPool.closeReaderSilent(ctx, readCon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TIntObjectMap<FolderObject> loadFolderObjectsFromDB0(int[] folderIds, Context ctx, Connection readCon, boolean loadPermissions, boolean loadSubfolderList, String table, String permTable) throws OXException {
        try {
            TIntObjectMap<List<OCLPermission>> permissions;
            FolderPermissionProcedure procedure;
            SubfolderProcedure procedure2;
            TIntObjectHashMap folders2 = new TIntObjectHashMap();
            for (int i = 0; i < folderIds.length; i += 1000) {
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    int[] currentIds = Arrays.extract((int[])folderIds, (int)i, (int)1000);
                    String sql = DBUtils.getIN("SELECT parent,fname,module,type,creating_date,created_from,changing_date,changed_from,permission_flag,subfolder_flag,default_flag,fuid FROM #TABLE# WHERE cid=? AND fuid IN (", currentIds.length);
                    stmt = readCon.prepareStatement(PAT_RPL_TABLE.matcher(sql).replaceFirst(table));
                    int pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    for (int folderId : currentIds) {
                        stmt.setInt(pos++, folderId);
                    }
                    rs = stmt.executeQuery();
                    pos = 0;
                    while (rs.next()) {
                        int fuid = rs.getInt(12);
                        FolderObject folderObj = new FolderObject(rs.getString(2), fuid, rs.getInt(3), rs.getInt(4), rs.getInt(6));
                        folderObj.setParentFolderID(rs.getInt(1));
                        folderObj.setCreatedBy(OXFolderBatchLoader.parseStringValue(rs.getString(6), ctx));
                        folderObj.setCreationDate(new Date(rs.getLong(5)));
                        folderObj.setSubfolderFlag(rs.getInt(10) > 0);
                        folderObj.setLastModified(new Date(rs.getLong(7)));
                        folderObj.setModifiedBy(OXFolderBatchLoader.parseStringValue(rs.getString(8), ctx));
                        folderObj.setPermissionFlag(rs.getInt(9));
                        int defaultFolder = rs.getInt(11);
                        if (rs.wasNull()) {
                            folderObj.setDefaultFolder(false);
                        } else {
                            folderObj.setDefaultFolder(defaultFolder > 0);
                        }
                        folders2.put(fuid, (Object)folderObj);
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(rs, stmt);
            }
            if (loadSubfolderList && !folders2.forEachValue((TObjectProcedure)(procedure2 = new SubfolderProcedure(OXFolderBatchLoader.getSubfolderIds(folderIds, ctx, readCon, table))))) {
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(Autoboxing.I((int)ctx.getContextId()));
            }
            if (loadPermissions && !folders2.forEachValue((TObjectProcedure)(procedure = new FolderPermissionProcedure(permissions = OXFolderBatchLoader.getFolderPermissions(folderIds, ctx, readCon, permTable))))) {
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(Autoboxing.I((int)ctx.getContextId()));
            }
            return folders2;
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    public static final TIntObjectMap<List<OCLPermission>> getFolderPermissions(int[] folderIds, Context ctx, Connection readConArg) throws SQLException, OXException {
        return OXFolderBatchLoader.getFolderPermissions(folderIds, ctx, readConArg, TABLE_OP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TIntObjectMap<List<OCLPermission>> getFolderPermissions(int[] folderIds, Context ctx, Connection readConArg, String table) throws SQLException, OXException {
        Connection readCon = readConArg;
        boolean closeCon = false;
        if (readCon == null) {
            readCon = DBPool.pickup(ctx);
            closeCon = true;
        }
        try {
            TIntObjectHashMap ret = new TIntObjectHashMap(folderIds.length);
            for (int i = 0; i < folderIds.length; i += 1000) {
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    int[] currentIds = Arrays.extract((int[])folderIds, (int)i, (int)1000);
                    String sql = DBUtils.getIN("SELECT permission_id,fp,orp,owp,odp,admin_flag,group_flag,system,fuid FROM #TABLE# WHERE cid=? AND fuid IN (", currentIds.length);
                    stmt = readCon.prepareStatement(PAT_RPL_TABLE.matcher(sql).replaceFirst(table));
                    int pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    for (int folderId : currentIds) {
                        stmt.setInt(pos++, folderId);
                        ret.put(folderId, new ArrayList(4));
                    }
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        int fuid = rs.getInt(9);
                        List list = (List)ret.get(fuid);
                        OCLPermission p = new OCLPermission();
                        p.setEntity(rs.getInt(1));
                        p.setAllPermission(rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5));
                        p.setFolderAdmin(rs.getInt(6) > 0);
                        p.setGroupPermission(rs.getInt(7) > 0);
                        p.setSystem(rs.getInt(8));
                        list.add(p);
                    }
                    stmt.close();
                    rs = null;
                    stmt = null;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(rs, stmt);
            }
            TIntObjectHashMap tIntObjectHashMap = ret;
            return tIntObjectHashMap;
        }
        finally {
            if (closeCon) {
                DBPool.closeReaderSilent(ctx, readCon);
            }
        }
    }

    public static final TIntObjectMap<ArrayList<Integer>> getSubfolderIds(int[] folderIds, Context ctx, Connection readConArg) throws SQLException, OXException {
        return OXFolderBatchLoader.getSubfolderIds(folderIds, ctx, readConArg, TABLE_OT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TIntObjectMap<ArrayList<Integer>> getSubfolderIds(int[] folderIds, Context ctx, Connection readConArg, String table) throws SQLException, OXException {
        Connection readCon = readConArg;
        boolean closeCon = false;
        if (readCon == null) {
            readCon = DBPool.pickup(ctx);
            closeCon = true;
        }
        try {
            TIntObjectHashMap ret = new TIntObjectHashMap(folderIds.length);
            for (int i = 0; i < folderIds.length; i += 1000) {
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    int[] currentIds = Arrays.extract((int[])folderIds, (int)i, (int)1000);
                    String sql = DBUtils.getIN("SELECT fuid,parent FROM #TABLE# WHERE cid=? AND parent IN (", currentIds.length) + " ORDER BY default_flag DESC, fname";
                    stmt = readCon.prepareStatement(sql.replaceFirst("#TABLE#", table));
                    int pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    for (int folderId : currentIds) {
                        stmt.setInt(pos++, folderId);
                        ret.put(folderId, new ArrayList(0));
                    }
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        ((ArrayList)ret.get(rs.getInt(2))).add(Autoboxing.I((int)rs.getInt(1)));
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(rs, stmt);
            }
            TIntObjectHashMap tIntObjectHashMap = ret;
            return tIntObjectHashMap;
        }
        finally {
            if (closeCon) {
                DBPool.closeReaderSilent(ctx, readCon);
            }
        }
    }

    private static final int parseStringValue(String str, Context ctx) {
        if (null == str) {
            return -1;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            if (str.equalsIgnoreCase("system")) {
                return ctx.getMailadmin();
            }
            return -1;
        }
    }

    private static final class SubfolderProcedure
    implements TObjectProcedure<FolderObject> {
        private final TIntObjectMap<ArrayList<Integer>> subfolderIds;

        public SubfolderProcedure(TIntObjectMap<ArrayList<Integer>> subfolderIds) {
            this.subfolderIds = subfolderIds;
        }

        public boolean execute(FolderObject fo) {
            ArrayList ids = (ArrayList)this.subfolderIds.get(fo.getObjectID());
            if (ids == null) {
                return false;
            }
            fo.setSubfolderIds(ids);
            return true;
        }
    }

    private static final class FolderPermissionProcedure
    implements TObjectProcedure<FolderObject> {
        private final TIntObjectMap<List<OCLPermission>> folderPermissions;

        public FolderPermissionProcedure(TIntObjectMap<List<OCLPermission>> folderPermissions) {
            this.folderPermissions = folderPermissions;
        }

        public boolean execute(FolderObject fo) {
            int id = fo.getObjectID();
            List permissions = (List)this.folderPermissions.get(id);
            if (null == permissions) {
                return false;
            }
            fo.setPermissionsNoClone(permissions);
            return true;
        }
    }
}

