/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import it.geosolutions.imageio.stream.eraf.EnhancedRandomAccessFile;
import java.io.IOException;
import java.io.InputStream;

public class RandomAccessFileInputStream
extends InputStream {
    private final EnhancedRandomAccessFile file;
    private final long endPosition;
    private long markedPosition;

    public RandomAccessFileInputStream(EnhancedRandomAccessFile eraf, long offset, long length) throws IOException {
        this.file = eraf;
        this.endPosition = -1L == length ? this.file.length() : Math.min(this.file.length(), offset + length);
        this.file.seek(offset);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.file.getFilePointer() >= this.endPosition) {
            return -1;
        }
        return this.file.read();
    }

    @Override
    public synchronized void close() throws IOException {
        this.file.close();
        super.close();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.markedPosition = this.file.getFilePointer();
        }
        catch (IOException e) {
            this.markedPosition = Long.MIN_VALUE;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (Long.MIN_VALUE == this.markedPosition) {
            throw new IOException("No position marked");
        }
        this.file.seek(this.markedPosition);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int available = this.available();
        if (0 >= available) {
            return -1;
        }
        return this.file.read(b, off, Math.min(available, len));
    }

    @Override
    public synchronized int available() throws IOException {
        return (int)(this.endPosition - this.file.getFilePointer());
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            throw new IOException("can skip at maximum 2147483647 bytes");
        }
        return this.file.skipBytes((int)(n & 0xFFFFFFFFFFFFFFFFL));
    }
}

