/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.external;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum FileStorageCodes implements OXExceptionCode
{
    IOERROR("An IO error occurred: %s", Category.CATEGORY_SERVICE_DOWN, 3),
    INSTANTIATIONERROR("File store could not be accessed: %s", Category.CATEGORY_SERVICE_DOWN, 4),
    CREATE_DIR_FAILED("Cannot create directory \"%1$s\" in file storage.", Category.CATEGORY_CONFIGURATION, 6),
    ENCODING("Unsupported encoding.", Category.CATEGORY_ERROR, 9),
    NO_NUMBER("Number parsing problem.", Category.CATEGORY_ERROR, 10),
    STORE_FULL("File storage is full.", Category.CATEGORY_CAPACITY, 11),
    DEPTH_MISMATCH("'Depth' mismatch while computing next entry.", Category.CATEGORY_ERROR, 12),
    UNLOCK("Cannot remove lock file.", Category.CATEGORY_SERVICE_DOWN, 13),
    LOCK("Cannot create lock file here %1$s. Please check for a stale .lock file, inappropriate permissions or usage of the file store for too long a time.", Category.CATEGORY_SERVICE_DOWN, 14),
    NOT_ELIMINATED("Eliminating the file storage failed.", Category.CATEGORY_SERVICE_DOWN, 16),
    FILE_NOT_FOUND("File does not exist in file store \"%1$s\". Consider running the consistency tool.", Category.CATEGORY_SERVICE_DOWN, 17),
    INVALID_RANGE("The requested range (offset: %1$d, length: %2$d) for the file \"%3$s\" (current size: %4$d) is invalid.", Category.CATEGORY_USER_INPUT, 18),
    INVALID_OFFSET("The specified offset %1$d for the file \"%2$s\" (current size: %3$d) is invalid.", Category.CATEGORY_USER_INPUT, 19),
    INVALID_LENGTH("The specified length %1$d for the file \"%2$s\" (current size: %3$d) is invalid.", Category.CATEGORY_USER_INPUT, 20);

    private final String message;
    private final Category category;
    private final int number;

    private FileStorageCodes(String message, Category category, int detailNumber) {
        this.message = message;
        this.category = category;
        this.number = detailNumber;
    }

    public String getPrefix() {
        return "FLS";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

