/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.search;

import com.openexchange.search.Operation;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.internal.terms.AndTerm;
import com.openexchange.search.internal.terms.NotTerm;
import com.openexchange.search.internal.terms.OrTerm;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CompositeSearchTerm
implements SearchTerm<SearchTerm<?>> {
    private static final Integer PRETTY_BIG_NUMBER = 0x3FFFFFFF;
    protected static final int DEFAULT_CAPACITY = 4;
    protected final CompositeOperation operation;
    protected final List<SearchTerm<?>> operands;

    public CompositeSearchTerm(CompositeOperation operation) {
        this(operation, 4);
    }

    protected CompositeSearchTerm(CompositeOperation operation, int initialCapacity) {
        this.operation = operation;
        this.operands = new ArrayList(initialCapacity);
    }

    public SearchTerm<?>[] getOperands() {
        return this.operands.toArray(new SearchTerm[this.operands.size()]);
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public void addSearchTerm(SearchTerm<?> searchTerm) {
        this.operands.add(searchTerm);
    }

    public String toString() {
        return this.operation.getOperation() + ':' + this.operands;
    }

    static /* synthetic */ Integer access$000() {
        return PRETTY_BIG_NUMBER;
    }

    public static enum CompositeOperation implements Operation
    {
        AND("and", CompositeSearchTerm.access$000(), "AND", SearchTerm.OperationPosition.BETWEEN, "&%s", new InstanceCreator(){
            private static final long serialVersionUID = -2839503961447478423L;

            @Override
            public CompositeSearchTerm newInstance() {
                return new AndTerm();
            }
        }),
        OR("or", CompositeSearchTerm.access$000(), "OR", SearchTerm.OperationPosition.BETWEEN, "|%s", new InstanceCreator(){
            private static final long serialVersionUID = 8612089760772780923L;

            @Override
            public CompositeSearchTerm newInstance() {
                return new OrTerm();
            }
        }),
        NOT("not", 1, "!", SearchTerm.OperationPosition.BEFORE, "!%s", new InstanceCreator(){
            private static final long serialVersionUID = 5131782739497011902L;

            @Override
            public CompositeSearchTerm newInstance() {
                return new NotTerm();
            }
        });

        private final String str;
        private final String sql;
        private String ldap;
        private final InstanceCreator creator;
        private final int maxTerms;
        private SearchTerm.OperationPosition sqlPos;
        private static final transient Map<String, CompositeOperation> map;

        private CompositeOperation(String str, int maxTerms, String sql, SearchTerm.OperationPosition sqlPos, String ldap, InstanceCreator creator) {
            this.str = str;
            this.creator = creator;
            this.maxTerms = maxTerms;
            this.sql = sql;
            this.ldap = ldap;
            this.sqlPos = sqlPos;
        }

        @Override
        public String getOperation() {
            return this.str;
        }

        @Override
        public boolean equalsOperation(String other) {
            return this.str.equalsIgnoreCase(other);
        }

        public CompositeSearchTerm newInstance() {
            return this.creator.newInstance();
        }

        public int getMaxTerms() {
            return this.maxTerms;
        }

        @Override
        public SearchTerm.OperationPosition getSqlPosition() {
            return this.sqlPos;
        }

        public static CompositeOperation getCompositeOperation(String operation) {
            CompositeOperation[] values;
            CompositeOperation retval = map.get(operation);
            if (null != retval) {
                return retval;
            }
            for (CompositeOperation value : values = CompositeOperation.values()) {
                if (!value.equalsOperation(operation)) continue;
                return value;
            }
            return null;
        }

        public static boolean containsOperation(String operation) {
            return null != CompositeOperation.getCompositeOperation(operation);
        }

        @Override
        public String getSqlRepresentation() {
            return this.sql;
        }

        @Override
        public String getLdapRepresentation() {
            return this.ldap;
        }

        static {
            CompositeOperation[] values = CompositeOperation.values();
            HashMap<String, CompositeOperation> m = new HashMap<String, CompositeOperation>(values.length);
            for (CompositeOperation singleOperation : values) {
                m.put(singleOperation.str, singleOperation);
            }
            map = Collections.unmodifiableMap(m);
        }
    }

    private static interface InstanceCreator
    extends Serializable {
        public CompositeSearchTerm newInstance();
    }
}

