/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.database.Databases;
import com.openexchange.databaseold.Database;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.jslob.DefaultJSlob;
import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobId;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.mailaccount.json.actions.ValidateAction;
import com.openexchange.mailaccount.json.fields.MailAccountFields;
import com.openexchange.mailaccount.json.parser.MailAccountParser;
import com.openexchange.mailaccount.json.writer.MailAccountWriter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

@Action(method=RequestMethod.PUT, name="update", description="Update a mail account", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="A JSON object identifiying (field ID is present) and describing the account to update. See mail account data.", responseDescription="A JSON object representing the updated mail account. See mail account data.")
public final class UpdateAction
extends AbstractMailAccountAction
implements MailAccountFields {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(UpdateAction.class));
    public static final String ACTION = "update";
    private static final EnumSet<Attribute> DEFAULT = EnumSet.of(Attribute.CONFIRMED_HAM_FULLNAME_LITERAL, new Attribute[]{Attribute.CONFIRMED_HAM_LITERAL, Attribute.CONFIRMED_SPAM_FULLNAME_LITERAL, Attribute.CONFIRMED_SPAM_LITERAL, Attribute.DRAFTS_FULLNAME_LITERAL, Attribute.DRAFTS_LITERAL, Attribute.SENT_FULLNAME_LITERAL, Attribute.SENT_LITERAL, Attribute.SPAM_FULLNAME_LITERAL, Attribute.SPAM_LITERAL, Attribute.TRASH_FULLNAME_LITERAL, Attribute.TRASH_LITERAL});
    private static final Set<Attribute> WEBMAIL_ALLOWED = EnumSet.of(Attribute.ID_LITERAL, Attribute.PERSONAL_LITERAL, Attribute.REPLY_TO_LITERAL, Attribute.UNIFIED_INBOX_ENABLED_LITERAL);

    @Override
    protected AJAXRequestResult innerPerform(AJAXRequestData requestData, ServerSession session, JSONValue jData) throws OXException, JSONException {
        String login;
        MailAccountDescription accountDescription = new MailAccountDescription();
        LinkedList<OXException> warnings = new LinkedList<OXException>();
        Set<Attribute> fieldsToUpdate = MailAccountParser.getInstance().parse(accountDescription, jData.toObject(), warnings);
        int id = accountDescription.getId();
        if (-1 == id) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("id");
        }
        if (fieldsToUpdate.contains((Object)Attribute.LOGIN_LITERAL) && UpdateAction.isEmpty(login = accountDescription.getLogin())) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create("login", null == login ? "null" : login);
        }
        if (fieldsToUpdate.contains((Object)Attribute.PASSWORD_LITERAL)) {
            String pw = accountDescription.getPassword();
            if (0 != id && UpdateAction.isEmpty(pw)) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create("password", null == pw ? "null" : pw);
            }
        }
        if (fieldsToUpdate.contains((Object)Attribute.MAIL_URL_LITERAL)) {
            String server = accountDescription.getMailServer();
            if (0 != id && UpdateAction.isEmpty(server)) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create("mail_url", null == server ? "null" : server);
            }
        }
        int contextId = session.getContextId();
        EnumSet<Attribute> notAllowed = EnumSet.copyOf(fieldsToUpdate);
        notAllowed.removeAll(WEBMAIL_ALLOWED);
        if (!(session.getUserPermissionBits().isMultipleMailAccounts() || UpdateAction.isDefaultMailAccount(accountDescription) && notAllowed.isEmpty())) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(session.getUserId(), contextId);
        }
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        MailAccount toUpdate = storageService.getMailAccount(id, session.getUserId(), contextId);
        if (UpdateAction.isUnifiedINBOXAccount(toUpdate)) {
            throw MailAccountExceptionCodes.NOT_FOUND.create(id, session.getUserId(), contextId);
        }
        boolean clearStamp = false;
        boolean pop3 = accountDescription.getMailProtocol().toLowerCase(Locale.ENGLISH).startsWith("pop3");
        if (fieldsToUpdate.contains((Object)Attribute.MAIL_URL_LITERAL) && !toUpdate.generateMailServerURL().equals(accountDescription.generateMailServerURL())) {
            if (!pop3 && !ValidateAction.checkMailServerURL(accountDescription, session, warnings)) {
                OXException warning = MimeMailExceptionCode.CONNECT_ERROR.create(accountDescription.getMailServer(), accountDescription.getLogin());
                warning.setCategory(Category.CATEGORY_WARNING);
                warnings.add(0, warning);
            }
            clearStamp |= pop3 && !toUpdate.getMailServer().equals(accountDescription.getMailServer());
        }
        if (fieldsToUpdate.contains((Object)Attribute.TRANSPORT_URL_LITERAL) && !toUpdate.generateTransportServerURL().equals(accountDescription.generateTransportServerURL())) {
            if (!pop3 && !ValidateAction.checkTransportServerURL(accountDescription, session, warnings)) {
                String transportLogin = accountDescription.getTransportLogin();
                OXException warning = MimeMailExceptionCode.CONNECT_ERROR.create(accountDescription.getTransportServer(), transportLogin == null ? accountDescription.getLogin() : transportLogin);
                warning.setCategory(Category.CATEGORY_WARNING);
                warnings.add(0, warning);
            }
            clearStamp |= pop3 && !toUpdate.getTransportServer().equals(accountDescription.getTransportServer());
        }
        MailAccount updatedAccount = null;
        Connection wcon = Database.get(contextId, true);
        boolean rollback = false;
        try {
            MailAccount[] accounts;
            Databases.startTransaction((Connection)wcon);
            rollback = true;
            storageService.updateMailAccount(accountDescription, fieldsToUpdate, session.getUserId(), contextId, session, wcon, false);
            for (MailAccount mailAccount : accounts = storageService.getUserMailAccounts(session.getUserId(), contextId, wcon)) {
                if (mailAccount.getId() != id) continue;
                updatedAccount = mailAccount;
                break;
            }
            if (null != updatedAccount && fieldsToUpdate.removeAll(DEFAULT)) {
                updatedAccount = UpdateAction.checkFullNames(updatedAccount, storageService, session, wcon);
            }
            if (clearStamp) {
                PreparedStatement stmt = null;
                try {
                    stmt = wcon.prepareStatement("DELETE FROM user_mail_account_properties WHERE cid = ? AND user = ? AND id = ? AND name = ?");
                    int pos = 1;
                    stmt.setInt(pos++, contextId);
                    stmt.setInt(pos++, session.getUserId());
                    stmt.setInt(pos++, id);
                    stmt.setString(pos++, "pop3.lastaccess");
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                }
                finally {
                    DBUtils.closeSQLStuff(null, stmt);
                }
            }
            wcon.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(wcon);
            }
            DBUtils.autocommit(wcon);
            Database.back(contextId, true, wcon);
        }
        JSONObject jBody = jData.toObject();
        if (jBody.hasAndNotNull("meta")) {
            JSONObject jMeta = jBody.optJSONObject("meta");
            UpdateAction.getStorage().store(new JSlobId("com.openexchange.mailaccount", Integer.toString(id), session.getUserId(), session.getContextId()), (JSlob)new DefaultJSlob(jMeta));
        }
        JSONObject jsonAccount = null == updatedAccount ? MailAccountWriter.write(storageService.getMailAccount(id, session.getUserId(), contextId)) : MailAccountWriter.write(updatedAccount);
        return new AJAXRequestResult(jsonAccount).addWarnings(warnings);
    }
}

