/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import com.openexchange.mail.utils.StorageUtility;
import java.util.Collection;
import java.util.Locale;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.search.FromStringTerm;

public final class FromTerm
extends SearchTerm<String> {
    private static final long serialVersionUID = -1266840509034246826L;
    private String addr;

    public FromTerm(String pattern) {
        try {
            this.addr = new QuotedInternetAddress(pattern, false).getUnicodeAddress();
        }
        catch (AddressException e) {
            this.addr = pattern;
        }
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getPattern() {
        return this.addr;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.FROM);
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        if (this.containsWildcard()) {
            return FromTerm.toRegex(this.addr).matcher(StorageUtility.getAllAddresses(mailMessage.getFrom())).find();
        }
        return StorageUtility.getAllAddresses(mailMessage.getFrom()).toLowerCase(Locale.ENGLISH).indexOf(this.addr.toLowerCase(Locale.ENGLISH)) != -1;
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        try {
            String[] headers = msg.getHeader("From");
            if (null == headers || headers.length == 0) {
                return false;
            }
            InternetAddress[] addresses = MimeMessageUtility.parseAddressList(MimeMessageUtility.decodeMultiEncodedHeader(headers[0]), false, false);
            if (this.containsWildcard()) {
                return FromTerm.toRegex(this.addr).matcher(StorageUtility.getAllAddresses(addresses)).find();
            }
            return StorageUtility.getAllAddresses(addresses).toLowerCase(Locale.ENGLISH).indexOf(this.addr.toLowerCase(Locale.ENGLISH)) != -1;
        }
        catch (MessagingException e) {
            Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FromTerm.class)).warn((Object)"Error during search.", (Throwable)e);
            return false;
        }
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        return new FromStringTerm(this.addr);
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return new FromStringTerm(FromTerm.getNonWildcardPart(this.addr));
    }

    @Override
    public boolean isAscii() {
        return FromTerm.isAscii(this.addr);
    }

    @Override
    public boolean containsWildcard() {
        return null == this.addr ? false : this.addr.indexOf(42) >= 0 || this.addr.indexOf(63) >= 0;
    }
}

