/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.parser.MessageParser;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import org.json.JSONObject;

public final class AutosaveAction
extends AbstractMailAction {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AutosaveAction.class));

    public AutosaveAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            int accountId;
            ServerSession session = req.getSession();
            MailServletInterface mailInterface = this.getMailInterface(req);
            String msgIdentifier = null;
            ArrayList<OXException> warnings = new ArrayList<OXException>();
            JSONObject jsonMailObj = (JSONObject)req.getRequest().requireData();
            ComposedMailMessage composedMail = MessageParser.parse4Draft(jsonMailObj, null, session, 0, warnings);
            if ((composedMail.getFlags() & 4) == 0) {
                LOG.warn((Object)"Missing \\Draft flag on action=autosave in JSON message object", new Throwable());
                composedMail.setFlag(4, true);
            }
            if ((composedMail.getFlags() & 4) == 4) {
                accountId = composedMail.containsFrom() ? AutosaveAction.resolveFrom2Account(session, composedMail.getFrom()[0], false, true) : 0;
                if (mailInterface.getDraftsFolder(accountId) == null) {
                    if (0 == accountId) {
                        throw MailExceptionCode.FOLDER_NOT_FOUND.create("Drafts");
                    }
                    LOG.warn((Object)new StringAllocator(64).append("Mail account ").append(accountId).append(" for user ").append(session.getUserId()).append(" in context ").append(session.getContextId()).append(" has no drafts folder. Saving draft to default account's draft folder."));
                    accountId = 0;
                    composedMail.setFolder(mailInterface.getDraftsFolder(accountId));
                }
            } else {
                throw MailExceptionCode.UNEXPECTED_ERROR.create("No new message on action=edit");
            }
            msgIdentifier = mailInterface.saveDraft(composedMail, true, accountId);
            if (msgIdentifier == null) {
                throw MailExceptionCode.DRAFT_FAILED_UNKNOWN.create();
            }
            AJAXRequestResult result = new AJAXRequestResult((Object)msgIdentifier, "string");
            result.addWarnings(warnings);
            return result;
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

