/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache.queue;

import com.openexchange.mail.cache.PooledMailAccess;
import com.openexchange.mail.cache.queue.MailAccessQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MailAccessQueueImpl
implements MailAccessQueue {
    private final PriorityQueue<PooledMailAccess> priorityQueue;
    private final int capacity;
    private final AtomicBoolean deprecated = new AtomicBoolean();

    public MailAccessQueueImpl(int capacity) {
        this.capacity = capacity;
        this.priorityQueue = new PriorityQueue();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void markDeprecated() {
        this.deprecated.set(true);
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated.get();
    }

    @Override
    public PooledMailAccess pollDelayed() {
        PooledMailAccess first = this.priorityQueue.peek();
        if (first == null || first.getDelay(TimeUnit.MILLISECONDS) > 0L) {
            return null;
        }
        return this.priorityQueue.poll();
    }

    @Override
    public int hashCode() {
        return this.priorityQueue.hashCode();
    }

    @Override
    public PooledMailAccess remove() {
        return (PooledMailAccess)this.priorityQueue.remove();
    }

    @Override
    public boolean isEmpty() {
        return this.priorityQueue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.priorityQueue.contains(o);
    }

    @Override
    public PooledMailAccess element() {
        return (PooledMailAccess)this.priorityQueue.element();
    }

    @Override
    public boolean equals(Object obj) {
        return this.priorityQueue.equals(obj);
    }

    @Override
    public boolean addAll(Collection<? extends PooledMailAccess> c) {
        if (this.capacity > 0 && this.capacity - this.priorityQueue.size() < c.size()) {
            return false;
        }
        return this.priorityQueue.addAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.priorityQueue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.priorityQueue.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.priorityQueue.containsAll(c);
    }

    @Override
    public boolean offer(PooledMailAccess o) {
        if (this.capacity > 0 && this.capacity <= this.priorityQueue.size()) {
            return false;
        }
        return this.priorityQueue.offer(o);
    }

    @Override
    public PooledMailAccess peek() {
        return this.priorityQueue.peek();
    }

    @Override
    public boolean add(PooledMailAccess o) {
        if (this.capacity > 0 && this.capacity <= this.priorityQueue.size()) {
            return false;
        }
        return this.priorityQueue.add(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.priorityQueue.removeAll(c);
    }

    @Override
    public boolean remove(Object o) {
        return this.priorityQueue.remove(o);
    }

    @Override
    public Iterator<PooledMailAccess> iterator() {
        return this.priorityQueue.iterator();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.priorityQueue.retainAll(c);
    }

    public String toString() {
        return this.priorityQueue.toString();
    }

    @Override
    public int size() {
        return this.priorityQueue.size();
    }

    @Override
    public void clear() {
        this.priorityQueue.clear();
    }

    @Override
    public PooledMailAccess poll() {
        return this.priorityQueue.poll();
    }

    public Comparator<? super PooledMailAccess> comparator() {
        return this.priorityQueue.comparator();
    }
}

