/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.groupware.notify.EmailableParticipant;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.TemplateToken;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;

public final class ResourcesReplacement
implements TemplateReplacement {
    private static final String CRLF = "\r\n";
    private boolean changed;
    private Locale locale;
    private StringHelper stringHelper;
    private SortedSet<EmailableParticipant> resourcesSet;

    public ResourcesReplacement(SortedSet<EmailableParticipant> resourcesSet) {
        this.resourcesSet = resourcesSet;
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    public Object clone() throws CloneNotSupportedException {
        ResourcesReplacement clone = (ResourcesReplacement)super.clone();
        clone.locale = (Locale)(this.locale == null ? null : this.locale.clone());
        clone.stringHelper = null;
        clone.resourcesSet = new TreeSet<EmailableParticipant>();
        for (EmailableParticipant p : this.resourcesSet) {
            clone.resourcesSet.add((EmailableParticipant)p.clone());
        }
        return clone;
    }

    @Override
    public TemplateReplacement getClone() throws CloneNotSupportedException {
        return (TemplateReplacement)this.clone();
    }

    @Override
    public boolean relevantChange() {
        if (!this.changed) {
            return false;
        }
        for (EmailableParticipant participant : this.resourcesSet) {
            if (participant.state == 1) {
                return true;
            }
            if (participant.state != -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getReplacement() {
        if (this.resourcesSet.isEmpty()) {
            return this.getStringHelper().getString("No resources have been scheduled.");
        }
        int size = this.resourcesSet.size();
        StringBuilder b = new StringBuilder(size << 5);
        StringHelper stringHelper = this.getStringHelper();
        Iterator iter = this.resourcesSet.iterator();
        boolean added = this.processResource(b, stringHelper, (EmailableParticipant)iter.next());
        for (int i = 1; i < size; ++i) {
            if (added) {
                b.append(CRLF);
            }
            added = this.processResource(b, stringHelper, (EmailableParticipant)iter.next());
        }
        return b.toString();
    }

    private boolean processResource(StringBuilder b, StringHelper stringHelper, EmailableParticipant resource) {
        String name = resource.displayName;
        if (name == null) {
            name = resource.email;
        }
        if (this.changed) {
            if (resource.state == 1) {
                b.append("* ").append(stringHelper.getString("Added")).append(": ");
                b.append(name);
            } else if (resource.state == -1) {
                b.append("* ").append(stringHelper.getString("Removed")).append(": ");
                b.append(name);
            } else {
                b.append(name);
            }
            return true;
        }
        if (resource.state != -1) {
            b.append(name);
            return true;
        }
        return false;
    }

    @Override
    public TemplateToken getToken() {
        return TemplateToken.RESOURCES;
    }

    @Override
    public TemplateReplacement setChanged(boolean changed) {
        this.changed = changed;
        return this;
    }

    private Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.ENGLISH;
        }
        return this.locale;
    }

    private StringHelper getStringHelper() {
        if (this.stringHelper == null) {
            this.stringHelper = StringHelper.valueOf(this.getLocale());
        }
        return this.stringHelper;
    }

    @Override
    public TemplateReplacement setLocale(Locale locale) {
        if (locale == null || locale.equals(this.locale)) {
            return this;
        }
        this.locale = locale;
        this.stringHelper = null;
        return this;
    }

    @Override
    public TemplateReplacement setTimeZone(TimeZone timeZone) {
        return this;
    }

    @Override
    public boolean merge(TemplateReplacement other) {
        if (!ResourcesReplacement.class.isInstance(other)) {
            return false;
        }
        if (!TemplateToken.RESOURCES.equals((Object)other.getToken())) {
            return false;
        }
        if (!other.changed()) {
            return false;
        }
        ResourcesReplacement o = (ResourcesReplacement)other;
        this.changed = true;
        if (this.resourcesSet == null || o.resourcesSet != null) {
            this.resourcesSet = o.resourcesSet;
        }
        return true;
    }
}

