/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks.quota;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteFailedExceptionCodes;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class QuotaDeleteListener
implements DeleteListener {
    @Override
    public void deletePerformed(DeleteEvent event, Connection readCon, Connection writeCon) throws OXException {
        if (event.getType() == 1) {
            this.deleteUserEntriesFromDB(event, writeCon);
        } else if (event.getType() == 5) {
            this.deleteContextEntriesFromDB(event, writeCon);
        } else {
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteContextEntriesFromDB(DeleteEvent event, Connection writeCon) throws OXException {
        int contextId = event.getContext().getContextId();
        PreparedStatement stmt = null;
        try {
            boolean pos = true;
            stmt = writeCon.prepareStatement("DELETE FROM quota_context WHERE cid = ?");
            stmt.setInt(1, contextId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw DeleteFailedExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                catch (Exception e2) {
                    throw DeleteFailedExceptionCodes.ERROR.create(e2, e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
    }

    private void deleteUserEntriesFromDB(DeleteEvent event, Connection writeCon) throws OXException {
    }
}

