/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

public class NewAdminExtensionsUpdateTask
implements UpdateTask {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(NewAdminExtensionsUpdateTask.class));
    private static final String STR_INFO = "Performing update task 'NewAdminExtensionsUpdateTask'";
    private static final String CREATE_SEQUENCE_UID = "CREATE TABLE IF NOT EXISTS `sequence_uid_number` ( `cid` INT4 unsigned NOT NULL, `id` INT4 unsigned NOT NULL, PRIMARY KEY  (`cid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    private static final String CREATE_SEQUENCE_GID = "CREATE TABLE IF NOT EXISTS `sequence_gid_number` ( `cid` INT4 unsigned NOT NULL, `id` INT4 unsigned NOT NULL, PRIMARY KEY  (`cid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    private static final String CREATE_SEQUENCE_MAIL = "CREATE TABLE IF NOT EXISTS `sequence_mail_service` ( `cid` INT4 unsigned NOT NULL, `id` INT4 unsigned NOT NULL, PRIMARY KEY  (`cid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    private static final String TABLE_USER = "user";
    private static final String TABLE_DEL_USER = "del_user";
    private static final String TABLE_GROUPS = "groups";
    private static final String TABLE_DEL_GROUPS = "del_groups";
    private static final String COL_UID_NUMBER = "uidNumber";
    private static final String COL_GID_NUMBER = "gidNumber";
    private static final String COL_HOME_DIRECTORY = "homeDirectory";
    private static final String COL_LOGIN_SHELL = "loginShell";
    private static final String COL_PASSWORD_MECH = "passwordMech";
    private static final int NOGROUP = 65534;
    private static final int NOBODY = 65534;
    private static final String NOHOME = "/dev/null";
    private static final String NOSHELL = "/bin/false";
    private static final String SHA = "{SHA}";

    @Override
    public int addedWithVersion() {
        return 7;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)STR_INFO);
        }
        Hashtable<String, ArrayList<String>> missingCols = this.missingColumns(contextId);
        boolean deleteLastmodified = this.tableContainsColumn(contextId, TABLE_DEL_USER, "lastModified");
        Connection writeCon = Database.get(contextId, true);
        try {
            writeCon.setAutoCommit(false);
            this.createSequenceTables(writeCon, contextId);
            this.alterTables(writeCon, contextId, missingCols);
            this.updateTables(writeCon, contextId, missingCols);
            if (deleteLastmodified) {
                this.removeColumnFromTable(writeCon, contextId, "lastModified", TABLE_DEL_USER);
            }
            writeCon.commit();
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            try {
                writeCon.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOG.error((Object)"Problem setting autocommit to true.", (Throwable)e);
            }
            Database.back(contextId, true, writeCon);
        }
    }

    private final Hashtable<String, ArrayList<String>> missingColumns(int contextId) throws OXException {
        Connection readCon = Database.get(contextId, false);
        Statement stmt = null;
        ResultSet rs = null;
        Hashtable<String, ArrayList<String>> retTables = new Hashtable<String, ArrayList<String>>();
        for (String table : new String[]{TABLE_USER, TABLE_GROUPS, TABLE_DEL_USER, TABLE_DEL_GROUPS}) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(COL_GID_NUMBER);
            if (table.equals(TABLE_USER) || table.equals(TABLE_DEL_USER)) {
                ret.add(COL_UID_NUMBER);
                ret.add(COL_HOME_DIRECTORY);
                ret.add(COL_LOGIN_SHELL);
            }
            if (table.equals(TABLE_DEL_USER)) {
                ret.add(COL_PASSWORD_MECH);
            }
            retTables.put(table, ret);
        }
        try {
            stmt = readCon.createStatement();
            for (String table : new String[]{TABLE_USER, TABLE_GROUPS, TABLE_DEL_USER, TABLE_DEL_GROUPS}) {
                rs = stmt.executeQuery("SELECT * FROM " + table);
                ResultSetMetaData meta = rs.getMetaData();
                int length = meta.getColumnCount();
                ArrayList<String> colList = retTables.get(table);
                for (int i = 1; i <= length && colList.size() > 0; ++i) {
                    for (String col : new String[]{COL_GID_NUMBER, COL_UID_NUMBER, COL_HOME_DIRECTORY, COL_LOGIN_SHELL, COL_PASSWORD_MECH}) {
                        if (!col.equals(meta.getColumnName(i))) continue;
                        colList.remove(col);
                    }
                }
            }
            Hashtable<String, ArrayList<String>> hashtable = retTables;
            return hashtable;
        }
        catch (SQLException sQLException) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(sQLException, sQLException.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(rs, stmt);
            if (readCon != null) {
                Database.back(contextId, false, readCon);
            }
        }
    }

    private void createSequenceTables(Connection con, int contextId) throws OXException {
        PreparedStatement stmt = null;
        try {
            for (String createStmt : new String[]{CREATE_SEQUENCE_UID, CREATE_SEQUENCE_GID, CREATE_SEQUENCE_MAIL}) {
                stmt = con.prepareStatement(createStmt);
                stmt.executeUpdate();
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    private void alterTables(Connection con, int contextId, Hashtable<String, ArrayList<String>> missingCols) throws OXException {
        PreparedStatement stmt = null;
        try {
            for (Map.Entry<String, ArrayList<String>> entry : missingCols.entrySet()) {
                String table = entry.getKey();
                ArrayList<String> cols = entry.getValue();
                if (cols.size() > 0 && (table.equals(TABLE_USER) || table.equals(TABLE_DEL_USER))) {
                    for (String col : cols) {
                        if (col.equals(COL_GID_NUMBER)) {
                            stmt = con.prepareStatement("ALTER TABLE " + table + " ADD COLUMN gidNumber INT4 UNSIGNED NOT NULL");
                            stmt.executeUpdate();
                            stmt.close();
                            continue;
                        }
                        if (col.equals(COL_UID_NUMBER)) {
                            stmt = con.prepareStatement("ALTER TABLE " + table + " ADD COLUMN uidNumber INT4 UNSIGNED NOT NULL");
                            stmt.executeUpdate();
                            stmt.close();
                            continue;
                        }
                        if (col.equals(COL_HOME_DIRECTORY)) {
                            stmt = con.prepareStatement("ALTER TABLE " + table + " ADD COLUMN homeDirectory VARCHAR(128) NOT NULL");
                            stmt.executeUpdate();
                            stmt.close();
                            continue;
                        }
                        if (col.equals(COL_LOGIN_SHELL)) {
                            stmt = con.prepareStatement("ALTER TABLE " + table + " ADD COLUMN loginShell VARCHAR(128) NOT NULL");
                            stmt.executeUpdate();
                            stmt.close();
                            continue;
                        }
                        if (!col.equals(COL_PASSWORD_MECH) || !table.equals(TABLE_DEL_USER)) continue;
                        stmt = con.prepareStatement("ALTER TABLE " + table + " ADD COLUMN passwordMech VARCHAR(128) NOT NULL");
                        stmt.executeUpdate();
                        stmt.close();
                    }
                    continue;
                }
                if (cols.size() <= 0 || !table.equals(TABLE_GROUPS) && !table.equals(TABLE_DEL_GROUPS)) continue;
                for (String col : cols) {
                    if (!col.equals(COL_GID_NUMBER)) continue;
                    stmt = con.prepareStatement("ALTER TABLE " + table + " ADD COLUMN gidNumber INT4 UNSIGNED NOT NULL");
                    stmt.executeUpdate();
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    private void updateTables(Connection con, int contextId, Hashtable<String, ArrayList<String>> missingCols) throws OXException {
        PreparedStatement stmt = null;
        try {
            for (Map.Entry<String, ArrayList<String>> entry : missingCols.entrySet()) {
                String table = entry.getKey();
                ArrayList<String> cols = entry.getValue();
                if (cols.size() > 0 && (table.equals(TABLE_USER) || table.equals(TABLE_DEL_USER))) {
                    for (String col : cols) {
                        if (col.equals(COL_GID_NUMBER)) {
                            stmt = con.prepareStatement("UPDATE " + table + " SET gidNumber=?");
                            stmt.setInt(1, 65534);
                            stmt.executeUpdate();
                            stmt.close();
                            continue;
                        }
                        if (col.equals(COL_UID_NUMBER)) {
                            stmt = con.prepareStatement("UPDATE " + table + " SET uidNumber=?");
                            stmt.setInt(1, 65534);
                            stmt.executeUpdate();
                            stmt.close();
                            continue;
                        }
                        if (col.equals(COL_HOME_DIRECTORY)) {
                            stmt = con.prepareStatement("UPDATE " + table + " SET homeDirectory=?");
                            stmt.setString(1, NOHOME);
                            stmt.executeUpdate();
                            stmt.close();
                            continue;
                        }
                        if (col.equals(COL_LOGIN_SHELL)) {
                            stmt = con.prepareStatement("UPDATE " + table + " SET loginShell=?");
                            stmt.setString(1, NOSHELL);
                            stmt.executeUpdate();
                            stmt.close();
                            continue;
                        }
                        if (!col.equals(COL_PASSWORD_MECH) || !table.equals(TABLE_DEL_USER)) continue;
                        stmt = con.prepareStatement("UPDATE " + table + " SET passwordMech=?");
                        stmt.setString(1, SHA);
                        stmt.executeUpdate();
                        stmt.close();
                    }
                    continue;
                }
                if (cols.size() <= 0 || !table.equals(TABLE_GROUPS) && !table.equals(TABLE_DEL_GROUPS)) continue;
                for (String col : cols) {
                    if (!col.equals(COL_GID_NUMBER)) continue;
                    stmt = con.prepareStatement("UPDATE " + table + " SET gidNumber=?");
                    stmt.setInt(1, 65534);
                    stmt.executeUpdate();
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    private final boolean tableContainsColumn(int contextId, String table, String column) throws OXException {
        boolean bl;
        Connection readCon = Database.get(contextId, false);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readCon.createStatement();
            rs = stmt.executeQuery("SELECT * FROM " + table);
            ResultSetMetaData meta = rs.getMetaData();
            int length = meta.getColumnCount();
            boolean found = false;
            for (int i = 1; i <= length && !found; ++i) {
                if (!column.equals(meta.getColumnName(i))) continue;
                found = true;
            }
            bl = found;
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (readCon != null) {
                    Database.back(contextId, false, readCon);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (readCon != null) {
            Database.back(contextId, false, readCon);
        }
        return bl;
    }

    private void removeColumnFromTable(Connection con, int contextId, String column, String table) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("ALTER TABLE " + table + " DROP " + column);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            try {
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
    }
}

