/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MALPollDropConstraintsTask
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        boolean rollback = false;
        try {
            con.setAutoCommit(false);
            rollback = true;
            if (!Tools.tableExists(con, "malPollHash")) {
                return;
            }
            List<String> tables = Arrays.asList("malPollHash");
            for (String table : tables) {
                this.dropForeignKeysFrom(table, con);
            }
            LinkedHashMap indexes = new LinkedHashMap();
            ArrayList<List<String>> indexList = new ArrayList<List<String>>(4);
            indexList.add(Arrays.asList("cid", "user"));
            indexList.add(Arrays.asList("cid", "user", "id"));
            indexes.put("malPollHash", indexList);
            for (Map.Entry entry : indexes.entrySet()) {
                String table = (String)entry.getKey();
                for (List cols : (List)entry.getValue()) {
                    this.checkIndex(table, cols.toArray(new String[cols.size()]), null, con);
                }
            }
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropForeignKeysFrom(String table, Connection con) throws SQLException {
        List<String> keyNames = Tools.allForeignKey(con, table);
        Statement stmt = null;
        for (String keyName : keyNames) {
            try {
                stmt = con.createStatement();
                stmt.execute("ALTER TABLE " + table + " DROP FOREIGN KEY " + keyName);
            }
            finally {
                DBUtils.closeSQLStuff(null, stmt);
            }
        }
    }

    private void checkIndex(String table, String[] columns, String optName, Connection con) throws SQLException {
        if (null == Tools.existsIndex(con, table, columns)) {
            Tools.createIndex(con, table, optName, columns, false);
        }
    }
}

