/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.osgi;

import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.groupware.update.internal.DynamicList;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class UpdateTaskCustomizer
implements ServiceTrackerCustomizer<UpdateTaskProviderService, UpdateTaskProviderService> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(UpdateTaskCustomizer.class));
    private final BundleContext context;

    public UpdateTaskCustomizer(BundleContext context) {
        this.context = context;
    }

    public UpdateTaskProviderService addingService(ServiceReference<UpdateTaskProviderService> reference) {
        UpdateTaskProviderService providerService = (UpdateTaskProviderService)this.context.getService(reference);
        DynamicList registry = DynamicList.getInstance();
        Collection<? extends UpdateTask> collection = providerService.getUpdateTasks();
        boolean error = false;
        for (UpdateTask updateTask : collection) {
            if (registry.addUpdateTask(updateTask)) continue;
            LOG.error((Object)("Update task \"" + updateTask.getClass().getName() + "\" could not be registered."), (Throwable)new Exception());
            error = true;
            break;
        }
        if (!error) {
            return providerService;
        }
        for (UpdateTask updateTask : collection) {
            registry.removeUpdateTask(updateTask);
        }
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<UpdateTaskProviderService> reference, UpdateTaskProviderService service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<UpdateTaskProviderService> reference, UpdateTaskProviderService service) {
        if (null != service) {
            try {
                DynamicList registry = DynamicList.getInstance();
                UpdateTaskProviderService providerService = service;
                Collection<? extends UpdateTask> collection = providerService.getUpdateTasks();
                for (UpdateTask updateTask : collection) {
                    registry.removeUpdateTask(updateTask);
                }
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }
}

