/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks.database;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class TasksModifyCostColumnTask
extends UpdateTaskAdapter {
    private DatabaseService service;

    public TasksModifyCostColumnTask(DatabaseService service) {
        this.service = service;
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        Connection con = this.service.getForUpdateTask(contextID);
        Column actualCostsColumn = new Column("actual_costs", "DECIMAL(12,2) DEFAULT NULL");
        Column targetCostsColumn = new Column("target_costs", "DECIMAL(12,2) DEFAULT NULL");
        try {
            DBUtils.startTransaction(con);
            Tools.checkAndModifyColumns(con, "task", actualCostsColumn, targetCostsColumn);
            Tools.checkAndModifyColumns(con, "del_task", actualCostsColumn, targetCostsColumn);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            this.service.backForUpdateTask(contextID, con);
        }
    }
}

