/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.ReminderWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.json.ReminderAJAXRequest;
import com.openexchange.groupware.reminder.json.actions.AbstractReminderAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="updates", description="Get updated reminders", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, responseDescription="")
public final class UpdatesAction
extends AbstractReminderAction {
    public UpdatesAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(ReminderAJAXRequest req) throws OXException, JSONException {
        Date timestamp = req.checkDate("timestamp");
        String timeZoneId = req.getParameter("timezone");
        TimeZone timeZone = null == timeZoneId ? req.getTimeZone() : TimeZoneUtils.getTimeZone(timeZoneId);
        JSONArray jsonResponseArray = new JSONArray();
        SearchIterator it = null;
        try {
            ServerSession session = req.getSession();
            ReminderHandler reminderSql = new ReminderHandler(session.getContext());
            it = reminderSql.listModifiedReminder(session.getUserId(), timestamp);
            while (it.hasNext()) {
                ReminderWriter reminderWriter = new ReminderWriter(timeZone);
                ReminderObject reminder = (ReminderObject)it.next();
                if (reminder.isRecurrenceAppointment()) {
                    // empty if block
                }
                if (!UpdatesAction.hasModulePermission(reminder, session) || !UpdatesAction.stillAccepted(reminder, session)) continue;
                JSONObject jsonReminderObj = new JSONObject();
                reminderWriter.writeObject(reminder, jsonReminderObj);
                jsonResponseArray.put((Object)jsonReminderObj);
            }
            AJAXRequestResult aJAXRequestResult = new AJAXRequestResult(jsonResponseArray, timestamp, "json");
            return aJAXRequestResult;
        }
        finally {
            if (null != it) {
                it.close();
            }
        }
    }
}

