/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify.hostname.osgi;

import com.openexchange.groupware.notify.hostname.internal.HostDataLoginHandler;
import com.openexchange.log.Log;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.systemname.SystemNameService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class HostDataLoginHandlerRegisterer
implements ServiceTrackerCustomizer<SystemNameService, SystemNameService> {
    private static final org.apache.commons.logging.Log LOG = Log.loggerFor(HostDataLoginHandlerRegisterer.class);
    private final Lock lock = new ReentrantLock();
    private final BundleContext context;
    private final HostDataLoginHandler loginHandler;
    private SystemNameService service = null;
    private ServiceRegistration<LoginHandlerService> registration = null;

    public HostDataLoginHandlerRegisterer(BundleContext context, HostDataLoginHandler loginHandler) {
        this.context = context;
        this.loginHandler = loginHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemNameService addingService(ServiceReference<SystemNameService> reference) {
        SystemNameService foundService = (SystemNameService)this.context.getService(reference);
        boolean needsRegistration = false;
        this.lock.lock();
        try {
            if (null == this.service) {
                this.service = foundService;
                needsRegistration = null == this.registration;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!needsRegistration && this.registration != null) {
            LOG.warn((Object)("Found multiple SysteNameService instances. Ignoring " + this.service.getClass().getName()));
            foundService = null;
            this.context.ungetService(reference);
        }
        if (needsRegistration) {
            this.loginHandler.setSystemNameService(this.service);
            this.registration = this.context.registerService(LoginHandlerService.class, (Object)this.loginHandler, null);
        }
        return foundService;
    }

    public void modifiedService(ServiceReference<SystemNameService> reference, SystemNameService foundService) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<SystemNameService> reference, SystemNameService foundService) {
        ServiceRegistration<LoginHandlerService> unregister = null;
        this.lock.lock();
        try {
            if (null != foundService && this.service == foundService) {
                this.loginHandler.setSystemNameService(null);
                this.service = null;
                unregister = this.registration;
                this.registration = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (null != unregister) {
            unregister.unregister();
            this.context.ungetService(reference);
        }
    }
}

