/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify;

import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.notify.NotificationPool;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.conf.AbstractConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class NotificationConfig
extends AbstractConfig
implements Initialization {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(NotificationConfig.class));
    private static Map<String, String> overriddenProperties = null;
    private static NotificationConfig INSTANCE = new NotificationConfig();

    public static NotificationConfig getInstance() {
        return INSTANCE;
    }

    @Override
    protected String getPropertyFileName() throws OXException {
        String filename;
        ConfigurationService configService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        File file = configService.getFileByName("notification.properties");
        String string = filename = null == file ? null : file.getPath();
        if (null == filename) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create("notification.properties");
        }
        return filename;
    }

    public static String getProperty(NotificationProperty prop, String def) {
        String overridden;
        if (overriddenProperties != null && (overridden = overriddenProperties.get(prop.name)) != null) {
            return overridden;
        }
        if (!INSTANCE.isPropertiesLoadInternal()) {
            try {
                INSTANCE.loadPropertiesInternal();
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return def;
            }
        }
        if (!INSTANCE.isPropertiesLoadInternal()) {
            return def;
        }
        return INSTANCE.getPropertyInternal(prop.getName(), def);
    }

    public static boolean getPropertyAsBoolean(NotificationProperty prop, boolean def) {
        String boolVal = NotificationConfig.getProperty(prop, null);
        if (boolVal == null) {
            return def;
        }
        return Boolean.parseBoolean(boolVal);
    }

    public static void override(NotificationProperty prop, String value) {
        if (overriddenProperties == null) {
            overriddenProperties = new HashMap<String, String>();
        }
        overriddenProperties.put(prop.name, value);
    }

    public static void forgetOverrides() {
        overriddenProperties = null;
    }

    public void start() throws OXException {
        if (!INSTANCE.isPropertiesLoadInternal()) {
            INSTANCE.loadPropertiesInternal();
        }
        NotificationPool.getInstance().startup();
    }

    public void stop() {
        NotificationPool.getInstance().shutdown();
        INSTANCE = new NotificationConfig();
    }

    public static enum NotificationProperty {
        NOTIFY_ON_DELETE("notify_participants_on_delete"),
        OBJECT_LINK("object_link"),
        INTERNAL_IMIP("imipForInternalUsers"),
        FROM_SOURCE("com.openexchange.notification.fromSource");

        private final String name;

        private NotificationProperty(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

