/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.links;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.contact.Contacts;
import com.openexchange.groupware.container.LinkObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.links.LinkExceptionCodes;
import com.openexchange.groupware.links.LinksMySql;
import com.openexchange.groupware.tasks.Task2Links;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.util.UUIDs;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;

public class Links {
    static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Links.class));
    private static final Map<Integer, ModuleAccess> modules = new HashMap<Integer, ModuleAccess>(4);

    private Links() {
    }

    public static void performLinkStorage(LinkObject l, int user, int[] group, Session so, Connection writecon) throws OXException {
        LinksMySql lms;
        Connection readCon;
        ResultSet rs;
        Statement stmt;
        Context ct;
        block11: {
            ct = ContextStorage.getStorageContext(so.getContextId());
            if (!modules.get(Autoboxing.I((int)l.getFirstType())).isReadable(l.getFirstId(), l.getFirstFolder(), user, group, so) || !modules.get(Autoboxing.I((int)l.getSecondType())).isReadable(l.getSecondId(), l.getSecondFolder(), user, group, so)) {
                throw LinkExceptionCodes.NO_LINK_ACCESS_PERMISSION.create(Autoboxing.I((int)l.getFirstId()), Autoboxing.I((int)l.getFirstFolder()), Autoboxing.I((int)l.getSecondId()), Autoboxing.I((int)l.getSecondFolder()), Autoboxing.I((int)so.getContextId()));
            }
            stmt = null;
            rs = null;
            readCon = null;
            lms = new LinksMySql();
            try {
                readCon = DBPool.pickup(ct);
                stmt = readCon.createStatement();
                rs = stmt.executeQuery(lms.iFperformLinkStorage(l, so.getContextId()));
                if (!rs.next()) break block11;
                throw LinkExceptionCodes.ALREADY_LINKED.create(Autoboxing.I((int)l.getFirstId()), Autoboxing.I((int)l.getFirstFolder()), Autoboxing.I((int)l.getSecondId()), Autoboxing.I((int)l.getSecondFolder()), Autoboxing.I((int)so.getContextId()));
            }
            catch (SQLException e) {
                try {
                    throw LinkExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    if (readCon != null) {
                        DBPool.closeReaderSilent(ct, readCon);
                    }
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (readCon != null) {
            DBPool.closeReaderSilent(ct, readCon);
        }
        PreparedStatement ps = null;
        UUID uuid = UUID.randomUUID();
        byte[] uuidBinary = UUIDs.toByteArray((UUID)uuid);
        try {
            ps = writecon.prepareStatement(lms.iFperformLinkStorageInsertString());
            ps.setInt(1, l.getFirstId());
            ps.setInt(2, l.getFirstType());
            ps.setInt(3, l.getFirstFolder());
            ps.setInt(4, l.getSecondId());
            ps.setInt(5, l.getSecondType());
            ps.setInt(6, l.getSecondFolder());
            ps.setInt(7, l.getContectId());
            ps.setBytes(8, uuidBinary);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw LinkExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(ps));
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(ps);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(ps);
    }

    public static LinkObject[] getAllLinksFromObject(int id, int type, int folderId, int user, int[] group, Session so, Connection readcon) throws OXException {
        ArrayList<LinkObject> tmp = new ArrayList<LinkObject>();
        Statement stmt = null;
        ResultSet rs = null;
        LinksMySql lms = new LinksMySql();
        try {
            stmt = readcon.createStatement();
            rs = stmt.executeQuery(lms.iFgetAllLinksFromObject(id, type, folderId, so.getContextId()));
            while (rs.next()) {
                LinkObject lo = new LinkObject(rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getInt(7));
                if (!modules.get(lo.getFirstType()).isReadable(lo.getFirstId(), lo.getFirstFolder(), user, group, so) || !modules.get(lo.getSecondType()).isReadable(lo.getSecondId(), lo.getSecondFolder(), user, group, so)) continue;
                tmp.add(lo);
            }
        }
        catch (SQLException e) {
            try {
                throw LinkExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return tmp.toArray(new LinkObject[tmp.size()]);
    }

    public static int[][] deleteLinkFromObject(int id, int type, int folder, int[][] data, int user, int[] group, Session so, Connection readcon, Connection writecon) throws OXException {
        Statement stmt = null;
        Statement del = null;
        ResultSet rs = null;
        LinksMySql lms = new LinksMySql();
        ArrayList<int[]> resp = new ArrayList<int[]>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)new StringBuilder("Fetching rights for Module: " + type + " id:" + id + " folder:" + folder + " user:" + user + " group:" + Arrays.toString(group)));
        }
        if (!modules.get(type).isReadable(id, folder, user, group, so)) {
            for (int[] tmp : data) {
                resp.add(tmp);
            }
        }
        try {
            del = writecon.createStatement();
            stmt = readcon.createStatement();
            rs = stmt.executeQuery(lms.iFgetAllLinksFromObject(id, type, folder, so.getContextId()));
            int cnt = 0;
            while (rs.next()) {
                int loadid = rs.getInt(1);
                int loadtype = rs.getInt(2);
                int loadfolder = rs.getInt(3);
                boolean second = false;
                if (loadid == id) {
                    loadid = rs.getInt(4);
                    loadtype = rs.getInt(5);
                    loadfolder = rs.getInt(6);
                    second = true;
                }
                for (int i = 0; i < data.length; ++i) {
                    if (data[i][0] != loadid || data[i][1] != loadtype || data[i][2] != loadfolder) continue;
                    try {
                        if (!modules.get(Autoboxing.I((int)loadtype)).isReadable(loadid, loadfolder, user, group, so)) {
                            throw LinkExceptionCodes.NO_LINK_ACCESS_PERMISSION.create(Autoboxing.I((int)loadid), Autoboxing.I((int)loadfolder), Autoboxing.I((int)id), Autoboxing.I((int)folder), Autoboxing.I((int)so.getContextId()));
                        }
                        lms.iFDeleteLinkFromObject(del, second, id, type, folder, loadid, loadfolder, loadtype, so.getContextId());
                        ++cnt;
                        continue;
                    }
                    catch (OXException e) {
                        LOG.error((Object)"Unable to delete Link!", (Throwable)e);
                        resp.add(new int[]{loadid, loadtype, loadfolder});
                    }
                }
            }
            if (cnt == 0) {
                for (int[] tmp : data) {
                    resp.add(tmp);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw LinkExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt) + ',' + DBUtils.getStatement(del));
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                DBUtils.closeSQLStuff(del);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        DBUtils.closeSQLStuff(del);
        return (int[][])resp.toArray((T[])new int[resp.size()][]);
    }

    public static void deleteAllObjectLinks(int id, int type, int cid, Connection writecon) throws OXException {
        LinksMySql lms = new LinksMySql();
        PreparedStatement stmt = null;
        try {
            stmt = writecon.prepareStatement(lms.iFdeleteAllObjectLinks());
            stmt.setInt(1, id);
            stmt.setInt(2, type);
            stmt.setInt(3, id);
            stmt.setInt(4, type);
            stmt.setInt(5, cid);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw LinkExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
    }

    public static void deleteAllFolderLinks(int folderId, int cid, Connection writecon) throws OXException {
        LinksMySql lms = new LinksMySql();
        PreparedStatement stmt = null;
        try {
            stmt = writecon.prepareStatement(lms.iFdeleteAllFolderLinks());
            int pos = 1;
            stmt.setInt(pos++, folderId);
            stmt.setInt(pos++, folderId);
            stmt.setInt(pos++, cid);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw LinkExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
    }

    public static LinkObject[] getAllLinksByObjectID(int id, int type, int user, int[] group, Session so, Connection readcon) throws OXException {
        ArrayList<LinkObject> tmp = new ArrayList<LinkObject>();
        Statement stmt = null;
        ResultSet rs = null;
        LinksMySql lms = new LinksMySql();
        try {
            stmt = readcon.createStatement();
            rs = stmt.executeQuery(lms.iFgetAllLinksByObjectID(id, type, so.getContextId()));
            while (rs.next()) {
                boolean isSecondReadable;
                LinkObject lo = new LinkObject(rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getInt(7));
                ModuleAccess firstAccess = modules.get(lo.getFirstType());
                boolean isFirstReadable = firstAccess.supportsAccessByID() ? firstAccess.isReadableByID(lo.getFirstId(), user, group, so) : firstAccess.isReadable(lo.getFirstId(), lo.getFirstFolder(), user, group, so);
                ModuleAccess secondAccess = modules.get(lo.getSecondType());
                boolean bl = isSecondReadable = secondAccess.supportsAccessByID() ? secondAccess.isReadableByID(lo.getSecondId(), user, group, so) : secondAccess.isReadable(lo.getSecondId(), lo.getSecondFolder(), user, group, so);
                if (!isFirstReadable || !isSecondReadable) continue;
                tmp.add(lo);
            }
        }
        catch (SQLException e) {
            try {
                throw LinkExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return tmp.toArray(new LinkObject[tmp.size()]);
    }

    static {
        modules.put(1, new ModuleAccess(){
            CalendarCollectionService calColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);

            @Override
            public boolean supportsAccessByID() {
                return true;
            }

            @Override
            public boolean isReadable(int oid, int fid, int user, int[] group, Session so) throws OXException {
                Context ct = ContextStorage.getStorageContext(so.getContextId());
                if (!UserConfigurationStorage.getInstance().getUserConfigurationSafe(so.getUserId(), ct).hasCalendar()) {
                    return false;
                }
                try {
                    return this.calColl.getReadPermission(oid, fid, so, ct);
                }
                catch (OXException ox) {
                    LOG.error((Object)"UNABLE TO CHECK CALENDAR READRIGHT FOR LINK", (Throwable)ox);
                    return false;
                }
            }

            @Override
            public boolean hasModuleRights(Session so) throws OXException {
                Context ct = ContextStorage.getStorageContext(so.getContextId());
                return UserConfigurationStorage.getInstance().getUserConfigurationSafe(so.getUserId(), ct).hasCalendar();
            }

            @Override
            public boolean isReadableByID(int oid, int user, int[] group, Session so) throws OXException {
                Context ct = ContextStorage.getStorageContext(so.getContextId());
                if (!UserConfigurationStorage.getInstance().getUserConfigurationSafe(so.getUserId(), ct).hasCalendar()) {
                    return false;
                }
                int fid = -1;
                try {
                    fid = this.calColl.getAppointmentFolder(oid, user, ct);
                }
                catch (OXException ox) {
                    LOG.error((Object)"UNABLE TO CHECK CALENDAR READRIGHT FOR LINK", (Throwable)ox);
                    return false;
                }
                try {
                    return this.calColl.getReadPermission(oid, fid, so, ct);
                }
                catch (OXException ox) {
                    LOG.error((Object)"UNABLE TO CHECK CALENDAR READRIGHT FOR LINK", (Throwable)ox);
                    return false;
                }
            }
        });
        modules.put(4, new ModuleAccess(){

            @Override
            public boolean supportsAccessByID() {
                return true;
            }

            @Override
            public boolean isReadable(int oid, int fid, int user, int[] group, Session so) throws OXException {
                Context ctx = ContextStorage.getStorageContext(so.getContextId());
                UserPermissionBits userConfig = UserPermissionBitsStorage.getInstance().getUserPermissionBits(so.getUserId(), ctx);
                if (!userConfig.hasTask()) {
                    return false;
                }
                return Task2Links.checkMayReadTask(so, ctx, userConfig, oid, fid);
            }

            @Override
            public boolean hasModuleRights(Session so) throws OXException {
                Context ct = ContextStorage.getStorageContext(so.getContextId());
                return UserConfigurationStorage.getInstance().getUserConfigurationSafe(so.getUserId(), ct).hasTask();
            }

            @Override
            public boolean isReadableByID(int oid, int user, int[] group, Session so) throws OXException {
                Context ctx = ContextStorage.getStorageContext(so.getContextId());
                UserPermissionBits userConfig = UserPermissionBitsStorage.getInstance().getUserPermissionBits(so.getUserId(), ctx);
                if (!userConfig.hasTask()) {
                    return false;
                }
                return Task2Links.checkMayReadTask(so, ctx, userConfig, oid);
            }
        });
        modules.put(7, new ModuleAccess(){

            @Override
            public boolean supportsAccessByID() {
                return false;
            }

            @Override
            public boolean isReadable(int oid, int fid, int user, int[] group, Session so) throws OXException {
                Context ct = ContextStorage.getStorageContext(so.getContextId());
                if (!UserConfigurationStorage.getInstance().getUserConfigurationSafe(so.getUserId(), ct).hasContact()) {
                    return false;
                }
                try {
                    return Contacts.performContactReadCheckByID(oid, user, ct, UserConfigurationStorage.getInstance().getUserConfigurationSafe(so.getUserId(), ct));
                }
                catch (Exception e) {
                    LOG.error((Object)"UNABLE TO CHECK CONTACT READRIGHT FOR LINK", (Throwable)e);
                    return false;
                }
            }

            @Override
            public boolean hasModuleRights(Session so) throws OXException {
                Context ct = ContextStorage.getStorageContext(so.getContextId());
                return UserConfigurationStorage.getInstance().getUserConfigurationSafe(so.getUserId(), ct).hasContact();
            }

            @Override
            public boolean isReadableByID(int oid, int user, int[] group, Session so) {
                throw new UnsupportedOperationException("isReadableByID() not supported for contact module");
            }
        });
        modules.put(137, new ModuleAccess(){

            @Override
            public boolean supportsAccessByID() {
                return false;
            }

            @Override
            public boolean isReadable(int oid, int fid, int user, int[] group, Session so) throws OXException {
                InfostoreFacadeImpl DATABASE = new InfostoreFacadeImpl(new DBPoolProvider());
                Context ct = ContextStorage.getStorageContext(so.getContextId());
                try {
                    return DATABASE.exists(oid, -1, ct, UserStorage.getStorageUser(so.getUserId(), ct), UserPermissionBitsStorage.getInstance().getUserPermissionBits(so.getUserId(), ct));
                }
                catch (OXException e) {
                    LOG.error((Object)"UNABLE TO CHECK INFOSTORE READRIGHT FOR LINK", (Throwable)e);
                    return false;
                }
            }

            @Override
            public boolean hasModuleRights(Session so) throws OXException {
                Context ct = ContextStorage.getStorageContext(so.getContextId());
                return UserConfigurationStorage.getInstance().getUserConfigurationSafe(so.getUserId(), ct).hasInfostore();
            }

            @Override
            public boolean isReadableByID(int oid, int user, int[] group, Session so) {
                throw new UnsupportedOperationException("isReadableByID() not supported for infostore module");
            }
        });
    }

    private static interface ModuleAccess {
        public boolean isReadable(int var1, int var2, int var3, int[] var4, Session var5) throws OXException;

        public boolean isReadableByID(int var1, int var2, int[] var3, Session var4) throws OXException, UnsupportedOperationException;

        public boolean supportsAccessByID();

        public boolean hasModuleRights(Session var1) throws OXException;
    }
}

