/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.event.impl.FolderEventInterface;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageEventHelper;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.impl.FolderLockManager;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class LockCleaner
implements FolderEventInterface,
EventHandler {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(LockCleaner.class));
    private final EntityLockManager infoLockManager;
    private final FolderLockManager folderLockManager;

    public LockCleaner(FolderLockManager folderLockManager, EntityLockManager infoLockManager) {
        this.folderLockManager = folderLockManager;
        this.infoLockManager = infoLockManager;
    }

    @Override
    public void folderDeleted(FolderObject folderObj, Session session) {
        try {
            ServerSession sessionObj = ServerSessionAdapter.valueOf(session);
            this.folderLockManager.removeAll(folderObj.getObjectID(), sessionObj.getContext(), UserStorage.getStorageUser(sessionObj.getUserId(), sessionObj.getContext()));
        }
        catch (OXException e) {
            LOG.fatal((Object)("Couldn't remove folder locks from folder " + folderObj.getObjectID() + " in context " + session.getContextId() + ". Run the consistency tool."));
        }
    }

    @Override
    public void folderCreated(FolderObject folderObj, Session sessionObj) {
    }

    @Override
    public void folderModified(FolderObject folderObj, Session sessionObj) {
    }

    public void handleEvent(Event event) {
        if (FileStorageEventHelper.isInfostoreEvent((Event)event) && FileStorageEventHelper.isUpdateEvent((Event)event)) {
            try {
                int id = Integer.parseInt(FileStorageEventHelper.extractObjectId((Event)event));
                ServerSession session = ServerSessionAdapter.valueOf(FileStorageEventHelper.extractSession((Event)event));
                this.infoLockManager.removeAll(id, session.getContext(), UserStorage.getStorageUser(session.getUserId(), session.getContext()));
            }
            catch (OXException e) {
                LOG.fatal((Object)"Couldn't remove locks from infoitem. Run the consistency tool.", (Throwable)e);
            }
            catch (NumberFormatException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)FileStorageEventHelper.createDebugMessage((String)"UpdateEvent", (Event)event));
            }
        }
    }
}

