/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.groupware.EnumComponent;

public enum InfostoreExceptionCodes implements OXExceptionCode
{
    TOO_LONG_VALUES("Some field values are too long.", CATEGORY_TRUNCATED, 100),
    SQL_PROBLEM("Invalid SQL Query: %1$s", CATEGORY_ERROR, 200),
    PREFETCH_FAILED("Cannot pre-fetch results.", CATEGORY_TRY_AGAIN, 219),
    NOT_EXIST("The requested item does not exist.", CATEGORY_USER_INPUT, 300),
    COULD_NOT_LOAD("Could not load documents to check the permissions", CATEGORY_USER_INPUT, 301),
    NOT_INFOSTORE_FOLDER("The folder %1$s is not an Infostore folder", CATEGORY_ERROR, 302),
    NO_READ_PERMISSION("You do not have sufficient read permissions to read objects in this folder..", CATEGORY_PERMISSION_DENIED, 400),
    NO_CREATE_PERMISSION("You do not have sufficient permissions to create objects in this folder.", CATEGORY_PERMISSION_DENIED, 402),
    NO_WRITE_PERMISSION("You are not allowed to update this item.", CATEGORY_PERMISSION_DENIED, 403),
    NO_TARGET_CREATE_PERMISSION("You are not allowed to create objects in the target folder.", CATEGORY_PERMISSION_DENIED, 404),
    NOT_ALL_DELETED("Could not delete all objects.", CATEGORY_CONFLICT, 405),
    NO_DELETE_PERMISSION_FOR_VERSION("You do not have sufficient permissions to delete this version.", CATEGORY_PERMISSION_DENIED, 406),
    ITERATE_FAILED("Could not iterate result.", CATEGORY_ERROR, 413),
    ALREADY_LOCKED("This document is locked.", CATEGORY_CONFLICT, 415),
    LOCKED_BY_ANOTHER("You cannot unlock this document.", CATEGORY_CONFLICT, 416),
    WRITE_PERMS_FOR_UNLOCK_MISSING("You need write permissions to unlock a document.", CATEGORY_PERMISSION_DENIED, 417),
    WRITE_PERMS_FOR_LOCK_MISSING("You need write permissions to lock a document.", CATEGORY_PERMISSION_DENIED, 418),
    NEW_ID_FAILED("Could not generate new ID.", CATEGORY_ERROR, 420),
    NO_SOURCE_DELETE_PERMISSION("You are not allowed to delete objects in the source folder. This document cannot be moved.", CATEGORY_PERMISSION_DENIED, 421),
    DOCUMENT_NOT_EXIST("The document you requested does not exist.", CATEGORY_USER_INPUT, 438),
    FILENAME_NOT_UNIQUE("Files attached to InfoStore items must have unique names. File name: %1$s. The other document with this file name is %2$s.", CATEGORY_USER_INPUT, 441),
    NUMBER_OF_VERSIONS_FAILED("Could not determine number of versions for info item %1$s in context %s. Invalid query: %2$s", CATEGORY_ERROR, 442),
    NO_DELETE_PERMISSION("You do not have the permissions to delete at least one of the info items.", CATEGORY_PERMISSION_DENIED, 445),
    DOCUMENT_CONTAINS_NO_FILE("Illegal argument: document %1$s contains no file", CATEGORY_ERROR, 500),
    DUPLICATE_SUBFOLDER("Folder %1$s has two subfolders named %2$s. The database for context %3$s is not consistent.", CATEGORY_ERROR, 501),
    PATTERN_NEEDS_MORE_CHARACTERS("In order to accomplish the search, %1$s or more characters are required.", CATEGORY_USER_INPUT, 602),
    DELETE_FAILED("DocumentMetadata %1$s could not be deleted. Please try again.", CATEGORY_CONFLICT, 700),
    MODIFIED_CONCURRENTLY("The document could not be updated because it was modified. Reload the view.", CATEGORY_CONFLICT, 1302),
    UPDATED_BETWEEN_DO_AND_UNDO("The document was updated in between do and undo. The database is now probably inconsistent.", CATEGORY_CONFLICT, 1303),
    NO_DOCUMENTS_IN_VIRTUAL_FOLDER("This folder is a virtual folder. It cannot contain documents.", CATEGORY_USER_INPUT, 1700),
    VALIDATION_FAILED("Validation failed: %1$s", CATEGORY_USER_INPUT, 2100),
    VALIDATION_FAILED_SLASH("File name must not contain slashes.", CATEGORY_USER_INPUT, 2101),
    VALIDATION_FAILED_CHARACTERS("File name contains illegal characters.", CATEGORY_USER_INPUT, 2101),
    NO_OFFSET_FOR_NEW_VERSIONS("New file versions can't be saved with an offset.", CATEGORY_USER_INPUT, 2102);

    private final String message;
    private final Category category;
    private final int number;

    private InfostoreExceptionCodes(String message, Category category, int number) {
        this.message = message;
        this.category = category;
        this.number = number;
    }

    public String getPrefix() {
        return EnumComponent.INFOSTORE.getAbbreviation();
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public String getHelp() {
        return null;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

