/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.ConcurrentTIntObjectHashMap;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class IDGenerator {
    static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(IDGenerator.class));
    private static final Implementation GETID_IMPL = Implementations.MYSQLFUNCTION.getImpl();

    private IDGenerator() {
    }

    public static int getId(Context context, int type) throws SQLException {
        Connection con = null;
        try {
            con = DBPool.pickupWriteable(context);
        }
        catch (OXException e) {
            SQLException sexp = new SQLException("Cannot get connection from dbpool.");
            sexp.initCause(e);
            throw sexp;
        }
        int newId = -1;
        try {
            con.setAutoCommit(false);
            newId = IDGenerator.getId(context, type, con);
            con.commit();
        }
        catch (SQLException e) {
            con.rollback();
            throw e;
        }
        finally {
            con.setAutoCommit(true);
            DBPool.closeWriterSilent(context, con);
        }
        return newId;
    }

    public static int getId(Context context, int type, Connection con) throws SQLException {
        return IDGenerator.getId(context.getContextId(), type, con);
    }

    public static int getId(int contextId, int type, Connection con) throws SQLException {
        if (con.getAutoCommit()) {
            throw new SQLException("Generating unique identifier is threadsafe if and only if it is executed in a transaction.");
        }
        return GETID_IMPL.getId(contextId, type, con);
    }

    public static int getId(Connection con) throws SQLException {
        return IDGenerator.getId(con, -1);
    }

    public static int getId(Connection con, int type) throws SQLException {
        if (con.getAutoCommit()) {
            throw new SQLException("Generating unique identifier is threadsafe if and only if it is executed in a transaction.");
        }
        return GETID_IMPL.getId(-1, type, con);
    }

    static class MySQLFunction
    implements Implementation {
        private static final ConcurrentTIntObjectHashMap<String> TABLES;

        MySQLFunction() {
        }

        private String getSequenceTable(int type) throws SQLException {
            String retval = (String)TABLES.get(type);
            if (null == retval) {
                throw new SQLException("No table defined for type: " + type);
            }
            return retval;
        }

        @Override
        public int getId(int contextId, int type, Connection con) throws SQLException {
            int retval = type <= -1 ? this.getInternal(type, con) : this.getInternal(contextId, type, con);
            return retval;
        }

        private int getInternal(int type, Connection con) throws SQLException {
            String table = this.getSequenceTable(type);
            int newId = -1;
            PreparedStatement stmt = null;
            ResultSet result = null;
            try {
                stmt = con.prepareStatement("UPDATE " + table + " SET id=last_insert_id(id+1)");
                stmt.execute();
                stmt.close();
                stmt = con.prepareStatement("SELECT last_insert_id()");
                result = stmt.executeQuery();
                if (result.next()) {
                    newId = result.getInt(1);
                }
            }
            catch (SQLException e) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SQL Problem: " + stmt));
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(result, stmt);
            if (-1 == newId) {
                throw new SQLException("Table " + table + " contains no row.");
            }
            return newId;
        }

        private int getInternal(int contextId, int type, Connection con) throws SQLException {
            String table = this.getSequenceTable(type);
            int newId = -1;
            PreparedStatement stmt = null;
            ResultSet result = null;
            try {
                stmt = con.prepareStatement("UPDATE " + table + " SET id=last_insert_id(id+1) WHERE cid=?");
                stmt.setInt(1, contextId);
                stmt.execute();
                stmt.close();
                stmt = con.prepareStatement("SELECT last_insert_id()");
                result = stmt.executeQuery();
                if (result.next()) {
                    newId = result.getInt(1);
                }
            }
            catch (SQLException e) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SQL Problem: " + stmt));
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(result, stmt);
            if (-1 == newId) {
                throw new SQLException("Table " + table + " contains no row for context " + contextId);
            }
            return newId;
        }

        @Override
        public void registerType(String sql, int type) throws SQLException {
            if (TABLES.containsKey(type)) {
                throw new SQLException("Type " + type + " already in use.");
            }
            TABLES.put(type, (Object)sql);
        }

        static {
            ConcurrentTIntObjectHashMap tmp = new ConcurrentTIntObjectHashMap();
            tmp.put(-1, (Object)"configdb_sequence");
            tmp.put(1, (Object)"sequence_calendar");
            tmp.put(7, (Object)"sequence_contact");
            tmp.put(20, (Object)"sequence_folder");
            tmp.put(4, (Object)"sequence_task");
            tmp.put(31, (Object)"sequence_gui_setting");
            tmp.put(55, (Object)"sequence_reminder");
            tmp.put(75, (Object)"sequence_ical");
            tmp.put(130, (Object)"sequence_principal");
            tmp.put(135, (Object)"sequence_resource");
            tmp.put(137, (Object)"sequence_infostore");
            tmp.put(138, (Object)"sequence_attachment");
            tmp.put(139, (Object)"sequence_webdav");
            tmp.put(1131, (Object)"sequence_uid_number");
            tmp.put(1130, (Object)"sequence_gid_number");
            tmp.put(1132, (Object)"sequence_mail_service");
            tmp.put(1200, (Object)"sequence_genconf");
            tmp.put(126, (Object)"sequence_subscriptions");
            tmp.put(127, (Object)"sequence_publications");
            tmp.put(666, (Object)"sequence_uid_eav_node");
            TABLES = tmp;
        }
    }

    static class NoDBFunction
    implements Implementation {
        private static final ConcurrentTIntObjectHashMap<String> TABLES;

        NoDBFunction() {
        }

        private String getSequenceTable(int type) throws SQLException {
            String retval = (String)TABLES.get(type);
            if (null == retval) {
                throw new SQLException("No table defined for type: " + type);
            }
            return retval;
        }

        @Override
        public int getId(int contextId, int type, Connection con) throws SQLException {
            int retval = type <= -1 ? this.getInternal(type, con) : this.getInternal(contextId, type, con);
            return retval;
        }

        private int getInternal(int type, Connection con) throws SQLException {
            String table = this.getSequenceTable(type);
            int newId = -1;
            PreparedStatement stmt = null;
            ResultSet result = null;
            try {
                stmt = con.prepareStatement("UPDATE " + table + " SET id=id+1");
                stmt.execute();
                stmt.close();
                stmt = con.prepareStatement("SELECT id FROM " + table);
                result = stmt.executeQuery();
                if (result.next()) {
                    newId = result.getInt(1);
                }
            }
            catch (SQLException e) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SQL Problem: " + stmt));
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(result, stmt);
            if (-1 == newId) {
                throw new SQLException("Table " + table + " contains no row.");
            }
            return newId;
        }

        private int getInternal(int contextId, int type, Connection con) throws SQLException {
            String table = this.getSequenceTable(type);
            int newId = -1;
            PreparedStatement stmt = null;
            ResultSet result = null;
            try {
                stmt = con.prepareStatement("UPDATE " + table + " SET id=id+1 WHERE cid=?");
                stmt.setInt(1, contextId);
                stmt.execute();
                stmt.close();
                stmt = con.prepareStatement("SELECT id FROM " + table + " WHERE cid=?");
                stmt.setInt(1, contextId);
                result = stmt.executeQuery();
                if (result.next()) {
                    newId = result.getInt(1);
                }
            }
            catch (SQLException e) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SQL Problem: " + stmt));
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(result, stmt);
            if (-1 == newId) {
                throw new SQLException("Table " + table + " contains no row for context " + contextId);
            }
            return newId;
        }

        @Override
        public void registerType(String sql, int type) throws SQLException {
            if (TABLES.containsKey(type)) {
                throw new SQLException("Type " + type + " already in use.");
            }
            TABLES.put(type, (Object)sql);
        }

        static {
            ConcurrentTIntObjectHashMap tmp = new ConcurrentTIntObjectHashMap();
            tmp.put(-1, (Object)"configdb_sequence");
            tmp.put(1, (Object)"sequence_calendar");
            tmp.put(7, (Object)"sequence_contact");
            tmp.put(20, (Object)"sequence_folder");
            tmp.put(4, (Object)"sequence_task");
            tmp.put(31, (Object)"sequence_gui_setting");
            tmp.put(55, (Object)"sequence_reminder");
            tmp.put(75, (Object)"sequence_ical");
            tmp.put(130, (Object)"sequence_principal");
            tmp.put(135, (Object)"sequence_resource");
            tmp.put(137, (Object)"sequence_infostore");
            tmp.put(138, (Object)"sequence_attachment");
            tmp.put(139, (Object)"sequence_webdav");
            tmp.put(1131, (Object)"sequence_uid_number");
            tmp.put(1130, (Object)"sequence_gid_number");
            tmp.put(1132, (Object)"sequence_mail_service");
            tmp.put(1200, (Object)"sequence_genconf");
            tmp.put(126, (Object)"sequence_subscriptions");
            tmp.put(127, (Object)"sequence_publications");
            tmp.put(666, (Object)"sequence_uid_eav_node");
            TABLES = tmp;
        }
    }

    static class PreparedStatementImpl
    implements Implementation {
        private static final ConcurrentTIntObjectHashMap<String> TYPES;

        PreparedStatementImpl() {
        }

        private String getFunction(int type) throws SQLException {
            String retval = (String)TYPES.get(type);
            if (null == retval) {
                throw new SQLException("No function defined for type: " + type);
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getId(int contextId, int type, Connection con) throws SQLException {
            int newId = -1;
            PreparedStatement stmt = null;
            ResultSet result = null;
            try {
                stmt = con.prepareStatement(this.getFunction(type));
                if (-1 == contextId) {
                    stmt.setInt(1, contextId);
                }
                if ((result = stmt.executeQuery()).next()) {
                    newId = result.getInt(1);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
            DBUtils.closeSQLStuff(result, stmt);
            if (-1 == newId) {
                throw new SQLException("Function " + this.getFunction(type) + " returns no row for context " + contextId);
            }
            return newId;
        }

        @Override
        public void registerType(String sql, int type) throws SQLException {
            if (TYPES.containsKey(type)) {
                throw new SQLException("Type " + type + " already in use");
            }
            TYPES.put(type, (Object)sql);
        }

        static {
            ConcurrentTIntObjectHashMap tmp = new ConcurrentTIntObjectHashMap();
            tmp.put(-1, (Object)"CALL get_configdb_id()");
            tmp.put(1, (Object)"CALL get_calendar_id(?)");
            tmp.put(7, (Object)"CALL get_contact_id(?)");
            tmp.put(20, (Object)"CALL get_folder_id(?)");
            tmp.put(4, (Object)"CALL get_task_id(?)");
            tmp.put(31, (Object)"CALL get_gui_setting_id(?)");
            tmp.put(55, (Object)"CALL get_reminder_id(?)");
            tmp.put(75, (Object)"CALL get_ical_id(?)");
            tmp.put(130, (Object)"CALL get_principal_id(?)");
            tmp.put(135, (Object)"CALL get_resource_id(?)");
            tmp.put(137, (Object)"CALL get_infostore_id(?)");
            tmp.put(138, (Object)"CALL get_attachment_id(?)");
            tmp.put(139, (Object)"CALL get_webdav_id(?)");
            tmp.put(1131, (Object)"CALL get_uid_number_id(?)");
            tmp.put(1130, (Object)"CALL get_gid_number_id(?)");
            tmp.put(1132, (Object)"CALL get_mail_service_id(?)");
            tmp.put(1200, (Object)"CALL get_genconf_id(?)");
            tmp.put(126, (Object)"CALL get_subscriptions_id(?)");
            tmp.put(127, (Object)"CALL get_publications_id(?)");
            tmp.put(666, (Object)"CALL get_eav_id(?)");
            TYPES = tmp;
        }
    }

    static class CallableStatementImpl
    implements Implementation {
        private static final ConcurrentTIntObjectHashMap<String> TYPES;

        CallableStatementImpl() {
        }

        private String getFunction(int type) throws SQLException {
            String retval = (String)TYPES.get(type);
            if (null == retval) {
                throw new SQLException("No function defined for type: " + type);
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getId(int contextId, int type, Connection con) throws SQLException {
            int newId = -1;
            CallableStatement call = null;
            ResultSet result = null;
            try {
                call = con.prepareCall(this.getFunction(type));
                if (-1 != contextId) {
                    call.setInt(1, contextId);
                }
                boolean hasResults = call.execute();
                while (hasResults) {
                    result = call.getResultSet();
                    if (result.next()) {
                        newId = result.getInt(1);
                    }
                    hasResults = call.getMoreResults();
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, call);
                throw throwable;
            }
            DBUtils.closeSQLStuff(result, call);
            if (-1 == newId) {
                throw new SQLException("Function " + this.getFunction(type) + " returns no row for context " + contextId);
            }
            return newId;
        }

        @Override
        public void registerType(String sql, int type) throws SQLException {
            if (TYPES.containsKey(type)) {
                throw new SQLException("Type " + type + " already in use");
            }
            TYPES.put(type, (Object)sql);
        }

        static {
            ConcurrentTIntObjectHashMap tmp = new ConcurrentTIntObjectHashMap();
            tmp.put(-1, (Object)"{call get_configdb_id()}");
            tmp.put(1, (Object)"{call get_calendar_id(?)}");
            tmp.put(7, (Object)"{call get_contact_id(?)}");
            tmp.put(20, (Object)"{call get_folder_id(?)}");
            tmp.put(4, (Object)"{call get_task_id(?)}");
            tmp.put(31, (Object)"{call get_gui_setting_id(?)}");
            tmp.put(55, (Object)"{call get_reminder_id(?)}");
            tmp.put(75, (Object)"{call get_ical_id(?)}");
            tmp.put(130, (Object)"{call get_principal_id(?)}");
            tmp.put(135, (Object)"{call get_resource_id(?)}");
            tmp.put(137, (Object)"{call get_infostore_id(?)}");
            tmp.put(138, (Object)"{call get_attachment_id(?)}");
            tmp.put(139, (Object)"{call get_webdav_id(?)}");
            tmp.put(1131, (Object)"{call get_uid_number_id(?)}");
            tmp.put(1130, (Object)"{call get_gid_number_id(?)}");
            tmp.put(1132, (Object)"{call get_mail_service_id(?)}");
            TYPES = tmp;
        }
    }

    public static interface Implementation {
        public int getId(int var1, int var2, Connection var3) throws SQLException;

        public void registerType(String var1, int var2) throws SQLException;
    }

    public static enum Implementations {
        NODBFUNCTION(new NoDBFunction()),
        MYSQLFUNCTION(new MySQLFunction()),
        PREPAREDSTATEMENT(new PreparedStatementImpl()),
        CALLABLESTATEMENT(new CallableStatementImpl());

        private final Implementation impl;

        private Implementations(Implementation impl) {
            this.impl = impl;
        }

        public Implementation getImpl() {
            return this.impl;
        }
    }
}

