/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.GroupWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.json.GroupAJAXRequest;
import com.openexchange.group.json.actions.AbstractGroupAction;
import com.openexchange.server.ServiceLookup;
import java.util.Date;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;

@Action(method=RequestMethod.GET, name="all", description="Get all groups", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="The group id.")}, responseDescription="An array of group objects as described in Group data.")
public final class AllAction
extends AbstractGroupAction {
    public AllAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(GroupAJAXRequest req) throws OXException, JSONException {
        Date timestamp = new Date(0L);
        int[] columns = req.checkIntArray("columns");
        boolean loadMembers = false;
        LinkedList<Group.Field> fields = new LinkedList<Group.Field>();
        for (int column : columns) {
            Group.Field field = Group.Field.getByColumnNumber(column);
            if (field == Group.Field.MEMBERS) {
                loadMembers = true;
            }
            fields.add(field);
        }
        JSONArray jsonResponseArray = new JSONArray();
        GroupStorage groupStorage = GroupStorage.getInstance();
        Group[] groups = null;
        groups = groupStorage.getGroups(loadMembers, req.getSession().getContext());
        GroupWriter groupWriter = new GroupWriter();
        for (int a = 0; a < groups.length; ++a) {
            JSONArray row = new JSONArray();
            groupWriter.writeArray(groups[a], row, fields);
            if (groups[a].getLastModified().after(timestamp)) {
                timestamp = groups[a].getLastModified();
            }
            jsonResponseArray.put((Object)row);
        }
        return new AJAXRequestResult(jsonResponseArray, timestamp, "json");
    }
}

