/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook;

import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExtension;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Type;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.StringAllocator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class OutlookFolder
implements FolderExtension {
    private static final long serialVersionUID = 1076412172524386127L;
    private Folder realFolder;
    private Date lastModified;
    private int modifiedBy;
    private String treeId;
    private String name;
    private String localizedName;
    private String parent;
    private Permission[] permissions;
    private String[] subfolders;
    private boolean b_subfolders;
    private Boolean subscribed;
    private Boolean subscribedSubfolders;
    private String newId;

    public OutlookFolder(Folder source) {
        this.realFolder = source;
        this.modifiedBy = -1;
    }

    public Folder getRealFolder() {
        return this.realFolder;
    }

    public String toString() {
        return new StringAllocator(32).append("{ name=").append(this.getName()).append(", id=").append(this.getID()).append('}').toString();
    }

    @Override
    public Object clone() {
        try {
            int i;
            OutlookFolder clone = (OutlookFolder)super.clone();
            clone.realFolder = (Folder)(this.realFolder == null ? null : this.realFolder.clone());
            clone.lastModified = OutlookFolder.cloneDate(this.lastModified);
            if (this.permissions != null) {
                Permission[] thisPermissions = this.permissions;
                Permission[] clonePermissions = new Permission[thisPermissions.length];
                for (i = 0; i < thisPermissions.length; ++i) {
                    clonePermissions[i] = (Permission)thisPermissions[i].clone();
                }
                clone.permissions = clonePermissions;
            }
            if (this.subfolders != null) {
                String[] thisSub = this.subfolders;
                String[] cloneSub = new String[thisSub.length];
                for (i = 0; i < cloneSub.length; ++i) {
                    cloneSub[i] = thisSub[i];
                }
                clone.subfolders = cloneSub;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    @Override
    public String getNewID() {
        return this.newId;
    }

    @Override
    public void setNewID(String newId) {
        this.newId = newId;
    }

    @Override
    public int getCreatedBy() {
        return this.realFolder.getCreatedBy();
    }

    @Override
    public Date getCreationDate() {
        return this.realFolder.getCreationDate();
    }

    @Override
    public Date getLastModified() {
        return this.lastModified == null ? this.realFolder.getLastModified() : OutlookFolder.cloneDate(this.lastModified);
    }

    @Override
    public int getModifiedBy() {
        return -1 == this.modifiedBy ? this.realFolder.getModifiedBy() : this.modifiedBy;
    }

    @Override
    public void setCreatedBy(int createdBy) {
    }

    @Override
    public void setCreationDate(Date creationDate) {
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified == null ? null : new Date(lastModified.getTime());
    }

    @Override
    public void setModifiedBy(int modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Override
    public ContentType getContentType() {
        return this.realFolder.getContentType();
    }

    @Override
    public String getID() {
        return this.realFolder.getID();
    }

    @Override
    public String getLocalizedName(Locale locale) {
        Locale loc;
        Locale locale2 = loc = null == locale ? LocaleTools.DEFAULT_LOCALE : locale;
        if (null == this.name) {
            return this.realFolder.getLocalizedName(loc);
        }
        if (null == this.localizedName) {
            this.localizedName = StringHelper.valueOf(loc).getString(this.name);
        }
        return this.localizedName;
    }

    @Override
    public String getName() {
        return null == this.name ? this.realFolder.getName() : this.name;
    }

    @Override
    public String getParentID() {
        return null == this.parent ? this.realFolder.getParentID() : this.parent;
    }

    @Override
    public Permission[] getPermissions() {
        return null == this.permissions ? this.realFolder.getPermissions() : this.permissions;
    }

    @Override
    public String[] getSubfolderIDs() {
        return this.b_subfolders ? this.subfolders : this.realFolder.getSubfolderIDs();
    }

    @Override
    public String getTreeID() {
        return this.treeId;
    }

    @Override
    public Type getType() {
        return this.realFolder.getType();
    }

    @Override
    public void setContentType(ContentType contentType) {
    }

    @Override
    public void setID(String id) {
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.localizedName = null;
    }

    @Override
    public void setParentID(String parentId) {
        this.parent = parentId;
    }

    @Override
    public void setPermissions(Permission[] permissions) {
        this.permissions = permissions;
    }

    @Override
    public void setSubfolderIDs(String[] subfolderIds) {
        this.subfolders = subfolderIds;
        this.b_subfolders = true;
    }

    @Override
    public void setTreeID(String id) {
        this.treeId = id;
    }

    @Override
    public void setType(Type type) {
    }

    @Override
    public boolean isSubscribed() {
        return null == this.subscribed ? this.realFolder.isSubscribed() : this.subscribed.booleanValue();
    }

    @Override
    public void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    @Override
    public boolean hasSubscribedSubfolders() {
        return null == this.subscribedSubfolders ? this.realFolder.hasSubscribedSubfolders() : this.subscribedSubfolders.booleanValue();
    }

    @Override
    public void setSubscribedSubfolders(boolean subscribedSubfolders) {
        this.subscribedSubfolders = subscribedSubfolders;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public boolean isGlobalID() {
        return this.realFolder.isGlobalID();
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public int getCapabilities() {
        return this.realFolder.getCapabilities();
    }

    @Override
    public int getDeleted() {
        return this.realFolder.getDeleted();
    }

    @Override
    public int getNew() {
        return this.realFolder.getNew();
    }

    @Override
    public String getSummary() {
        return this.realFolder.getSummary();
    }

    @Override
    public int[] getTotalAndUnread() {
        if (this.realFolder instanceof FolderExtension) {
            return ((FolderExtension)this.realFolder).getTotalAndUnread();
        }
        return null;
    }

    @Override
    public int getTotal() {
        return this.realFolder.getTotal();
    }

    @Override
    public int getUnread() {
        return this.realFolder.getUnread();
    }

    @Override
    public boolean isDefault() {
        return this.realFolder.isDefault();
    }

    @Override
    public void setCapabilities(int capabilities) {
    }

    @Override
    public void setDefault(boolean deefault) {
    }

    @Override
    public void setDeleted(int deleted) {
    }

    @Override
    public void setNew(int nu) {
    }

    @Override
    public void setSummary(String summary) {
    }

    @Override
    public void setTotal(int total) {
    }

    @Override
    public void setUnread(int unread) {
    }

    @Override
    public int getDefaultType() {
        return this.realFolder.getDefaultType();
    }

    @Override
    public void setDefaultType(int defaultType) {
    }

    @Override
    public int getBits() {
        return this.realFolder.getBits();
    }

    @Override
    public void setBits(int bits) {
    }

    @Override
    public void setMeta(Map<String, Object> meta) {
        this.realFolder.setMeta(meta);
    }

    @Override
    public Map<String, Object> getMeta() {
        return this.realFolder.getMeta();
    }

    private static Date cloneDate(Date d) {
        if (null == d) {
            return null;
        }
        return new Date(d.getTime());
    }

    @Override
    public Set<String> getSupportedCapabilities() {
        return this.realFolder.getSupportedCapabilities();
    }

    @Override
    public void setSupportedCapabilities(Set<String> capabilities) {
        this.realFolder.setSupportedCapabilities(capabilities);
    }
}

