/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.folderstorage.type.PublicType;
import com.openexchange.folderstorage.type.SharedType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;

public final class UpdatesPerformer
extends AbstractUserizedFolderPerformer {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(UpdatesPerformer.class));
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();
    private static final TreeChecker TRUST_ALL_CHECKER = new TreeChecker(){

        @Override
        public boolean containsVirtualFolder(String folderId, String treeId, StorageType storageType) throws OXException {
            return true;
        }
    };

    public UpdatesPerformer(ServerSession session, FolderServiceDecorator decorator) {
        super(session, decorator);
    }

    public UpdatesPerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public UpdatesPerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(session, decorator, folderStorageDiscoverer);
    }

    public UpdatesPerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    public UserizedFolder[][] doUpdates(String treeId, Date since, boolean ignoreDeleted, ContentType[] includeContentTypes) throws OXException {
        ArrayList<FolderStorage> realFolderStorages = new ArrayList<FolderStorage>(Arrays.asList(this.folderStorageDiscoverer.getTreeFolderStorages(FolderStorage.REAL_TREE_ID)));
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(realFolderStorages.size() + 1);
        for (FolderStorage folderStorage : realFolderStorages) {
            this.checkOpenedStorage(folderStorage, false, openedStorages);
        }
        long start = DEBUG_ENABLED ? System.currentTimeMillis() : 0L;
        try {
            UserizedFolder[] deleted;
            TreeChecker treeChecker;
            Session s = this.storageParameters.getSession();
            UserPermissionBits userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserPermissionBits() : UserPermissionBitsStorage.getInstance().getUserPermissionBits(this.user.getId(), this.storageParameters.getContext());
            boolean isReal = FolderStorage.REAL_TREE_ID.equals(treeId);
            if (isReal) {
                treeChecker = TRUST_ALL_CHECKER;
            } else {
                FolderStorage[] treeFolderStorages = this.folderStorageDiscoverer.getTreeFolderStorages(treeId);
                if (null == treeFolderStorages || treeFolderStorages.length == 0) {
                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, "*");
                }
                FolderStorage treeStorage = treeFolderStorages[0];
                this.checkOpenedStorage(treeStorage, false, openedStorages);
                treeChecker = new TreeCheckerImpl(treeStorage, this.storageParameters);
            }
            ArrayList<Folder> updatedList = new ArrayList<Folder>();
            ArrayList<Folder> deletedList = ignoreDeleted ? null : new ArrayList<Folder>();
            HashSet<String> virtualSharedIDs = new HashSet<String>();
            ArrayList<Folder> modifiedFolders = new ArrayList<Folder>();
            for (FolderStorage folderStorage : realFolderStorages) {
                String[] modifiedFolderIDs = folderStorage.getModifiedFolderIDs(treeId, since, includeContentTypes, this.storageParameters);
                if (modifiedFolderIDs.length <= 0) continue;
                try {
                    modifiedFolders.addAll(folderStorage.getFolders(FolderStorage.REAL_TREE_ID, Arrays.asList(modifiedFolderIDs), this.storageParameters));
                }
                catch (OXException e) {
                    for (String modifiedFolderID : modifiedFolderIDs) {
                        try {
                            modifiedFolders.add(folderStorage.getFolder(FolderStorage.REAL_TREE_ID, modifiedFolderID, this.storageParameters));
                        }
                        catch (OXException ee) {
                            LOG.error((Object)new StringBuilder(128).append("Updated folder \"").append(modifiedFolderID).append("\" could not be fetched from storage \"").append(folderStorage.getClass().getName()).append("\":\n").append(ee.getMessage()).toString(), (Throwable)ee);
                        }
                    }
                }
            }
            if (!FolderStorage.REAL_TREE_ID.equals(treeId)) {
                FolderStorage[] storages;
                for (FolderStorage storage : storages = this.folderStorageDiscoverer.getTreeFolderStorages(treeId)) {
                    boolean started = storage.startTransaction(this.storageParameters, false);
                    try {
                        String[] modifiedFolderIDs = storage.getModifiedFolderIDs(treeId, since, includeContentTypes, this.storageParameters);
                        if (modifiedFolderIDs.length > 0) {
                            try {
                                modifiedFolders.addAll(storage.getFolders(FolderStorage.REAL_TREE_ID, Arrays.asList(modifiedFolderIDs), this.storageParameters));
                            }
                            catch (OXException e) {
                                for (String modifiedFolderID : modifiedFolderIDs) {
                                    try {
                                        modifiedFolders.add(storage.getFolder(FolderStorage.REAL_TREE_ID, modifiedFolderID, this.storageParameters));
                                    }
                                    catch (OXException ee) {
                                        LOG.error((Object)new StringBuilder(128).append("Updated folder \"").append(modifiedFolderID).append("\" could not be fetched from storage \"").append(storage.getClass().getName()).append("\":\n").append(ee.getMessage()).toString(), (Throwable)ee);
                                    }
                                }
                            }
                        }
                        if (!started) continue;
                        storage.commitTransaction(this.storageParameters);
                    }
                    catch (OXException e) {
                        if (started) {
                            storage.rollback(this.storageParameters);
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        if (started) {
                            storage.rollback(this.storageParameters);
                        }
                        FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                    }
                }
            }
            boolean addSystemSharedFolder = false;
            boolean checkVirtualListFolders = false;
            boolean sharedFolderAccess = userConfiguration.hasFullSharedFolderAccess();
            int size = modifiedFolders.size();
            Iterator iter = modifiedFolders.iterator();
            for (int i = 0; i < size; ++i) {
                Folder f = (Folder)iter.next();
                Permission effectivePerm = this.getEffectivePermission(f);
                if (effectivePerm.isVisible()) {
                    if (UpdatesPerformer.isShared(f, this.getUserId())) {
                        if (sharedFolderAccess) {
                            virtualSharedIDs.add(new StringBuilder(8).append("u:").append(f.getCreatedBy()).toString());
                            addSystemSharedFolder = true;
                        } else if (deletedList != null && treeChecker.containsVirtualFolder(f.getID(), treeId, StorageType.WORKING)) {
                            deletedList.add(f);
                        }
                    } else if (UpdatesPerformer.isPublic(f)) {
                        String parentID = f.getParentID();
                        Folder parent = this.getFolder(FolderStorage.REAL_TREE_ID, parentID, realFolderStorages);
                        Permission parentPerm = this.getEffectivePermission(parent);
                        if (parentPerm.isVisible()) {
                            if (treeChecker.containsVirtualFolder(parentID, treeId, StorageType.WORKING)) {
                                updatedList.add(parent);
                            }
                        } else if (InfostoreContentType.getInstance().equals(f.getContentType())) {
                            String infostoreId = String.valueOf(9);
                            if (treeChecker.containsVirtualFolder(infostoreId, treeId, StorageType.WORKING)) {
                                updatedList.add(this.getFolder(FolderStorage.REAL_TREE_ID, infostoreId, realFolderStorages));
                            }
                        } else {
                            String publicId = String.valueOf(2);
                            if (treeChecker.containsVirtualFolder(publicId, treeId, StorageType.WORKING)) {
                                updatedList.add(this.getFolder(FolderStorage.REAL_TREE_ID, publicId, realFolderStorages));
                            }
                        }
                    }
                    if (!treeChecker.containsVirtualFolder(f.getID(), treeId, StorageType.WORKING)) continue;
                    updatedList.add(f);
                    continue;
                }
                checkVirtualListFolders |= PublicType.getInstance().equals(f.getType());
                if (deletedList == null || !treeChecker.containsVirtualFolder(f.getID(), treeId, StorageType.WORKING)) continue;
                deletedList.add(f);
            }
            if (checkVirtualListFolders && deletedList != null) {
                Set<String> set = this.getPublicSubfolderIDs(FolderStorage.REAL_TREE_ID, realFolderStorages);
                String vid = String.valueOf(11);
                if (userConfiguration.hasTask() && !set.contains(vid) && treeChecker.containsVirtualFolder(vid, treeId, StorageType.WORKING)) {
                    deletedList.add(this.getFolder(FolderStorage.REAL_TREE_ID, vid, realFolderStorages));
                }
                vid = String.valueOf(12);
                if (userConfiguration.hasCalendar() && !set.contains(vid) && treeChecker.containsVirtualFolder(vid, treeId, StorageType.WORKING)) {
                    deletedList.add(this.getFolder(FolderStorage.REAL_TREE_ID, vid, realFolderStorages));
                }
                vid = String.valueOf(13);
                if (userConfiguration.hasContact() && !set.contains(vid) && treeChecker.containsVirtualFolder(vid, treeId, StorageType.WORKING)) {
                    deletedList.add(this.getFolder(FolderStorage.REAL_TREE_ID, vid, realFolderStorages));
                }
                vid = String.valueOf(14);
                if (userConfiguration.hasInfostore() && !set.contains(vid) && treeChecker.containsVirtualFolder(vid, treeId, StorageType.WORKING)) {
                    deletedList.add(this.getFolder(FolderStorage.REAL_TREE_ID, vid, realFolderStorages));
                }
            }
            if (addSystemSharedFolder) {
                String sharedId = String.valueOf(3);
                if (treeChecker.containsVirtualFolder(sharedId, treeId, StorageType.WORKING)) {
                    updatedList.add(this.getFolder(FolderStorage.REAL_TREE_ID, sharedId, realFolderStorages));
                }
                if (!virtualSharedIDs.isEmpty()) {
                    for (String virtualSharedID : virtualSharedIDs) {
                        updatedList.add(this.getFolder(FolderStorage.REAL_TREE_ID, virtualSharedID, realFolderStorages));
                    }
                }
            }
            if (!ignoreDeleted && deletedList != null) {
                ArrayList<Folder> deletedFolders = new ArrayList<Folder>();
                for (FolderStorage folderStorage : realFolderStorages) {
                    String[] deletedFolderIDs;
                    for (String folderId : deletedFolderIDs = folderStorage.getDeletedFolderIDs(treeId, since, this.storageParameters)) {
                        if (!treeChecker.containsVirtualFolder(folderId, treeId, StorageType.BACKUP)) continue;
                        deletedFolders.add(folderStorage.getFolder(FolderStorage.REAL_TREE_ID, folderId, StorageType.BACKUP, this.storageParameters));
                    }
                }
                deletedList.addAll(deletedFolders);
            }
            UserizedFolder[] modified = new UserizedFolder[updatedList.size()];
            for (int i = 0; i < modified.length; ++i) {
                Folder folder = (Folder)updatedList.get(i);
                modified[i] = this.getUserizedFolder(folder, this.getEffectivePermission(folder), treeId, true, true, this.storageParameters, realFolderStorages);
            }
            if (deletedList == null) {
                deleted = new UserizedFolder[]{};
            } else {
                deleted = new UserizedFolder[deletedList.size()];
                for (int i = 0; i < deleted.length; ++i) {
                    Folder folder = (Folder)deletedList.get(i);
                    deleted[i] = this.getUserizedFolder(folder, this.getEffectivePermission(folder), treeId, true, true, this.storageParameters, realFolderStorages);
                }
            }
            for (FolderStorage folderStorage : openedStorages) {
                folderStorage.commitTransaction(this.storageParameters);
            }
            if (DEBUG_ENABLED) {
                long duration = System.currentTimeMillis() - start;
                LOG.debug((Object)("Updates.doUpdates() took " + duration + "msec."));
            }
            return new UserizedFolder[][]{modified, deleted};
        }
        catch (OXException e) {
            for (FolderStorage folderStorage : openedStorages) {
                folderStorage.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            for (FolderStorage folderStorage : openedStorages) {
                folderStorage.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private Permission getEffectivePermission(Folder folder) throws OXException {
        if (null == this.getSession()) {
            return CalculatePermission.calculate(folder, this.getUser(), this.getContext(), this.getAllowedContentTypes());
        }
        return CalculatePermission.calculate(folder, this.getSession(), this.getAllowedContentTypes());
    }

    private Folder getFolder(String treeId, String folderId, Collection<FolderStorage> storages) throws OXException {
        for (FolderStorage storage : storages) {
            if (!storage.getFolderType().servesFolderId(folderId)) continue;
            return storage.getFolder(treeId, folderId, this.storageParameters);
        }
        throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
    }

    private Set<String> getPublicSubfolderIDs(String treeId, Collection<FolderStorage> storages) throws OXException {
        String folderId = String.valueOf(2);
        for (FolderStorage storage : storages) {
            if (!storage.getFolderType().servesFolderId(folderId)) continue;
            SortableId[] tmp = storage.getSubfolders(treeId, folderId, this.storageParameters);
            HashSet<String> set = new HashSet<String>(tmp.length);
            for (SortableId id : tmp) {
                set.add(id.getId());
            }
            return set;
        }
        throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
    }

    private static boolean isShared(Folder f, int userId) {
        Type type = f.getType();
        return SharedType.getInstance().equals(type) || PrivateType.getInstance().equals(type) && f.getCreatedBy() != userId;
    }

    private static boolean isPublic(Folder f) {
        return PublicType.getInstance().equals(f.getType());
    }

    private static final class TreeCheckerImpl
    implements TreeChecker {
        private final FolderStorage treeStorage;
        private final StorageParameters storageParameters;

        public TreeCheckerImpl(FolderStorage treeStorage, StorageParameters storageParameters) {
            this.treeStorage = treeStorage;
            this.storageParameters = storageParameters;
        }

        @Override
        public boolean containsVirtualFolder(String folderId, String treeId, StorageType storageType) throws OXException {
            return this.treeStorage.containsFolder(treeId, folderId, storageType, this.storageParameters);
        }
    }

    private static interface TreeChecker {
        public boolean containsVirtualFolder(String var1, String var2, StorageType var3) throws OXException;
    }
}

