/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.folderstorage.internal.performers.ListPerformer;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class SubscribePerformer
extends AbstractPerformer {
    private static final Set<String> SYSTEM_FOLDERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(FolderStorage.ROOT_ID, FolderStorage.PRIVATE_ID, FolderStorage.PUBLIC_ID, FolderStorage.SHARED_ID)));
    private static final Set<String> VIRTUAL_IDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Integer.toString(11), Integer.toString(12), Integer.toString(13), Integer.toString(14))));
    private static final String PREPARED_FULLNAME_DEFAULT = MailFolderUtility.prepareFullname(0, "default");

    public SubscribePerformer(ServerSession session) {
        super(session);
    }

    public SubscribePerformer(User user, Context context) {
        super(user, context);
    }

    public SubscribePerformer(ServerSession session, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(session, folderStorageDiscoverer);
    }

    public SubscribePerformer(User user, Context context, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, folderStorageDiscoverer);
    }

    private static boolean isSystemFolder(String folderId) {
        if (null == folderId) {
            return false;
        }
        if (SYSTEM_FOLDERS.contains(folderId)) {
            return true;
        }
        if (folderId.startsWith("u:")) {
            return true;
        }
        if (VIRTUAL_IDS.contains(folderId)) {
            return true;
        }
        return PREPARED_FULLNAME_DEFAULT.equals(folderId);
    }

    public void doSubscribe(String sourceTreeId, String folderId, String targetTreeId, String optTargetParentId) throws OXException {
        if (KNOWN_TREES.contains(targetTreeId)) {
            throw FolderExceptionErrorMessage.NO_REAL_SUBSCRIBE.create(targetTreeId);
        }
        FolderStorage sourceStorage = this.folderStorageDiscoverer.getFolderStorage(sourceTreeId, folderId);
        if (null == sourceStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(sourceTreeId, folderId);
        }
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
        if (sourceStorage.startTransaction(this.storageParameters, false)) {
            openedStorages.add(sourceStorage);
        }
        try {
            Folder sourceFolder = sourceStorage.getFolder(sourceTreeId, folderId, this.storageParameters);
            if (!CalculatePermission.calculate(sourceFolder, this, (List<ContentType>)ALL_ALLOWED).isVisible()) {
                throw FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.create(this.getFolderInfo4Error(sourceFolder), this.getUserInfo4Error(), this.getContextInfo4Error());
            }
            String targetParentId = optTargetParentId == null ? sourceFolder.getParentID() : optTargetParentId;
            FolderStorage targetStorage = this.getOpenedStorage(targetParentId, targetTreeId, this.storageParameters, openedStorages);
            if (targetStorage.containsFolder(targetTreeId, targetParentId, this.storageParameters)) {
                this.checkForSimilarNamed(sourceFolder, targetTreeId, targetParentId, openedStorages);
            }
            LinkedList<Folder> folders2 = new LinkedList<Folder>();
            Folder virtualFolder = (Folder)sourceFolder.clone();
            virtualFolder.setParentID(targetParentId);
            virtualFolder.setTreeID(targetTreeId);
            virtualFolder.setSubfolderIDs(null);
            folders2.add(virtualFolder);
            while (!SubscribePerformer.isSystemFolder(virtualFolder.getParentID()) && !targetStorage.containsFolder(targetTreeId, virtualFolder.getParentID(), this.storageParameters)) {
                sourceFolder = sourceStorage.getFolder(sourceTreeId, virtualFolder.getParentID(), this.storageParameters);
                Permission parentPermission = CalculatePermission.calculate(sourceFolder, this, (List<ContentType>)ALL_ALLOWED);
                if (parentPermission.isVisible()) {
                    virtualFolder = (Folder)sourceFolder.clone();
                    String parentId = sourceFolder.getParentID();
                    virtualFolder.setParentID(SubscribePerformer.isSystemFolder(parentId) ? FolderStorage.ROOT_ID : parentId);
                    virtualFolder.setTreeID(targetTreeId);
                    virtualFolder.setSubfolderIDs(null);
                    folders2.addFirst(virtualFolder);
                    continue;
                }
                virtualFolder.setParentID(FolderStorage.ROOT_ID);
            }
            for (Folder folder : folders2) {
                targetStorage.createFolder(folder, this.storageParameters);
            }
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(this.storageParameters);
            }
            Set<OXException> warnings = this.storageParameters.getWarnings();
            if (null != warnings) {
                for (OXException warning : warnings) {
                    this.addWarning(warning);
                }
            }
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private void checkForSimilarNamed(Folder sourceFolder, String targetTreeId, String targetParentId, List<FolderStorage> openedStorages) throws OXException {
        UserizedFolder[] subfolders = (this.session == null ? new ListPerformer(this.user, this.context, null) : new ListPerformer(this.session, null)).doList(targetTreeId, targetParentId, true, openedStorages, false);
        String sourceId = sourceFolder.getID();
        String sourceName = sourceFolder.getName();
        for (UserizedFolder userizedFolder : subfolders) {
            if (userizedFolder.getID().equals(sourceId) || !userizedFolder.getName().equals(sourceName)) continue;
            throw FolderExceptionErrorMessage.EQUAL_NAME.create(sourceName, targetParentId, targetTreeId);
        }
    }
}

