/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.internal.EffectivePermission;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;

public final class CalculatePermission {
    private static final int[] mapping = new int[]{0, 2, 4, -1, 8};
    private static final int MAX_PERMISSION = 64;

    private CalculatePermission() {
    }

    public static void calculateUserPermissions(Folder folder, Context context) {
        Permission[] staticPermissions = folder.getPermissions();
        if (null == staticPermissions || 0 == staticPermissions.length) {
            return;
        }
        UserPermissionBitsStorage userConfStorage = UserPermissionBitsStorage.getInstance();
        String id = folder.getID();
        Type type = folder.getType();
        ContentType contentType = folder.getContentType();
        Permission[] userizedPermissions = new Permission[staticPermissions.length];
        TIntIntHashMap toLoad = new TIntIntHashMap(staticPermissions.length);
        for (int index = 0; index < staticPermissions.length; ++index) {
            Permission staticPermission = staticPermissions[index];
            if (0 != staticPermission.getSystem()) continue;
            if (staticPermission.isGroup()) {
                userizedPermissions[index] = staticPermission;
                continue;
            }
            toLoad.put(staticPermission.getEntity(), index);
        }
        if (!toLoad.isEmpty()) {
            int[] userIds = toLoad.keys();
            try {
                UserPermissionBits[] configurations = userConfStorage.getUserPermissionBits(context, UserStorage.getInstance().getUser(context, userIds));
                for (int i = 0; i < configurations.length; ++i) {
                    int userId = userIds[i];
                    if (!toLoad.containsKey(userId)) continue;
                    int index = toLoad.get(userId);
                    UserPermissionBits userConfig = configurations[i];
                    if (null == userConfig) {
                        userConfig = userConfStorage.getUserPermissionBits(userId, context);
                    }
                    userizedPermissions[index] = new EffectivePermission(staticPermissions[index], id, type, contentType, userConfig, Collections.<ContentType>emptyList()).setEntityInfo(userId, context);
                }
            }
            catch (OXException e) {
                Log logger = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CalculatePermission.class));
                logger.warn((Object)"User configuration could not be loaded. Ignoring user permissions.", (Throwable)e);
            }
        }
        ArrayList<Permission> tmp = new ArrayList<Permission>(userizedPermissions.length);
        for (int i = 0; i < userizedPermissions.length; ++i) {
            Permission p = userizedPermissions[i];
            if (null == p) continue;
            tmp.add(p);
        }
        folder.setPermissions(tmp.toArray(new Permission[tmp.size()]));
    }

    public static Permission calculate(Folder folder, AbstractPerformer performer, List<ContentType> allowedContentTypes) throws OXException {
        ServerSession session = performer.getSession();
        if (null == session) {
            return CalculatePermission.calculate(folder, performer.getUser(), performer.getContext(), allowedContentTypes);
        }
        return CalculatePermission.calculate(folder, session, allowedContentTypes);
    }

    public static Permission calculate(Folder folder, User user, Context context, List<ContentType> allowedContentTypes) throws OXException {
        UserPermissionBits userConfiguration = UserPermissionBitsStorage.getInstance().getUserPermissionBits(user.getId(), context);
        int bits = -1;
        Permission underlyingPermission = CalculatePermission.getMaxPermission(folder.getPermissions(), userConfiguration);
        return new EffectivePermission(underlyingPermission, folder.getID(), folder.getType(), folder.getContentType(), userConfiguration, allowedContentTypes).setEntityInfo(user.getId(), context);
    }

    public static boolean isVisible(Folder folder, User user, Context context, List<ContentType> allowedContentTypes) throws OXException {
        int createdBy;
        UserPermissionBits userConfiguration = UserPermissionBitsStorage.getInstance().getUserPermissionBits(user.getId(), context);
        Type type = folder.getType();
        ContentType contentType = folder.getContentType();
        int bits = -1;
        if (PrivateType.getInstance().equals(type) && ((createdBy = folder.getCreatedBy()) <= 0 || createdBy == user.getId())) {
            return CalculatePermission.hasAccess(contentType, userConfiguration, allowedContentTypes);
        }
        Permission underlyingPermission = CalculatePermission.getMaxPermission(folder.getPermissions(), userConfiguration);
        return new EffectivePermission(underlyingPermission, folder.getID(), type, contentType, userConfiguration, allowedContentTypes).isVisible();
    }

    private static boolean hasAccess(ContentType contentType, UserPermissionBits userConfig, List<ContentType> allowedContentTypes) {
        int module = contentType.getModule();
        if (!userConfig.hasModuleAccess(module)) {
            return false;
        }
        if (null == allowedContentTypes || allowedContentTypes.isEmpty()) {
            return true;
        }
        TIntHashSet set = new TIntHashSet(allowedContentTypes.size() + 2);
        for (ContentType allowedContentType : allowedContentTypes) {
            set.add(allowedContentType.getModule());
        }
        set.add(5);
        set.add(4);
        return set.isEmpty() ? true : set.contains(module);
    }

    private static final int[] parsePermissionBits(int bitsArg) {
        int bits = bitsArg;
        int[] retval = new int[5];
        for (int i = retval.length - 1; i >= 0; --i) {
            int shiftVal = i * 7;
            retval[i] = bits >> shiftVal;
            bits -= retval[i] << shiftVal;
            retval[i] = retval[i] == 64 ? 128 : (i < retval.length - 1 ? mapping[retval[i]] : retval[i]);
        }
        return retval;
    }

    public static Permission calculate(Folder folder, ServerSession session, List<ContentType> allowedContentTypes) {
        UserPermissionBits userConfiguration = session.getUserPermissionBits();
        int bits = -1;
        Permission underlyingPermission = CalculatePermission.getMaxPermission(folder.getPermissions(), userConfiguration);
        return new EffectivePermission(underlyingPermission, folder.getID(), folder.getType(), folder.getContentType(), userConfiguration, allowedContentTypes);
    }

    private static Permission getMaxPermission(Permission[] permissions, UserPermissionBits userConfig) {
        DummyPermission p = new DummyPermission();
        p.setNoPermissions();
        p.setEntity(userConfig.getUserId());
        int[] groups = userConfig.getGroups();
        int[] idArr = new int[groups.length + 1];
        idArr[0] = userConfig.getUserId();
        System.arraycopy(groups, 0, idArr, 1, groups.length);
        Arrays.sort(idArr);
        int fp = 0;
        int rp = 0;
        int wp = 0;
        int dp = 0;
        boolean admin = false;
        for (Permission cur : permissions) {
            if (Arrays.binarySearch(idArr, cur.getEntity()) < 0) continue;
            int tmp = cur.getFolderPermission();
            if (tmp > fp) {
                fp = tmp;
            }
            if ((tmp = cur.getReadPermission()) > rp) {
                rp = tmp;
            }
            if ((tmp = cur.getWritePermission()) > wp) {
                wp = tmp;
            }
            if ((tmp = cur.getDeletePermission()) > dp) {
                dp = tmp;
            }
            admin |= cur.isAdmin();
        }
        p.setAllPermissions(fp, rp, wp, dp);
        p.setAdmin(admin);
        return p;
    }

    public static final class DummyPermission
    implements Permission {
        private int system;
        private int deletePermission;
        private int folderPermission;
        private int readPermission;
        private int writePermission;
        private boolean admin;
        private int entity;
        private boolean group;

        @Override
        public boolean isVisible() {
            return this.isAdmin() || this.getFolderPermission() > 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.admin ? 1231 : 1237);
            result = 31 * result + this.deletePermission;
            result = 31 * result + this.entity;
            result = 31 * result + this.folderPermission;
            result = 31 * result + (this.group ? 1231 : 1237);
            result = 31 * result + this.readPermission;
            result = 31 * result + this.system;
            result = 31 * result + this.writePermission;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Permission)) {
                return false;
            }
            Permission other = (Permission)obj;
            if (this.admin != other.isAdmin()) {
                return false;
            }
            if (this.deletePermission != other.getDeletePermission()) {
                return false;
            }
            if (this.entity != other.getEntity()) {
                return false;
            }
            if (this.folderPermission != other.getFolderPermission()) {
                return false;
            }
            if (this.group != other.isGroup()) {
                return false;
            }
            if (this.readPermission != other.getReadPermission()) {
                return false;
            }
            if (this.system != other.getSystem()) {
                return false;
            }
            return this.writePermission == other.getWritePermission();
        }

        @Override
        public int getDeletePermission() {
            return this.deletePermission;
        }

        @Override
        public int getEntity() {
            return this.entity;
        }

        @Override
        public int getFolderPermission() {
            return this.folderPermission;
        }

        @Override
        public int getReadPermission() {
            return this.readPermission;
        }

        @Override
        public int getSystem() {
            return this.system;
        }

        @Override
        public int getWritePermission() {
            return this.writePermission;
        }

        @Override
        public boolean isAdmin() {
            return this.admin;
        }

        @Override
        public boolean isGroup() {
            return this.group;
        }

        @Override
        public void setAdmin(boolean admin) {
            this.admin = admin;
        }

        @Override
        public void setAllPermissions(int folderPermission, int readPermission, int writePermission, int deletePermission) {
            this.folderPermission = folderPermission;
            this.readPermission = readPermission;
            this.deletePermission = deletePermission;
            this.writePermission = writePermission;
        }

        @Override
        public void setDeletePermission(int permission) {
            this.deletePermission = permission;
        }

        @Override
        public void setEntity(int entity) {
            this.entity = entity;
        }

        @Override
        public void setFolderPermission(int permission) {
            this.folderPermission = permission;
        }

        @Override
        public void setGroup(boolean group) {
            this.group = group;
        }

        @Override
        public void setMaxPermissions() {
            this.folderPermission = 128;
            this.readPermission = 128;
            this.deletePermission = 128;
            this.writePermission = 128;
            this.admin = true;
        }

        @Override
        public void setNoPermissions() {
            this.folderPermission = 0;
            this.readPermission = 0;
            this.deletePermission = 0;
            this.writePermission = 0;
            this.admin = false;
        }

        @Override
        public void setReadPermission(int permission) {
            this.readPermission = permission;
        }

        @Override
        public void setSystem(int system) {
            this.system = system;
        }

        @Override
        public void setWritePermission(int permission) {
            this.writePermission = permission;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.getMessage());
            }
        }
    }
}

