/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database.getfolder;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.LocalizedDatabaseFolder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public final class SystemPrivateFolder {
    private SystemPrivateFolder() {
    }

    public static DatabaseFolder getSystemPrivateFolder(FolderObject fo) {
        LocalizedDatabaseFolder retval = new LocalizedDatabaseFolder(fo);
        retval.setName("Private folders");
        retval.setSubfolderIDs(null);
        retval.setSubscribedSubfolders(true);
        return retval;
    }

    public static int[] getSystemPrivateFolderSubfoldersAsInt(User user, UserPermissionBits userConfiguration, Context ctx, Connection con) throws OXException {
        try {
            List<FolderObject> list = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleSubfoldersIterator(1, user.getId(), user.getGroups(), ctx, userConfiguration, null, con)).asList();
            StringHelper stringHelper = null;
            for (FolderObject folderObject : list) {
                if (!folderObject.isDefaultFolder()) continue;
                int module = folderObject.getModule();
                if (2 == module) {
                    if (null == stringHelper) {
                        stringHelper = StringHelper.valueOf(user.getLocale());
                    }
                    folderObject.setFolderName(stringHelper.getString("Calendar"));
                    continue;
                }
                if (3 == module) {
                    if (null == stringHelper) {
                        stringHelper = StringHelper.valueOf(user.getLocale());
                    }
                    folderObject.setFolderName(stringHelper.getString("Contacts"));
                    continue;
                }
                if (1 != module) continue;
                if (null == stringHelper) {
                    stringHelper = StringHelper.valueOf(user.getLocale());
                }
                folderObject.setFolderName(stringHelper.getString("Tasks"));
            }
            int[] ret = new int[list.size()];
            int i = 0;
            for (FolderObject folderObject : list) {
                ret[i++] = folderObject.getObjectID();
            }
            return ret;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
    }

    public static List<String[]> getSystemPrivateFolderSubfolders(User user, UserPermissionBits userConfiguration, Context ctx, Connection con) throws OXException {
        try {
            List<FolderObject> list = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleSubfoldersIterator(1, user.getId(), user.getGroups(), ctx, userConfiguration, null, con)).asList();
            StringHelper stringHelper = null;
            for (FolderObject folderObject : list) {
                if (!folderObject.isDefaultFolder()) continue;
                int module = folderObject.getModule();
                if (2 == module) {
                    if (null == stringHelper) {
                        stringHelper = StringHelper.valueOf(user.getLocale());
                    }
                    folderObject.setFolderName(stringHelper.getString("Calendar"));
                    continue;
                }
                if (3 == module) {
                    if (null == stringHelper) {
                        stringHelper = StringHelper.valueOf(user.getLocale());
                    }
                    folderObject.setFolderName(stringHelper.getString("Contacts"));
                    continue;
                }
                if (1 != module) continue;
                if (null == stringHelper) {
                    stringHelper = StringHelper.valueOf(user.getLocale());
                }
                folderObject.setFolderName(stringHelper.getString("Tasks"));
            }
            ArrayList<String[]> ret = new ArrayList<String[]>(list.size());
            for (FolderObject folderObject : list) {
                ret.add(new String[]{String.valueOf(folderObject.getObjectID()), folderObject.getFolderName()});
            }
            return ret;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
    }

    private static final class NameComparator
    implements Comparator<FolderObject> {
        private final Collator collator;

        public NameComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(FolderObject folder1, FolderObject folder2) {
            return this.collator.compare(folder1.getFolderName(), folder2.getFolderName());
        }
    }
}

