/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SystemContentType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.database.DatabasePermission;
import com.openexchange.folderstorage.database.contentType.CalendarContentType;
import com.openexchange.folderstorage.database.contentType.ContactContentType;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.database.contentType.TaskContentType;
import com.openexchange.folderstorage.database.contentType.UnboundContentType;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.folderstorage.type.PublicType;
import com.openexchange.folderstorage.type.SystemType;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Date;
import org.apache.commons.logging.Log;

public class DatabaseFolder
extends AbstractFolder {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(DatabaseFolder.class);
    private static final long serialVersionUID = -4035221612481906228L;
    private static final TIntSet COUNTABLE_MODULES = new TIntHashSet(new int[]{2, 3, 1, 8});
    private boolean cacheable;
    private final int objectId;
    private final FolderObject folderObject;
    protected boolean global;

    public DatabaseFolder(FolderObject folderObject) {
        this(folderObject, true);
    }

    public DatabaseFolder(FolderObject folderObject, boolean cacheable) {
        this.cacheable = cacheable;
        this.global = true;
        this.folderObject = folderObject;
        this.objectId = folderObject.getObjectID();
        this.id = String.valueOf(this.objectId);
        this.name = folderObject.getFolderName();
        this.parent = String.valueOf(folderObject.getParentFolderID());
        this.type = DatabaseFolder.getType(folderObject.getType());
        this.contentType = DatabaseFolder.getContentType(folderObject.getModule());
        OCLPermission[] oclPermissions = folderObject.getPermissionsAsArray();
        this.permissions = new Permission[oclPermissions.length];
        for (int i = 0; i < oclPermissions.length; ++i) {
            this.permissions[i] = new DatabasePermission(oclPermissions[i]);
        }
        this.createdBy = folderObject.getCreatedBy();
        this.modifiedBy = folderObject.getModifiedBy();
        Date d = folderObject.getCreationDate();
        this.creationDate = null == d ? null : new Date(d.getTime());
        d = folderObject.getLastModified();
        this.lastModified = null == d ? null : new Date(d.getTime());
        this.subscribed = true;
        this.deefault = folderObject.isDefaultFolder();
        this.defaultType = this.deefault ? this.contentType.getModule() : 0;
        this.meta = folderObject.getMeta();
    }

    @Override
    public Object clone() {
        DatabaseFolder clone = (DatabaseFolder)super.clone();
        clone.cacheable = this.cacheable;
        clone.global = this.global;
        return clone;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    private static Type getType(int type) {
        switch (type) {
            case 5: {
                return SystemType.getInstance();
            }
            case 1: {
                return PrivateType.getInstance();
            }
            case 2: {
                return PublicType.getInstance();
            }
        }
        return null;
    }

    private static ContentType getContentType(int module) {
        switch (module) {
            case 5: {
                return SystemContentType.getInstance();
            }
            case 2: {
                return CalendarContentType.getInstance();
            }
            case 3: {
                return ContactContentType.getInstance();
            }
            case 1: {
                return TaskContentType.getInstance();
            }
            case 8: {
                return InfostoreContentType.getInstance();
            }
            case 4: {
                return UnboundContentType.getInstance();
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Unknown database folder content type: " + module));
        }
        return SystemContentType.getInstance();
    }

    @Override
    public boolean isGlobalID() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    @Override
    public int getTotal() {
        int module = this.contentType.getModule();
        if (COUNTABLE_MODULES.contains(module)) {
            return this.itemCount();
        }
        return super.getTotal();
    }

    private int itemCount() {
        Props props = LogProperties.optLogProperties();
        Session session = (Session)(null == props ? null : props.get(LogProperties.Name.SESSION_SESSION));
        if (null != session) {
            try {
                FolderObject folderObject = this.folderObject;
                if (session instanceof ServerSession) {
                    ServerSession serverSession = (ServerSession)session;
                    EffectivePermission permission = folderObject.getEffectiveUserPermission(session.getUserId(), serverSession.getUserConfiguration());
                    if (permission.getFolderPermission() <= 0 || permission.getReadPermission() <= 0) {
                        return 0;
                    }
                    Context ctx = serverSession.getContext();
                    int count = (int)new OXFolderAccess(ctx).getItemCount(folderObject, session, ctx);
                    return count < 0 ? super.getTotal() : count;
                }
                Context ctx = ContextStorage.getStorageContext(session.getContextId());
                int userId = session.getUserId();
                User user = UserStorage.getStorageUser(userId, ctx);
                UserConfiguration userConfiguration = UserConfigurationStorage.getInstance().getUserConfiguration(userId, user.getGroups(), ctx);
                EffectivePermission permission = folderObject.getEffectiveUserPermission(userId, userConfiguration);
                if (permission.getFolderPermission() <= 0 || permission.getReadPermission() <= 0) {
                    return 0;
                }
                int count = (int)new OXFolderAccess(ctx).getItemCount(folderObject, session, ctx);
                return count < 0 ? super.getTotal() : count;
            }
            catch (OXException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return super.getTotal();
    }
}

