/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.event.impl;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.event.impl.EventConfigImpl;
import com.openexchange.event.impl.EventQueue;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentCleaner;
import com.openexchange.groupware.impl.FolderLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.EntityLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.LockCleaner;
import com.openexchange.groupware.infostore.webdav.PropertyCleaner;
import com.openexchange.groupware.infostore.webdav.PropertyStoreImpl;
import com.openexchange.groupware.links.LinksEventHandler;
import com.openexchange.groupware.notify.ParticipantNotify;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;

public class EventInit
implements Initialization {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(EventInit.class));
    private boolean started;

    public void start() throws OXException {
        if (this.started) {
            return;
        }
        this.started = true;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Parse Event properties");
        }
        EventConfigImpl eventConfig = new EventConfigImpl(ServerServiceRegistry.getInstance().getService(ConfigurationService.class).getFileByName("event.properties"));
        EventQueue.init(eventConfig);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Adding Notification Listener");
        }
        ParticipantNotify notify = new ParticipantNotify();
        EventQueue.addModernListener(notify);
        EventQueue.addModernListener(notify);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Adding LinkEventHandler");
        }
        LinksEventHandler linkHandler = new LinksEventHandler();
        EventQueue.addAppointmentEvent(linkHandler);
        EventQueue.addContactEvent(linkHandler);
        EventQueue.addTaskEvent(linkHandler);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Adding AttachmentCleaner");
        }
        AttachmentCleaner attCleaner = new AttachmentCleaner();
        EventQueue.addAppointmentEvent(attCleaner);
        EventQueue.addContactEvent(attCleaner);
        EventQueue.addTaskEvent(attCleaner);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Adding PropertiesCleaner");
        }
        PropertyCleaner propertyCleaner = new PropertyCleaner(new PropertyStoreImpl(new DBPoolProvider(), "oxfolder_property"), new PropertyStoreImpl(new DBPoolProvider(), "infostore_property"));
        EventQueue.addFolderEvent(propertyCleaner);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Adding LockCleaner");
        }
        LockCleaner lockCleaner = new LockCleaner(new FolderLockManagerImpl(new DBPoolProvider()), new EntityLockManagerImpl(new DBPoolProvider(), "infostore_lock"));
        EventQueue.addFolderEvent(lockCleaner);
    }

    public void stop() throws OXException {
        EventQueue.stop();
        EventQueue.clearAllListeners();
    }
}

