/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.contact.ContactFieldOperand;
import com.openexchange.contact.SortOptions;
import com.openexchange.contact.SortOrder;
import com.openexchange.contact.internal.ContactServiceLookup;
import com.openexchange.contact.internal.SearchTermAnalyzer;
import com.openexchange.contact.internal.mapping.ContactMapper;
import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.contact.storage.registry.ContactStorageRegistry;
import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.folder.FolderService;
import com.openexchange.groupware.contact.ContactConfig;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.java.Strings;
import com.openexchange.l10n.SuperCollator;
import com.openexchange.log.LogFactory;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.SingleSearchTerm;
import com.openexchange.search.internal.operands.ConstantOperand;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.userconf.UserConfigurationService;
import com.openexchange.userconf.UserPermissionService;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public final class Tools {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Tools.class));

    public static Comparator<Contact> getComparator(final SortOptions sortOptions) {
        if (null == sortOptions || SortOptions.EMPTY.equals(sortOptions) || null == sortOptions.getOrder() || 0 == sortOptions.getOrder().length) {
            return new Comparator<Contact>(){

                @Override
                public int compare(Contact o1, Contact o2) {
                    return 0;
                }
            };
        }
        final Collator collationComparator = null == sortOptions.getCollation() ? null : Collator.getInstance(SuperCollator.get((String)sortOptions.getCollation()).getJavaLocale());
        return new Comparator<Contact>(){

            @Override
            public int compare(Contact o1, Contact o2) {
                for (SortOrder order : sortOptions.getOrder()) {
                    int comparison = 0;
                    try {
                        comparison = ContactMapper.getInstance().get(order.getBy()).compare(o1, o2, collationComparator);
                    }
                    catch (OXException e) {
                        LOG.error((Object)"error comparing objects", (Throwable)e);
                    }
                    if (false == comparison) continue;
                    return Order.DESCENDING.equals((Object)order.getOrder()) ? -1 * comparison : comparison;
                }
                return 0;
            }
        };
    }

    public static ContactStorage getStorage(Session session, String folderID) throws OXException {
        ContactStorage storage = ContactServiceLookup.getService(ContactStorageRegistry.class, true).getStorage(session, folderID);
        if (null == storage) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{"'Contact storage for folder " + folderID + "'"});
        }
        return storage;
    }

    public static List<ContactStorage> getStorages(Session session) throws OXException {
        return ContactServiceLookup.getService(ContactStorageRegistry.class, true).getStorages(session);
    }

    public static Map<ContactStorage, List<String>> getStorages(Session session, Collection<String> folderIDs) throws OXException {
        HashMap<ContactStorage, List<String>> storages = new HashMap<ContactStorage, List<String>>();
        for (String folderID : folderIDs) {
            ContactStorage storage = Tools.getStorage(session, folderID);
            if (!storages.containsKey(storage)) {
                storages.put(storage, new ArrayList());
            }
            ((List)storages.get(storage)).add(folderID);
        }
        return storages;
    }

    public static Context getContext(int contextID) throws OXException {
        Context context = ContactServiceLookup.getService(ContextService.class, true).getContext(contextID);
        if (null == context) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{"Unable to get context '" + contextID + "'."});
        }
        return context;
    }

    public static UserConfiguration getUserConfig(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUserConfiguration();
        }
        return ContactServiceLookup.getService(UserConfigurationService.class, true).getUserConfiguration(session.getUserId(), Tools.getContext(session));
    }

    public static UserPermissionBits getUserPermissionBits(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUserPermissionBits();
        }
        return ContactServiceLookup.getService(UserPermissionService.class, true).getUserPermissionBits(session.getUserId(), Tools.getContext(session));
    }

    public static Context getContext(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getContext();
        }
        return Tools.getContext(session.getContextId());
    }

    public static FolderObject getFolder(int contextID, String folderId) throws OXException {
        FolderService folderService = ContactServiceLookup.getService(FolderService.class, true);
        return folderService.getFolderObject(Tools.parse(folderId), contextID);
    }

    public static EffectivePermission getPermission(Session session, FolderObject folder) throws OXException {
        try {
            return folder.getEffectiveUserPermission(session.getUserId(), Tools.getUserPermissionBits(session));
        }
        catch (RuntimeException e) {
            throw ContactExceptionCodes.UNEXPECTED_ERROR.create(e, new Object[0]);
        }
    }

    public static EffectivePermission getPermission(int contextID, String folderId, int userID) throws OXException {
        return ContactServiceLookup.getService(FolderService.class, true).getFolderPermission(Tools.parse(folderId), userID, contextID);
    }

    public static boolean isEmpty(String string) {
        if (null != string) {
            int length = string.length();
            for (int i = 0; i < length; ++i) {
                if (Strings.isWhitespace((char)string.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<String> extractFolderIDs(SearchTerm<?> term) {
        ArrayList folders2 = new SearchTermAnalyzer(term).getFolderIDs();
        return null != folders2 ? folders2 : new ArrayList();
    }

    public static SearchTerm<?> getFoldersTerm(List<String> folderIDs) {
        if (null == folderIDs || 0 == folderIDs.size()) {
            return null;
        }
        if (1 == folderIDs.size()) {
            return Tools.createContactFieldTerm(ContactField.FOLDER_ID, SingleSearchTerm.SingleOperation.EQUALS, folderIDs.get(0));
        }
        CompositeSearchTerm orTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.OR);
        for (String folderID : folderIDs) {
            orTerm.addSearchTerm(Tools.createContactFieldTerm(ContactField.FOLDER_ID, SingleSearchTerm.SingleOperation.EQUALS, folderID));
        }
        return orTerm;
    }

    public static <T> SingleSearchTerm createContactFieldTerm(ContactField field, SingleSearchTerm.SingleOperation operation, T constant) {
        SingleSearchTerm term = new SingleSearchTerm(operation);
        term.addOperand(new ContactFieldOperand(field));
        term.addOperand(new ConstantOperand<T>(constant));
        return term;
    }

    public static List<String> getSearchFolders(int contextID, int userID, boolean emailAutoComplete) throws OXException {
        if (emailAutoComplete && !ContactConfig.getInstance().getBoolean(ContactConfig.Property.ALL_FOLDERS_FOR_AUTOCOMPLETE).booleanValue()) {
            return Tools.getBasicFolders(contextID, userID);
        }
        return Tools.getVisibleFolders(contextID, userID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getVisibleFolders(int contextID, int userID) throws OXException {
        ArrayList<String> folderIDs = new ArrayList<String>();
        UserConfiguration userConfig = UserConfigurationStorage.getInstance().getUserConfiguration(userID, Tools.getContext(contextID));
        SearchIterator<FolderObject> searchIterator = null;
        try {
            searchIterator = OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfModule(userID, userConfig.getGroups(), userConfig.getAccessibleModules(), 3, Tools.getContext(contextID));
            while (searchIterator.hasNext()) {
                EffectivePermission permission;
                FolderObject folder = (FolderObject)searchIterator.next();
                if (3 != folder.getModule() || null == (permission = Tools.getPermission(contextID, Integer.toString(folder.getObjectID()), userID)) || !permission.canReadOwnObjects()) continue;
                folderIDs.add(Integer.toString(folder.getObjectID()));
            }
        }
        finally {
            if (null != searchIterator) {
                searchIterator.close();
            }
        }
        return folderIDs;
    }

    private static List<String> getBasicFolders(int contextID, int userID) throws OXException {
        Integer collectedContactFolderID;
        ArrayList<String> folderIDs = new ArrayList<String>();
        folderIDs.add(Integer.toString(new OXFolderAccess(Tools.getContext(contextID)).getDefaultFolder(userID, 3).getObjectID()));
        if (Tools.getPermission(contextID, Integer.toString(6), userID).canReadAllObjects()) {
            folderIDs.add(Integer.toString(6));
        }
        if (null != (collectedContactFolderID = ServerUserSetting.getInstance().getContactCollectionFolder(contextID, userID))) {
            folderIDs.add(Integer.toString(collectedContactFolderID));
        }
        return folderIDs;
    }

    public static int parse(String id) throws OXException {
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            throw ContactExceptionCodes.ID_PARSING_FAILED.create(e, id);
        }
    }

    public static List<Integer> parse(List<String> ids) throws OXException {
        ArrayList<Integer> intIDs = new ArrayList<Integer>();
        for (String id : ids) {
            intIDs.add(Tools.parse(id));
        }
        return intIDs;
    }

    public static List<String> toStringList(int[] ids) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (int id : ids) {
            stringList.add(Integer.toString(id));
        }
        return stringList;
    }

    public static void close(SearchIterator<?> searchIterator) {
        if (null != searchIterator) {
            try {
                searchIterator.close();
            }
            catch (OXException e) {
                LOG.warn((Object)"error closing iterator", (Throwable)e);
            }
        }
    }

    public static void invalidateAddressesIfNeeded(Contact contact) {
        if (!contact.containsAddressBusiness() && (contact.containsStreetBusiness() || contact.containsPostalCodeBusiness() || contact.containsCityBusiness() || contact.containsStateBusiness() || contact.containsCountryBusiness())) {
            contact.setAddressBusiness(null);
        }
        if (!contact.containsAddressHome() && (contact.containsStreetHome() || contact.containsPostalCodeHome() || contact.containsCityHome() || contact.containsStateHome() || contact.containsCountryHome())) {
            contact.setAddressHome(null);
        }
        if (!contact.containsAddressOther() && (contact.containsStreetOther() || contact.containsPostalCodeOther() || contact.containsCityOther() || contact.containsStateOther() || contact.containsCountryOther())) {
            contact.setAddressOther(null);
        }
    }

    public static void setFileAsIfNeeded(Contact contact) {
        if (contact.containsDisplayName() && (!contact.containsFileAs() || Tools.isEmpty(contact.getFileAs()))) {
            contact.setFileAs(contact.getDisplayName());
        }
    }

    public static ContactSearchObject prepareContactSearch(ContactSearchObject contactSearch, List<String> folderIDs) throws OXException {
        ContactSearchObject preparedSearchObject = new ContactSearchObject();
        preparedSearchObject.setFolders(Tools.parse(folderIDs));
        preparedSearchObject.setStartLetter(contactSearch.isStartLetter());
        preparedSearchObject.setPattern(contactSearch.getPattern());
        preparedSearchObject.setOrSearch(contactSearch.isOrSearch());
        preparedSearchObject.setEmailAutoComplete(contactSearch.isEmailAutoComplete());
        preparedSearchObject.setCatgories(contactSearch.getCatgories());
        preparedSearchObject.setCityBusiness(contactSearch.getCityBusiness());
        preparedSearchObject.setCompany(contactSearch.getCompany());
        preparedSearchObject.setDepartment(contactSearch.getDepartment());
        preparedSearchObject.setDisplayName(contactSearch.getDisplayName());
        preparedSearchObject.setEmail1(contactSearch.getEmail1());
        preparedSearchObject.setEmail2(contactSearch.getEmail2());
        preparedSearchObject.setEmail3(contactSearch.getEmail3());
        preparedSearchObject.setGivenName(contactSearch.getGivenName());
        preparedSearchObject.setStreetBusiness(contactSearch.getStreetBusiness());
        preparedSearchObject.setSurname(contactSearch.getSurname());
        preparedSearchObject.setYomiCompany(contactSearch.getYomiCompany());
        preparedSearchObject.setYomiFirstname(contactSearch.getYomiFirstName());
        preparedSearchObject.setYomiLastName(contactSearch.getYomiLastName());
        return preparedSearchObject;
    }

    public static ContactSearchObject prepareContactSearch(ContactSearchObject contactSearch) {
        if (null != contactSearch.getPattern() && 0 < contactSearch.getPattern().length()) {
            return Tools.prepareSearchContacts(contactSearch);
        }
        return Tools.prepareSearchContactsAlternative(contactSearch);
    }

    private static ContactSearchObject prepareSearchContacts(ContactSearchObject contactSearch) {
        ContactSearchObject preparedSearchObject = new ContactSearchObject();
        preparedSearchObject.setFolders(contactSearch.getFolders());
        if (contactSearch.isStartLetter()) {
            preparedSearchObject.setStartLetter(true);
            preparedSearchObject.setPattern(Tools.addWildcards(contactSearch.getPattern(), false, true));
        } else {
            preparedSearchObject.setStartLetter(false);
            preparedSearchObject.setPattern(Tools.addWildcards(contactSearch.getPattern(), true, true));
        }
        return preparedSearchObject;
    }

    private static ContactSearchObject prepareSearchContactsAlternative(ContactSearchObject contactSearch) {
        ContactSearchObject preparedSearchObject = new ContactSearchObject();
        boolean prependWildcard = false == contactSearch.isOrSearch() && false == contactSearch.isEmailAutoComplete();
        boolean appendWildcard = false == contactSearch.isExactMatch();
        preparedSearchObject.setOrSearch(contactSearch.isOrSearch());
        preparedSearchObject.setEmailAutoComplete(contactSearch.isEmailAutoComplete());
        preparedSearchObject.setFolders(contactSearch.getFolders());
        preparedSearchObject.setCatgories(Tools.addWildcards(contactSearch.getCatgories(), true, true));
        preparedSearchObject.setCityBusiness(Tools.addWildcards(contactSearch.getCityBusiness(), prependWildcard, appendWildcard));
        preparedSearchObject.setCompany(Tools.addWildcards(contactSearch.getCompany(), prependWildcard, appendWildcard));
        preparedSearchObject.setDepartment(Tools.addWildcards(contactSearch.getDepartment(), prependWildcard, appendWildcard));
        preparedSearchObject.setDisplayName(Tools.addWildcards(contactSearch.getDisplayName(), prependWildcard, appendWildcard));
        preparedSearchObject.setEmail1(Tools.addWildcards(contactSearch.getEmail1(), prependWildcard, appendWildcard));
        preparedSearchObject.setEmail2(Tools.addWildcards(contactSearch.getEmail2(), prependWildcard, appendWildcard));
        preparedSearchObject.setEmail3(Tools.addWildcards(contactSearch.getEmail3(), prependWildcard, appendWildcard));
        preparedSearchObject.setGivenName(Tools.addWildcards(contactSearch.getGivenName(), prependWildcard, appendWildcard));
        preparedSearchObject.setStreetBusiness(Tools.addWildcards(contactSearch.getStreetBusiness(), prependWildcard, appendWildcard));
        preparedSearchObject.setSurname(Tools.addWildcards(contactSearch.getSurname(), prependWildcard, appendWildcard));
        preparedSearchObject.setYomiCompany(Tools.addWildcards(contactSearch.getYomiCompany(), prependWildcard, appendWildcard));
        preparedSearchObject.setYomiFirstname(Tools.addWildcards(contactSearch.getYomiFirstName(), prependWildcard, appendWildcard));
        preparedSearchObject.setYomiLastName(Tools.addWildcards(contactSearch.getYomiLastName(), prependWildcard, appendWildcard));
        return preparedSearchObject;
    }

    private static String addWildcards(String pattern, boolean prepend, boolean append) {
        if (null != pattern && 0 < pattern.length() && !"*".equals(pattern)) {
            if (prepend && '*' != pattern.charAt(0)) {
                pattern = "*" + pattern;
            }
            if (append && '*' != pattern.charAt(pattern.length() - 1)) {
                pattern = pattern + "*";
            }
            return pattern;
        }
        return null;
    }

    private Tools() {
    }
}

