/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.concurrent;

import com.openexchange.threadpool.Task;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class CallerRunsCompletionService<V>
implements CompletionService<V> {
    private final BlockingQueue<Future<V>> completionQueue = new LinkedBlockingQueue<Future<V>>();

    @Override
    public Future<V> submit(Task<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        QueueingFuture<V> f = new QueueingFuture<V>(task, this.completionQueue);
        task.beforeExecute(Thread.currentThread());
        f.run();
        try {
            f.get();
            task.afterExecute(null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            task.afterExecute(e.getCause());
        }
        return f;
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        QueueingFuture<V> f = new QueueingFuture<V>(task, this.completionQueue);
        f.run();
        return f;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        if (task == null) {
            throw new NullPointerException();
        }
        QueueingFuture<V> f = new QueueingFuture<V>(task, result, this.completionQueue);
        f.run();
        return f;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public Future<V> poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }

    private static final class QueueingFuture<V>
    extends FutureTask<V> {
        private final BlockingQueue<Future<V>> queue;

        QueueingFuture(Callable<V> c, BlockingQueue<Future<V>> queue) {
            super(c);
            this.queue = queue;
        }

        QueueingFuture(Runnable t, V r, BlockingQueue<Future<V>> queue) {
            super(t, r);
            this.queue = queue;
        }

        @Override
        protected void done() {
            this.queue.add(this);
        }
    }
}

