/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.preview.cache.CachedPreview;
import com.openexchange.preview.cache.PreviewCache;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class RdbPreviewCacheImpl
implements PreviewCache,
EventHandler {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(RdbPreviewCacheImpl.class);

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        if ("com/openexchange/groupware/infostore/update".equals(topic)) {
            try {
                Session session = (Session)event.getProperty("session");
                int userId = session.getUserId();
                int contextId = session.getContextId();
                this.removeAlikes(event.getProperty("eTag").toString(), userId, contextId);
            }
            catch (OXException e) {
                LOG.warn((Object)"Couldn't remove cache entry.", (Throwable)e);
            }
        } else if ("com/openexchange/groupware/infostore/delete".equals(topic)) {
            try {
                Session session = (Session)event.getProperty("session");
                int userId = session.getUserId();
                int contextId = session.getContextId();
                this.removeAlikes(event.getProperty("eTag").toString(), userId, contextId);
            }
            catch (OXException e) {
                LOG.warn((Object)"Couldn't remove cache entry.", (Throwable)e);
            }
        }
    }

    public boolean save(String id, CachedPreview preview, int userId, int contextId) throws OXException {
        InputStream in = preview.getInputStream();
        if (null == in) {
            return this.save(id, preview.getBytes(), preview.getFileName(), preview.getFileType(), userId, contextId);
        }
        return this.save(id, in, preview.getFileName(), preview.getFileType(), userId, contextId);
    }

    public boolean save(String id, InputStream in, String optName, String optType, int userId, int contextId) throws OXException {
        try {
            return this.save(id, Streams.stream2bytes((InputStream)in), optName, optType, userId, contextId);
        }
        catch (IOException e) {
            throw PreviewExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(String id, byte[] bytes, String optName, String optType, int userId, int contextId) throws OXException {
        boolean bl;
        PreparedStatement stmt;
        Connection con;
        DatabaseService databaseService;
        block19: {
            boolean exists = this.exists(id, userId, contextId);
            long[] qts = this.getContextQuota(contextId);
            long total = qts[0];
            long totalPerDocument = qts[0];
            if (total > 0L || totalPerDocument > 0L) {
                String ignoree;
                String string = ignoree = exists ? id : null;
                if (!this.ensureUnexceededContextQuota(bytes.length, total, totalPerDocument, contextId, ignoree)) {
                    return false;
                }
            }
            if ((databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class)) == null) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
            }
            con = databaseService.getWritable(contextId);
            boolean committed = true;
            stmt = null;
            try {
                con.setAutoCommit(false);
                committed = false;
                long now = System.currentTimeMillis();
                int pos = 1;
                if (exists) {
                    stmt = con.prepareStatement("UPDATE preview SET size = ?, createdAt = ?, fileName = ?, fileType = ? WHERE cid = ? AND user = ? AND id = ?");
                    stmt.setLong(pos++, bytes.length);
                    stmt.setLong(pos++, now);
                    if (null == optName) {
                        stmt.setNull(pos++, 12);
                    } else {
                        stmt.setString(pos++, optName);
                    }
                    if (null == optType) {
                        stmt.setNull(pos++, 12);
                    } else {
                        stmt.setString(pos++, optType);
                    }
                    stmt.setLong(pos++, contextId);
                    stmt.setLong(pos++, userId);
                    stmt.setString(pos++, id);
                    stmt.executeUpdate();
                    Databases.closeSQLStuff((Statement)stmt);
                    pos = 1;
                    stmt = con.prepareStatement("UPDATE previewData SET data = ? WHERE cid = ? AND user = ? AND id = ?");
                    stmt.setBinaryStream(pos++, Streams.newByteArrayInputStream((byte[])bytes));
                    stmt.setLong(pos++, contextId);
                    stmt.setLong(pos++, userId);
                    stmt.setString(pos++, id);
                    stmt.executeUpdate();
                } else {
                    stmt = con.prepareStatement("INSERT INTO preview (cid, user, id, size, createdAt, fileName, fileType) VALUES (?, ?, ?, ?, ?, ?, ?)");
                    stmt.setLong(pos++, contextId);
                    stmt.setLong(pos++, userId);
                    stmt.setString(pos++, id);
                    stmt.setLong(pos++, bytes.length);
                    stmt.setLong(pos++, now);
                    stmt.setBinaryStream(pos++, Streams.newByteArrayInputStream((byte[])bytes));
                    if (null == optName) {
                        stmt.setNull(pos++, 12);
                    } else {
                        stmt.setString(pos++, optName);
                    }
                    if (null == optType) {
                        stmt.setNull(pos++, 12);
                    } else {
                        stmt.setString(pos++, optType);
                    }
                    stmt.executeUpdate();
                    Databases.closeSQLStuff((Statement)stmt);
                    pos = 1;
                    stmt = con.prepareStatement("INSERT INTO previewData (cid, user, id, data) VALUES (?, ?, ?, ?)");
                    stmt.setLong(pos++, contextId);
                    stmt.setLong(pos++, userId);
                    stmt.setString(pos++, id);
                    stmt.setBinaryStream(pos++, Streams.newByteArrayInputStream((byte[])bytes));
                    stmt.executeUpdate();
                }
                con.commit();
                committed = true;
                bl = true;
                if (committed) break block19;
            }
            catch (DataTruncation e) {
                try {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                    catch (SQLException e2) {
                        throw PreviewExceptionCodes.ERROR.create((Throwable)e2, new Object[]{e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    if (!committed) {
                        Databases.rollback((Connection)con);
                    }
                    Databases.closeSQLStuff(stmt);
                    Databases.autocommit((Connection)con);
                    databaseService.backWritable(contextId, con);
                    throw throwable;
                }
            }
            Databases.rollback((Connection)con);
        }
        Databases.closeSQLStuff((Statement)stmt);
        Databases.autocommit((Connection)con);
        databaseService.backWritable(contextId, con);
        return bl;
    }

    public long[] getContextQuota(int contextId) {
        long quota = -1L;
        long quotaPerDocument = -1L;
        ConfigurationService confService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null != confService) {
            String property = confService.getProperty("com.openexchange.preview.cache.quota", "-1").trim();
            try {
                quota = Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                quota = -1L;
            }
            property = confService.getProperty("com.openexchange.preview.cache.quotaPerDocument", "-1").trim();
            try {
                quotaPerDocument = Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                quotaPerDocument = -1L;
            }
        }
        return new long[]{quota, quotaPerDocument};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ensureUnexceededContextQuota(long desiredSize, long total, long totalPerDocument, int contextId, String ignoree) throws OXException {
        if (total <= 0L) {
            return totalPerDocument <= 0L || desiredSize <= totalPerDocument;
        }
        if (desiredSize > total || desiredSize > totalPerDocument) {
            return false;
        }
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        Connection con = dbService.getReadOnly(contextId);
        boolean readOnly = true;
        try {
            long usedContextQuota = this.getUsedContextQuota(contextId, ignoree, con);
            if (usedContextQuota <= 0L && desiredSize > total) {
                boolean bl = false;
                return bl;
            }
            while (usedContextQuota + desiredSize > total) {
                if (readOnly) {
                    dbService.backReadOnly(contextId, con);
                    con = dbService.getWritable(contextId);
                    readOnly = false;
                }
                this.dropOldestEntry(contextId, con);
                usedContextQuota = this.getUsedContextQuota(contextId, ignoree, con);
                if (usedContextQuota > 0L || desiredSize <= total) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (readOnly) {
                dbService.backReadOnly(contextId, con);
            } else {
                dbService.backWritable(contextId, con);
            }
        }
    }

    private void dropOldestEntry(int contextId, Connection con) throws OXException {
        long oldestStamp;
        ResultSet rs;
        PreparedStatement stmt;
        block10: {
            block9: {
                stmt = null;
                rs = null;
                stmt = con.prepareStatement("SELECT MIN(createdAt) FROM preview WHERE cid = ?");
                stmt.setLong(1, contextId);
                rs = stmt.executeQuery();
                if (rs.next()) break block9;
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                return;
            }
            oldestStamp = rs.getLong(1);
            if (!rs.wasNull()) break block10;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return;
        }
        try {
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = con.prepareStatement("SELECT id FROM preview WHERE cid = ? AND createdAt <= ?");
            stmt.setLong(1, contextId);
            stmt.setLong(2, oldestStamp);
            rs = stmt.executeQuery();
            HashSet<String> ids = new HashSet<String>(4);
            while (rs.next()) {
                ids.add(rs.getString(1));
            }
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = con.prepareStatement("DELETE FROM preview WHERE cid = ? AND createdAt <= ?");
            stmt.setLong(1, contextId);
            stmt.setLong(2, oldestStamp);
            stmt.executeUpdate();
            Databases.closeSQLStuff((Statement)stmt);
            stmt = null;
            if (!ids.isEmpty()) {
                stmt = con.prepareStatement("DELETE FROM previewData WHERE cid = ? AND id = ?");
                stmt.setLong(1, contextId);
                for (String id : ids) {
                    stmt.setString(2, id);
                    stmt.addBatch();
                }
                stmt.executeBatch();
                Databases.closeSQLStuff((Statement)stmt);
                stmt = null;
            }
        }
        catch (SQLException e) {
            try {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
    }

    private long getUsedContextQuota(int contextId, String ignoree, Connection con) throws OXException {
        long l;
        ResultSet rs;
        PreparedStatement stmt;
        block9: {
            block8: {
                stmt = null;
                rs = null;
                if (null == ignoree) {
                    stmt = con.prepareStatement("SELECT SUM(size) FROM preview WHERE cid = ?");
                    stmt.setLong(1, contextId);
                } else {
                    stmt = con.prepareStatement("SELECT SUM(size) FROM preview WHERE cid = ? AND id <> ?");
                    stmt.setLong(1, contextId);
                    stmt.setString(2, ignoree);
                }
                rs = stmt.executeQuery();
                if (rs.next()) break block8;
                long l2 = 0L;
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                return l2;
            }
            if (!rs.wasNull()) break block9;
            long l3 = 0L;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return l3;
        }
        try {
            l = rs.getLong(1);
        }
        catch (SQLException e) {
            try {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFor(int contextId) throws OXException {
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        Connection con = dbService.getWritable(contextId);
        try {
            this.clearFor(contextId, con);
        }
        finally {
            dbService.backWritable(contextId, con);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearFor(int contextId, Connection con) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        block8: {
            stmt = null;
            rs = null;
            boolean rollback = false;
            try {
                Databases.startTransaction((Connection)con);
                rollback = true;
                stmt = con.prepareStatement("SELECT id FROM preview WHERE cid=?");
                stmt.setInt(1, contextId);
                rs = stmt.executeQuery();
                HashSet<String> ids = new HashSet<String>(4);
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                rs = null;
                stmt = con.prepareStatement("DELETE FROM preview WHERE cid=?");
                stmt.setLong(1, contextId);
                stmt.executeUpdate();
                Databases.closeSQLStuff((Statement)stmt);
                stmt = null;
                if (!ids.isEmpty()) {
                    stmt = con.prepareStatement("DELETE FROM previewData WHERE cid=? AND id=?");
                    stmt.setLong(1, contextId);
                    for (String id : ids) {
                        stmt.setString(2, id);
                        stmt.addBatch();
                    }
                    stmt.executeBatch();
                    Databases.closeSQLStuff((Statement)stmt);
                    stmt = null;
                }
                con.commit();
                rollback = false;
                if (!rollback) break block8;
            }
            catch (SQLException e) {
                try {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        Databases.rollback((Connection)con);
                    }
                    Databases.autocommit((Connection)con);
                    Databases.closeSQLStuff(rs, (Statement)stmt);
                    throw throwable;
                }
            }
            Databases.rollback((Connection)con);
        }
        Databases.autocommit((Connection)con);
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedPreview get(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return null;
        }
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        Connection con = dbService.getReadOnly(contextId);
        try {
            CachedPreview cachedPreview = this.load(id, userId, contextId, con);
            return cachedPreview;
        }
        finally {
            dbService.backReadOnly(contextId, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CachedPreview load(String id, int userId, int contextId, Connection con) throws OXException {
        CachedPreview cachedPreview;
        long size;
        String fileType;
        String fileName;
        ResultSet rs;
        PreparedStatement stmt;
        block12: {
            block11: {
                stmt = null;
                rs = null;
                if (userId > 0) {
                    stmt = con.prepareStatement("SELECT fileName, fileType, size FROM preview WHERE cid = ? AND user = ? AND id = ?");
                    stmt.setLong(1, contextId);
                    stmt.setLong(2, userId);
                    stmt.setString(3, id);
                } else {
                    stmt = con.prepareStatement("SELECT fileName, fileType, size FROM preview WHERE cid = ? AND id = ?");
                    stmt.setLong(1, contextId);
                    stmt.setString(2, id);
                }
                rs = stmt.executeQuery();
                if (rs.next()) break block11;
                CachedPreview cachedPreview2 = null;
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                return cachedPreview2;
            }
            fileName = rs.getString(1);
            fileType = rs.getString(2);
            size = rs.getLong(3);
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            if (userId > 0) {
                stmt = con.prepareStatement("SELECT data FROM previewData WHERE cid = ? AND user = ? AND id = ?");
                stmt.setLong(1, contextId);
                stmt.setLong(2, userId);
                stmt.setString(3, id);
            } else {
                stmt = con.prepareStatement("SELECT data FROM previewData WHERE cid = ? AND id = ?");
                stmt.setLong(1, contextId);
                stmt.setString(2, id);
            }
            rs = stmt.executeQuery();
            if (rs.next()) break block12;
            CachedPreview cachedPreview3 = null;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return cachedPreview3;
        }
        try {
            cachedPreview = new CachedPreview(Streams.stream2bytes((InputStream)rs.getBinaryStream(1)), fileName, fileType, size);
        }
        catch (SQLException e) {
            try {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                catch (IOException e2) {
                    throw PreviewExceptionCodes.IO_ERROR.create((Throwable)e2, new Object[]{e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return cachedPreview;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(int userId, int contextId) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        DatabaseService databaseService;
        block16: {
            databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
            if (databaseService == null) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
            }
            con = databaseService.getWritable(contextId);
            boolean committed = true;
            stmt = null;
            rs = null;
            try {
                int pos;
                con.setAutoCommit(false);
                committed = false;
                if (userId > 0) {
                    stmt = con.prepareStatement("SELECT id FROM preview WHERE cid=? AND user=?");
                    int pos2 = 1;
                    stmt.setInt(pos2++, contextId);
                    stmt.setInt(pos2, userId);
                } else {
                    stmt = con.prepareStatement("SELECT id FROM preview WHERE cid=?");
                    stmt.setInt(1, contextId);
                }
                rs = stmt.executeQuery();
                HashSet<String> ids = new HashSet<String>(16);
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                rs = null;
                if (userId > 0) {
                    stmt = con.prepareStatement("DELETE FROM preview WHERE cid=? AND user=?");
                    pos = 1;
                    stmt.setInt(pos++, contextId);
                    stmt.setInt(pos, userId);
                } else {
                    stmt = con.prepareStatement("DELETE FROM preview WHERE cid=?");
                    stmt.setInt(1, contextId);
                }
                stmt.executeUpdate();
                Databases.closeSQLStuff((Statement)stmt);
                stmt = null;
                if (!ids.isEmpty()) {
                    pos = 1;
                    if (userId > 0) {
                        stmt = con.prepareStatement("DELETE FROM previewData WHERE cid=? AND user=? AND id=?");
                        stmt.setInt(pos++, contextId);
                        stmt.setInt(pos++, userId);
                    } else {
                        stmt = con.prepareStatement("DELETE FROM previewData WHERE cid=? AND id=?");
                        stmt.setInt(pos++, contextId);
                    }
                    for (String id : ids) {
                        stmt.setString(pos, id);
                        stmt.addBatch();
                    }
                    stmt.executeBatch();
                    Databases.closeSQLStuff((Statement)stmt);
                    stmt = null;
                }
                con.commit();
                committed = true;
                if (committed) break block16;
            }
            catch (DataTruncation e) {
                try {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                    catch (SQLException e2) {
                        throw PreviewExceptionCodes.ERROR.create((Throwable)e2, new Object[]{e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    if (!committed) {
                        Databases.rollback((Connection)con);
                    }
                    Databases.closeSQLStuff(rs, stmt);
                    Databases.autocommit((Connection)con);
                    databaseService.backWritable(contextId, con);
                    throw throwable;
                }
            }
            Databases.rollback((Connection)con);
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        Databases.autocommit((Connection)con);
        databaseService.backWritable(contextId, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAlikes(String id, int userId, int contextId) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        DatabaseService databaseService;
        block11: {
            databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
            if (databaseService == null) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
            }
            if (null == id) {
                throw PreviewExceptionCodes.ERROR.create(new Object[]{"Missing identifier."});
            }
            con = databaseService.getWritable(contextId);
            boolean committed = true;
            stmt = null;
            rs = null;
            try {
                con.setAutoCommit(false);
                committed = false;
                stmt = con.prepareStatement("SELECT id FROM preview WHERE cid=? AND user=? AND id LIKE ?");
                int pos = 1;
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, userId);
                stmt.setString(pos, id + "%");
                rs = stmt.executeQuery();
                HashSet<String> ids = new HashSet<String>(16);
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                rs = null;
                stmt = con.prepareStatement("DELETE FROM preview WHERE cid=? AND user=? AND id LIKE ?");
                pos = 1;
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, userId);
                stmt.setString(pos, id + "%");
                stmt.executeUpdate();
                Databases.closeSQLStuff((Statement)stmt);
                stmt = null;
                if (!ids.isEmpty()) {
                    stmt = con.prepareStatement("DELETE FROM previewData WHERE cid=? AND user=? AND id=?");
                    pos = 1;
                    stmt.setInt(pos++, contextId);
                    stmt.setInt(pos++, userId);
                    for (String ide : ids) {
                        stmt.setString(pos, ide);
                        stmt.addBatch();
                    }
                    stmt.executeBatch();
                    Databases.closeSQLStuff((Statement)stmt);
                    stmt = null;
                }
                con.commit();
                committed = true;
                if (committed) break block11;
            }
            catch (DataTruncation e) {
                try {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                    catch (SQLException e2) {
                        throw PreviewExceptionCodes.ERROR.create((Throwable)e2, new Object[]{e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    if (!committed) {
                        Databases.rollback((Connection)con);
                    }
                    Databases.closeSQLStuff(rs, stmt);
                    Databases.autocommit((Connection)con);
                    databaseService.backWritable(contextId, con);
                    throw throwable;
                }
            }
            Databases.rollback((Connection)con);
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        Databases.autocommit((Connection)con);
        databaseService.backWritable(contextId, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return false;
        }
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        Connection con = dbService.getReadOnly(contextId);
        try {
            boolean bl = this.exists(id, userId, contextId, con);
            return bl;
        }
        finally {
            dbService.backReadOnly(contextId, con);
        }
    }

    private boolean exists(String id, int userId, int contextId, Connection con) throws OXException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (userId > 0) {
                stmt = con.prepareStatement("SELECT 1 FROM preview WHERE cid = ? AND user = ? AND id = ?");
                stmt.setLong(1, contextId);
                stmt.setLong(2, userId);
                stmt.setString(3, id);
            } else {
                stmt = con.prepareStatement("SELECT 1 FROM preview WHERE cid = ? AND id = ?");
                stmt.setLong(1, contextId);
                stmt.setString(2, id);
            }
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return bl;
    }
}

