/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public class FolderParser {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FolderParser.class));
    private final UserPermissionBits userPermissionBits;
    private static final int[] mapping = new int[]{0, 2, 4, -1, 8};
    private static final String STR_EMPTY = "";

    public FolderParser(UserConfiguration userConfig) {
        this.userPermissionBits = userConfig.getUserPermissionBits();
    }

    public FolderParser(UserPermissionBits userPermissionBits) {
        this.userPermissionBits = userPermissionBits;
    }

    public FolderParser() {
        this((UserPermissionBits)null);
    }

    public void parse(FolderObject fo, JSONObject jsonObj) throws OXException {
        try {
            this.parseElementFolder(fo, jsonObj);
        }
        catch (JSONException exc) {
            throw OXFolderExceptionCode.JSON_ERROR.create(exc, exc.getMessage());
        }
    }

    public static int getModuleFromString(String moduleStr, int objectId) throws OXException {
        if (moduleStr.equalsIgnoreCase("tasks")) {
            return 1;
        }
        if (moduleStr.equalsIgnoreCase("calendar")) {
            return 2;
        }
        if (moduleStr.equalsIgnoreCase("contacts")) {
            return 3;
        }
        if (moduleStr.equalsIgnoreCase("unbound")) {
            return 4;
        }
        if (moduleStr.equalsIgnoreCase("mail")) {
            return 7;
        }
        if (moduleStr.equalsIgnoreCase("projects")) {
            return 6;
        }
        if (moduleStr.equalsIgnoreCase("infostore")) {
            return 8;
        }
        if (moduleStr.equals("messaging")) {
            return 13;
        }
        if (moduleStr.equalsIgnoreCase("system")) {
            if (objectId == 8) {
                return 6;
            }
            if (objectId == 9) {
                return 8;
            }
            return 5;
        }
        throw OXFolderExceptionCode.UNKNOWN_MODULE.create(moduleStr, STR_EMPTY);
    }

    protected void parseElementFolder(FolderObject fo, JSONObject jsonObj) throws OXException, JSONException {
        if (jsonObj.has("id")) {
            if (fo.containsObjectID() && fo.getObjectID() != jsonObj.getInt("id")) {
                throw OXFolderExceptionCode.PARAMETER_MISMATCH.create("id", "id");
            }
            if (!fo.containsObjectID()) {
                fo.setObjectID(jsonObj.getInt("id"));
            }
        }
        if (jsonObj.has("folder_id")) {
            fo.setParentFolderID(jsonObj.getInt("folder_id"));
        }
        if (jsonObj.has("title")) {
            fo.setFolderName(jsonObj.getString("title"));
        }
        if (jsonObj.has("module")) {
            fo.setModule(FolderParser.getModuleFromString(jsonObj.getString("module"), fo.containsObjectID() ? fo.getObjectID() : -1));
        }
        if (jsonObj.has("type")) {
            fo.setType(jsonObj.getInt("type"));
        }
        if (jsonObj.has("subfolders")) {
            fo.setSubfolderFlag(jsonObj.getBoolean("subfolders"));
        }
        if (jsonObj.has("standard_folder")) {
            fo.setDefaultFolder(jsonObj.getBoolean("standard_folder"));
        }
        if (jsonObj.has("permissions") && !jsonObj.isNull("permissions")) {
            JSONArray jsonArr = jsonObj.getJSONArray("permissions");
            OCLPermission[] perms = this.parseOCLPermission(jsonArr, fo.containsObjectID() ? Integer.valueOf(fo.getObjectID()) : null);
            fo.setPermissionsAsArray(perms);
        }
        if (jsonObj.has("meta") && !jsonObj.isNull("meta")) {
            fo.setMeta((Map)JSONCoercion.coerceToNative((JSONValue)jsonObj.getJSONObject("meta")));
        }
    }

    public OCLPermission[] parseOCLPermission(JSONArray permissionsAsJSON, Integer objectID) throws JSONException, OXException {
        int numberOfPermissions = permissionsAsJSON.length();
        OCLPermission[] perms = new OCLPermission[numberOfPermissions];
        for (int i = 0; i < numberOfPermissions; ++i) {
            int entity;
            JSONObject elem = permissionsAsJSON.getJSONObject(i);
            if (!elem.has("entity")) {
                throw OXFolderExceptionCode.MISSING_PARAMETER.create("entity");
            }
            try {
                entity = elem.getInt("entity");
            }
            catch (JSONException e) {
                if (null == this.userPermissionBits) {
                    throw e;
                }
                String entityStr = elem.getString("entity");
                entity = UserStorage.getInstance().getUserId(entityStr, this.userPermissionBits.getContext());
            }
            OCLPermission oclPerm = new OCLPermission();
            oclPerm.setEntity(entity);
            if (objectID != null) {
                oclPerm.setFuid(objectID);
            }
            if (!elem.has("bits")) {
                throw OXFolderExceptionCode.MISSING_PARAMETER.create("bits");
            }
            int[] permissionBits = FolderParser.parsePermissionBits(elem.getInt("bits"));
            if (!oclPerm.setAllPermission(permissionBits[0], permissionBits[1], permissionBits[2], permissionBits[3])) {
                throw OXFolderExceptionCode.INVALID_PERMISSION.create(permissionBits[0], permissionBits[1], permissionBits[2], permissionBits[3]);
            }
            oclPerm.setFolderAdmin(permissionBits[4] > 0);
            if (!elem.has("group")) {
                throw OXFolderExceptionCode.MISSING_PARAMETER.create("group");
            }
            oclPerm.setGroupPermission(elem.getBoolean("group"));
            perms[i] = oclPerm;
        }
        return perms;
    }

    private static final int[] parsePermissionBits(int bitsArg) {
        int bits = bitsArg;
        int[] retval = new int[5];
        for (int i = retval.length - 1; i >= 0; --i) {
            int shiftVal = i * 7;
            retval[i] = bits >> shiftVal;
            bits -= retval[i] << shiftVal;
            retval[i] = retval[i] == 64 ? 128 : (i < retval.length - 1 ? mapping[retval[i]] : retval[i]);
        }
        return retval;
    }
}

