/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.DataServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.request.ReminderRequest;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public class Reminder
extends DataServlet {
    private static final long serialVersionUID = 7117849531568676025L;
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Reminder.class));

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServerSession session = Reminder.getSessionObject((ServletRequest)httpServletRequest);
        Response response = new Response(session);
        try {
            JSONObject jsonObj;
            String action = Reminder.parseMandatoryStringParameter(httpServletRequest, "action");
            try {
                jsonObj = Reminder.convertParameter2JSONObject(httpServletRequest);
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                this.writeResponse(response, httpServletResponse, session);
                return;
            }
            ReminderRequest reminderRequest = new ReminderRequest(session);
            JSONValue responseObj = reminderRequest.action(action, jsonObj);
            response.setTimestamp(reminderRequest.getTimestamp());
            response.setData(responseObj);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        this.writeResponse(response, httpServletResponse, session);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServerSession session = Reminder.getSessionObject((ServletRequest)httpServletRequest);
        Response response = new Response(session);
        try {
            JSONObject jsonObj;
            String action = Reminder.parseMandatoryStringParameter(httpServletRequest, "action");
            String data = Reminder.getBody(httpServletRequest);
            try {
                jsonObj = Reminder.convertParameter2JSONObject(httpServletRequest);
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                this.writeResponse(response, httpServletResponse, session);
                return;
            }
            ReminderRequest reminderRequest = new ReminderRequest(session);
            if (data.charAt(0) == '[') {
                JSONArray jData = new JSONArray(data);
                jsonObj.put("data", (Object)jData);
                JSONValue responseObj = reminderRequest.action(action, jsonObj);
                response.setData(responseObj);
            } else {
                JSONObject jData = new JSONObject(data);
                jsonObj.put("data", (Object)jData);
                JSONValue responseObj = reminderRequest.action(action, jsonObj);
                response.setData(responseObj);
            }
        }
        catch (OXException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            response.setException(exc);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        this.writeResponse(response, httpServletResponse, session);
    }

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return true;
    }
}

