/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.eraf;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.nio.channels.FileChannel;

public class EnhancedRandomAccessFile
implements DataInput,
DataOutput {
    public static final int BIG_ENDIAN = 0;
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int CREATE = 4;
    protected static final int defaultBufferSize = 1024;
    protected String location;
    protected RandomAccessFile file;
    protected long filePosition;
    protected byte[] buffer;
    protected long bufferStart;
    protected long dataEnd;
    protected int dataSize;
    protected boolean endOfFile;
    protected boolean readonly;
    protected boolean bigEndian;
    protected int mode;
    boolean bufferModified = false;
    private long minLength = 0L;
    boolean extendMode = false;

    protected EnhancedRandomAccessFile(int bufferSize) {
        this.file = null;
        this.readonly = true;
        this.init(bufferSize);
    }

    public EnhancedRandomAccessFile(String location, String mode) throws IOException {
        this(location, mode, 1024);
        this.location = location;
    }

    public EnhancedRandomAccessFile(String location, String mode, int bufferSize) throws IOException {
        this.location = location;
        this.file = new RandomAccessFile(location, mode);
        this.readonly = mode.equals("r");
        this.init(bufferSize);
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.file;
    }

    private void init(int bufferSize) {
        this.bufferStart = 0L;
        this.dataEnd = 0L;
        this.dataSize = 0;
        this.filePosition = 0L;
        this.buffer = new byte[bufferSize];
        this.endOfFile = false;
    }

    public EnhancedRandomAccessFile(String filename, int mode) throws IOException {
        this(filename, mode, 1024);
    }

    public EnhancedRandomAccessFile(File file, String modeString) throws IOException {
        this(file.getPath(), modeString);
    }

    public EnhancedRandomAccessFile(String filename, int mode, int bufferSize) throws FileNotFoundException, IOException {
        this.mode = mode;
        mode |= 1;
        if ((this.mode & 4) > 0) {
            this.mode |= 2;
        }
        File checkfile = new File(filename);
        if ((this.mode & 2) > 0 && !checkfile.exists()) {
            mode |= 4;
        }
        if ((this.mode & 4) > 0 && checkfile.exists() && !checkfile.delete()) {
            throw new IOException("Failed to delete " + filename);
        }
        if (this.mode == 1 && !new File(filename).exists()) {
            throw new FileNotFoundException(filename);
        }
        String modeString = (this.mode & 2) > 0 ? "rw" : "r";
        this.file = new RandomAccessFile(filename, modeString);
        this.bufferStart = 0L;
        this.dataEnd = 0L;
        this.dataSize = 0;
        this.filePosition = 0L;
        this.buffer = new byte[bufferSize];
        this.endOfFile = false;
    }

    public boolean isAtEndOfFile() {
        return this.endOfFile;
    }

    public FileChannel getChannel() {
        if (this.file == null) {
            return null;
        }
        try {
            this.file.seek(0L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.file.getChannel();
    }

    public void close() throws IOException {
        if (this.file == null) {
            return;
        }
        if ((this.mode | 2) > 0 && this.bufferModified) {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
        }
        if (!this.readonly && this.minLength != 0L && this.minLength != this.file.length()) {
            this.file.setLength(this.minLength);
        }
        this.file.close();
        this.file = null;
    }

    public void seek(long pos) throws IOException {
        if (pos >= this.bufferStart && pos < this.dataEnd) {
            this.filePosition = pos;
            return;
        }
        if (this.bufferModified) {
            this.flush();
        }
        this.bufferStart = pos;
        this.filePosition = pos;
        this.dataSize = this.read_(pos, this.buffer, 0, this.buffer.length);
        if (this.dataSize < 0) {
            this.dataSize = 0;
            this.endOfFile = true;
        } else {
            this.endOfFile = false;
        }
        this.dataEnd = this.bufferStart + (long)this.dataSize;
    }

    public long getFilePointer() throws IOException {
        return this.filePosition;
    }

    public String getLocation() {
        return this.location;
    }

    public long length() throws IOException {
        long fileLength = this.file.length();
        if (fileLength < this.dataEnd) {
            return this.dataEnd;
        }
        return fileLength;
    }

    public void order(int endian) {
        this.bigEndian = endian == 0;
    }

    public FileDescriptor getFD() throws IOException {
        return this.file == null ? null : this.file.getFD();
    }

    public void flush() throws IOException {
        if (this.bufferModified) {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
            this.bufferModified = false;
        }
    }

    public void setMinLength(long minLength) {
        this.minLength = minLength;
    }

    public void setExtendMode() {
        this.extendMode = true;
    }

    public final int read() throws IOException {
        if (this.filePosition < this.dataEnd) {
            return this.buffer[(int)(this.filePosition++ - this.bufferStart)] & 0xFF;
        }
        if (this.endOfFile) {
            return -1;
        }
        this.seek(this.filePosition);
        return this.read();
    }

    protected int readBytes(byte[] b, int off, int len) throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        int bytesAvailable = (int)(this.dataEnd - this.filePosition);
        if (bytesAvailable < 1) {
            this.seek(this.filePosition);
            return this.readBytes(b, off, len);
        }
        int copyLength = bytesAvailable >= len ? len : bytesAvailable;
        System.arraycopy(this.buffer, (int)(this.filePosition - this.bufferStart), b, off, copyLength);
        this.filePosition += (long)copyLength;
        if (copyLength < len) {
            int extraCopy = len - copyLength;
            if (extraCopy > this.buffer.length) {
                extraCopy = this.read_(this.filePosition, b, off + copyLength, len - copyLength);
            } else {
                this.seek(this.filePosition);
                if (!this.endOfFile) {
                    extraCopy = extraCopy > this.dataSize ? this.dataSize : extraCopy;
                    System.arraycopy(this.buffer, 0, b, off + copyLength, extraCopy);
                } else {
                    extraCopy = -1;
                }
            }
            if (extraCopy > 0) {
                this.filePosition += (long)extraCopy;
                return copyLength + extraCopy;
            }
        }
        return copyLength;
    }

    protected int read_(long pos, byte[] b, int offset, int len) throws IOException {
        this.file.seek(pos);
        int n = this.file.read(b, offset, len);
        if (this.extendMode && n < len) {
            n = len;
        }
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.seek(this.getFilePointer() + (long)n);
        return n;
    }

    public final void unread() {
        --this.filePosition;
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.filePosition < this.dataEnd) {
            this.buffer[(int)(this.filePosition++ - this.bufferStart)] = (byte)b;
            this.bufferModified = true;
        } else if (this.dataSize != this.buffer.length) {
            this.buffer[(int)(this.filePosition++ - this.bufferStart)] = (byte)b;
            this.bufferModified = true;
            ++this.dataSize;
            ++this.dataEnd;
        } else {
            this.seek(this.filePosition);
            this.write(b);
        }
    }

    public final void writeBytes(byte[] b, int off, int len) throws IOException {
        if (len < this.buffer.length) {
            long myDataEnd;
            int spaceInBuffer = 0;
            int copyLength = 0;
            if (this.filePosition >= this.bufferStart) {
                spaceInBuffer = (int)(this.bufferStart + (long)this.buffer.length - this.filePosition);
            }
            if (spaceInBuffer > 0) {
                copyLength = spaceInBuffer > len ? len : spaceInBuffer;
                System.arraycopy(b, off, this.buffer, (int)(this.filePosition - this.bufferStart), copyLength);
                this.bufferModified = true;
                myDataEnd = this.filePosition + (long)copyLength;
                this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)copyLength;
            }
            if (copyLength < len) {
                this.seek(this.filePosition);
                System.arraycopy(b, off + copyLength, this.buffer, (int)(this.filePosition - this.bufferStart), len - copyLength);
                this.bufferModified = true;
                myDataEnd = this.filePosition + (long)(len - copyLength);
                this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)(len - copyLength);
            }
        } else {
            if (this.bufferModified) {
                this.flush();
                this.dataSize = 0;
                this.bufferStart = this.dataEnd = (long)0;
            }
            this.file.seek(this.filePosition);
            this.file.write(b, off, len);
            this.filePosition += (long)len;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public final short readShort() throws IOException {
        byte[] ch = new byte[2];
        if (this.readBytes(ch, 0, 2) < 0) {
            throw new EOFException();
        }
        return (short)((ch[1] << 8) + (ch[0] << 0));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        byte[] ch = new byte[2];
        if (this.readBytes(ch, 0, 2) < 0) {
            throw new EOFException();
        }
        return (short)((ch[1] << 8) + (ch[0] << 0));
    }

    @Override
    public final char readChar() throws IOException {
        byte[] ch = new byte[2];
        if (this.readBytes(ch, 0, 2) < 0) {
            throw new EOFException();
        }
        return (char)((ch[0] << 8) + (ch[1] << 0));
    }

    @Override
    public final int readInt() throws IOException {
        byte[] ch = new byte[4];
        if (this.readBytes(ch, 0, 4) < 0) {
            throw new EOFException();
        }
        int i0 = ch[3] << 0;
        int i1 = ch[2] << 8;
        int i2 = ch[1] << 16;
        int i3 = ch[0] << 24;
        return i3 + i2 + i1 + i0;
    }

    @Override
    public final long readLong() throws IOException {
        byte[] ch = new byte[8];
        if (this.readBytes(ch, 0, 8) < 0) {
            throw new EOFException();
        }
        return (long)((ch[0] << 56) + (ch[1] << 40) + (ch[2] << 40) + (ch[3] << 32)) + ((long)(ch[4] << 24) + (long)(ch[5] << 16) + (long)(ch[6] << 8) + (long)(ch[7] << 0)) & 0xFFFFFFFFL;
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        int c;
        StringBuffer input = new StringBuffer();
        while ((c = this.read()) != -1 && c != 10) {
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    public final void writeBytes(char[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            this.write((byte)b[i]);
        }
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        char c;
        int i;
        int strlen = str.length();
        int utflen = 0;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(utflen >>> 8 & 0xFF);
        this.write(utflen >>> 0 & 0xFF);
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c >> 0 & 0x3F);
        }
    }

    public String toString() {
        return "fp=" + this.filePosition + ", bs=" + this.bufferStart + ", de=" + this.dataEnd + ", ds=" + this.dataSize + ", bl=" + this.buffer.length + ", m=" + this.mode + ", bm=" + this.bufferModified;
    }
}

