/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;

public final class HTMLDetector {
    private HTMLDetector() {
    }

    public static boolean containsHTMLTags(String sequence) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        String lc = Strings.toLowerCase(sequence);
        if (lc.indexOf("<html>") >= 0) {
            return true;
        }
        if (lc.indexOf("<head>") >= 0) {
            return true;
        }
        if (lc.indexOf("<body>") >= 0) {
            return true;
        }
        if (lc.indexOf("<script>") >= 0) {
            return true;
        }
        if (lc.indexOf("javascript") >= 0) {
            return true;
        }
        if (lc.indexOf("<img") >= 0) {
            return true;
        }
        if (lc.indexOf("<object") >= 0) {
            return true;
        }
        return lc.indexOf("<embed") >= 0;
    }

    public static boolean containsHTMLTags(String sequence, boolean strict) {
        return strict ? HTMLDetector.containsHTMLTags(sequence, "<br", "<p>") : HTMLDetector.containsHTMLTags(sequence);
    }

    public static boolean containsHTMLTags(String sequence, String ... tags) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        String lc = Strings.toLowerCase(sequence);
        if (lc.indexOf("<html>") >= 0) {
            return true;
        }
        if (lc.indexOf("<head>") >= 0) {
            return true;
        }
        if (lc.indexOf("<body>") >= 0) {
            return true;
        }
        if (lc.indexOf("<script>") >= 0) {
            return true;
        }
        if (lc.indexOf("javascript") >= 0) {
            return true;
        }
        if (lc.indexOf("<img") >= 0) {
            return true;
        }
        if (lc.indexOf("<object") >= 0) {
            return true;
        }
        if (lc.indexOf("<embed") >= 0) {
            return true;
        }
        if (null != tags) {
            int i = tags.length;
            while (i-- > 0) {
                String tag = tags[i];
                if (Strings.isEmpty(tag) || lc.indexOf(tag) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsHTMLTag(String sequence, String tag) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        return HTMLDetector.containsIgnoreCase(sequence, new StringAllocator(tag.length() + 2).append('<').append(tag).append('>').toString());
    }

    private static boolean containsIgnoreCase(String sequence, String str) {
        return Strings.toLowerCase(sequence).indexOf(Strings.toLowerCase(str)) >= 0;
    }

    public static boolean containsHTMLTags(byte[] sequence) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (HTMLDetector.containsHTMLTag(sequence, "html")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, "head")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, "body")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, "script")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, "javascript")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, "<img")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, "<object")) {
            return true;
        }
        return HTMLDetector.containsIgnoreCase(sequence, "<embed");
    }

    public static boolean containsHTMLTags(byte[] sequence, boolean strict) {
        return strict ? HTMLDetector.containsHTMLTags(sequence, "<br", "<p>") : HTMLDetector.containsHTMLTags(sequence);
    }

    public static boolean containsHTMLTags(byte[] sequence, String ... tags) {
        if (HTMLDetector.containsHTMLTags(sequence)) {
            return true;
        }
        if (null != tags) {
            int i = tags.length;
            while (i-- > 0) {
                String tag = tags[i];
                if (Strings.isEmpty(tag) || !HTMLDetector.containsIgnoreCase(sequence, tag)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsHTMLTags(byte[] sequence, int off, int len) {
        byte[] b;
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > sequence.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (off > 0 || sequence.length != len) {
            b = new byte[len];
            System.arraycopy(sequence, off, b, 0, len);
        } else {
            b = sequence;
        }
        if (HTMLDetector.containsHTMLTag(b, "html")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(b, "head")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(b, "body")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(b, "script")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(b, "javascript")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(b, "<img")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(b, "<object")) {
            return true;
        }
        return HTMLDetector.containsIgnoreCase(b, "<embed");
    }

    public static boolean containsHTMLTag(byte[] sequence, String tag) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        return HTMLDetector.containsIgnoreCase(sequence, new StringAllocator(tag.length() + 2).append('<').append(tag).append('>').toString());
    }

    public static boolean containsHTMLTag(byte[] sequence, int off, int len, String tag) {
        byte[] b;
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > sequence.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (off > 0 || sequence.length != len) {
            b = new byte[len];
            System.arraycopy(sequence, off, b, 0, len);
        } else {
            b = sequence;
        }
        return HTMLDetector.containsIgnoreCase(b, new StringAllocator(tag.length() + 2).append('<').append(tag).append('>').toString());
    }

    private static boolean containsIgnoreCase(byte[] sequence, String str) {
        if (HTMLDetector.indexOf(sequence, Charsets.toAsciiBytes(Strings.toLowerCase(str)), 0, sequence.length) >= 0) {
            return true;
        }
        return HTMLDetector.indexOf(sequence, Charsets.toAsciiBytes(Strings.toUpperCase(str)), 0, sequence.length) >= 0;
    }

    private static int indexOf(byte[] data, byte[] pattern, int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > data.length) {
            throw new IndexOutOfBoundsException(Integer.toString(beginIndex));
        }
        if (endIndex < 0 || endIndex > data.length) {
            throw new IndexOutOfBoundsException(Integer.toString(endIndex));
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(Integer.toString(endIndex - beginIndex));
        }
        int[] failure = HTMLDetector.computeFailure(pattern);
        if (failure == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        if (pattern == null) {
            return null;
        }
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }
}

