/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log;

import com.openexchange.log.LogFactory;
import com.openexchange.log.LogService;
import com.openexchange.log.Loggable;
import com.openexchange.log.PropertiesAppendingLogWrapper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class Log
implements org.apache.commons.logging.Log {
    private static final AtomicBoolean APPEND_TRACE_TO_MESSAGE = new AtomicBoolean();
    private static final AtomicReference<LogService> LOGSERVICE_REFERENCE = new AtomicReference();
    private final org.apache.commons.logging.Log delegate;

    public static void setAppendTraceToMessage(boolean appendTraceToMessage) {
        APPEND_TRACE_TO_MESSAGE.set(appendTraceToMessage);
    }

    public static boolean appendTraceToMessage() {
        return APPEND_TRACE_TO_MESSAGE.get();
    }

    public static void set(LogService logService) {
        LOGSERVICE_REFERENCE.set(logService);
    }

    public static org.apache.commons.logging.Log loggerFor(Class<?> clazz) {
        return Log.valueOf(LogFactory.getLog(clazz));
    }

    public static org.apache.commons.logging.Log loggerFor(String clazz) {
        return Log.valueOf(LogFactory.getLog(clazz));
    }

    public static org.apache.commons.logging.Log valueOf(org.apache.commons.logging.Log log) {
        if (log instanceof Log || log instanceof PropertiesAppendingLogWrapper) {
            return log;
        }
        return new Log(log);
    }

    private Log(org.apache.commons.logging.Log delegate) {
        this.delegate = delegate;
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.delegate.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public void trace(Object message) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.trace(message);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.TRACE, this.delegate, message));
        }
    }

    public void trace(Object message, Throwable t) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.trace(message, t);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.TRACE, this.delegate, message, t));
        }
    }

    public void debug(Object message) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.debug(message);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.DEBUG, this.delegate, message));
        }
    }

    public void debug(Object message, Throwable t) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.debug(message, t);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.DEBUG, this.delegate, message, t));
        }
    }

    public void info(Object message) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.info(message);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.INFO, this.delegate, message));
        }
    }

    public void info(Object message, Throwable t) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.info(message, t);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.INFO, this.delegate, message, t));
        }
    }

    public void warn(Object message) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.warn(message);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.WARNING, this.delegate, message));
        }
    }

    public void warn(Object message, Throwable t) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.warn(message, t);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.WARNING, this.delegate, message, t));
        }
    }

    public void error(Object message) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.error(message);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.ERROR, this.delegate, message));
        }
    }

    public void error(Object message, Throwable t) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.error(message, t);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.ERROR, this.delegate, message, t));
        }
    }

    public void fatal(Object message) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.fatal(message);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.FATAL, this.delegate, message));
        }
    }

    public void fatal(Object message, Throwable t) {
        LogService logService = LOGSERVICE_REFERENCE.get();
        if (null == logService) {
            this.delegate.fatal(message, t);
        } else {
            logService.log(logService.loggableFor(Loggable.Level.FATAL, this.delegate, message, t));
        }
    }
}

