/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n;

import com.openexchange.i18n.I18nService;
import com.openexchange.i18n.Translator;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.Locale;

public class I18nTranslator
implements Translator {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf(LogFactory.getLog(I18nTranslator.class));
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();
    private static final boolean WARN_ENABLED = LOG.isWarnEnabled();
    private final I18nService service;

    public I18nTranslator(I18nService service) {
        this.service = service;
    }

    @Override
    public String translate(String toTranslate) {
        if (!this.service.hasKey(toTranslate)) {
            Locale locale = this.service.getLocale();
            if (I18nTranslator.isEnUs(locale)) {
                if (DEBUG_ENABLED) {
                    String message = new StringAllocator(64).append("I18n service for locale ").append((Object)locale).append(" has no translation for \"").append(toTranslate).append("\".").toString();
                    LOG.warn((Object)message, new Throwable(message));
                }
            } else if (WARN_ENABLED) {
                LOG.warn((Object)new StringAllocator(64).append("I18n service for locale ").append((Object)locale).append(" has no translation for \"").append(toTranslate).append("\".").toString());
            }
            return toTranslate;
        }
        return this.service.getLocalized(toTranslate);
    }

    private static boolean isEnUs(Locale locale) {
        if (null == locale) {
            return false;
        }
        return "en".equals(locale.getLanguage()) && "US".equals(locale.getCountry());
    }
}

