/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception;

import com.openexchange.exception.Category;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.LogLevelAwareOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class OXExceptionFactory {
    private static final OXExceptionFactory INSTANCE = new OXExceptionFactory();
    public static final Set<Category.EnumType> DISPLAYABLE = Collections.unmodifiableSet(EnumSet.of(Category.EnumType.CAPACITY, new Category.EnumType[]{Category.EnumType.CONFLICT, Category.EnumType.CONNECTIVITY, Category.EnumType.PERMISSION_DENIED, Category.EnumType.SERVICE_DOWN, Category.EnumType.TRUNCATED, Category.EnumType.TRY_AGAIN, Category.EnumType.USER_INPUT, Category.EnumType.WARNING}));

    public static OXExceptionFactory getInstance() {
        return INSTANCE;
    }

    private OXExceptionFactory() {
    }

    public boolean equals(OXExceptionCode code, OXException e) {
        return OXExceptionFactory.recEquals(code.getPrefix(), code.getNumber(), e);
    }

    private static boolean recEquals(String prefix, int code, OXException e) {
        if (prefix.equals(e.getPrefix()) && e.getCode() == code) {
            return true;
        }
        Throwable cause = e.getCause();
        if (!(cause instanceof OXException)) {
            return false;
        }
        return OXExceptionFactory.recEquals(prefix, code, (OXException)cause);
    }

    public OXException create(OXExceptionCode code) {
        return this.create(code, new Object[0]);
    }

    public OXException create(OXExceptionCode code, Object ... args) {
        return this.create(code, null, args);
    }

    public OXException create(OXExceptionCode code, Throwable cause, Object ... args) {
        OXException ret;
        Category category = code.getCategory();
        if (category.getLogLevel().implies(LogLevel.DEBUG)) {
            ret = new OXException(code.getNumber(), code.getMessage(), cause, args);
        } else if (DISPLAYABLE.contains(category.getType())) {
            ret = new OXException(code.getNumber(), code.getMessage(), cause, args).setLogMessage(code.getMessage(), args);
        } else {
            String displayMessage = Category.EnumType.TRY_AGAIN.equals(category.getType()) ? "A temporary error occurred inside the Open-Xchange server which prevented it from fulfilling the request.. Please try again later." : "An error occurred inside the Open-Xchange server which prevented it from fulfilling the request.";
            ret = new OXException(code.getNumber(), displayMessage, cause, new Object[0]).setLogMessage(code.getMessage(), args);
        }
        if (code instanceof LogLevelAwareOXExceptionCode) {
            ret.setLogLevel(((LogLevelAwareOXExceptionCode)code).getLogLevel());
        }
        return ret.addCategory(category).setPrefix(code.getPrefix());
    }
}

