/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.authentication;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum LoginExceptionCodes implements OXExceptionCode
{
    ACCOUNT_LOCKED("Account \"%s\" is locked.", Category.CATEGORY_PERMISSION_DENIED, 1),
    ACCOUNT_NOT_READY_YET("Account \"%1$s\" is currently being created. This can take a while. Please try again later.", Category.CATEGORY_TRY_AGAIN, 2),
    UNKNOWN("Unknown problem: \"%s\".", Category.CATEGORY_ERROR, 3),
    COMMUNICATION("Login not possible at the moment. Please try again later.", Category.CATEGORY_SERVICE_DOWN, 5),
    INVALID_CREDENTIALS("Invalid credentials.", Category.CATEGORY_USER_INPUT, 6),
    MISSING_PROPERTY("Missing property %1$s.", Category.CATEGORY_CONFIGURATION, 9),
    DATABASE_DOWN("Database down.", Category.CATEGORY_SERVICE_DOWN, 10),
    PASSWORD_EXPIRED("Your password has expired. In order to change it, please log in to %1$s.", Category.CATEGORY_PERMISSION_DENIED, 11),
    USER_NOT_FOUND("User %1$s could not be found in context %2$s.", Category.CATEGORY_ERROR, 12),
    USER_NOT_ACTIVE("User is not activated.", Category.CATEGORY_PERMISSION_DENIED, 13),
    CLIENT_DENIED("Client \"%1$s\" is not activated.", Category.CATEGORY_PERMISSION_DENIED, 14),
    UNKNOWN_HTTP_AUTHORIZATION("Method \"%1$s\" in HTTP header authorization is not supported.", Category.CATEGORY_TRY_AGAIN, 15),
    REDIRECT("%1$s", Category.CATEGORY_USER_INPUT, 16),
    NO_SESSION_FOUND("No session found.", Category.CATEGORY_USER_INPUT, 17),
    MISSING_CAPABILITIES("Missing client capabilities.", Category.CATEGORY_WARNING, 18),
    NOT_SUPPORTED("%s does not support an auto login authentication.", Category.CATEGORY_SERVICE_DOWN, 19),
    SERVER_TOKEN_NOT_CREATED("Server side token for token login was not created.", Category.CATEGORY_ERROR, 20),
    DONT_USER_AGENT("Value of User-Agent header must not be used as value for the client parameter. Please use a string identifying the client software.", Category.CATEGORY_USER_INPUT, 21);

    private final String message;
    private final Category category;
    private final int number;

    private LoginExceptionCodes(String message, Category category, int detailNumber) {
        this.message = message;
        this.category = category;
        this.number = detailNumber;
    }

    @Override
    public String getPrefix() {
        return "LGI";
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals(this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

