/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.contact;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.ContactTest;
import com.openexchange.webdav.xml.FolderTest;

public class PermissionTest
extends ContactTest {
    public PermissionTest(String name) {
        super(name);
    }

    public void testDummy() {
    }

    public void testInsertContactInPrivateFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testInsertContactInPrivateFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(3);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 0, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Contact contactObj = new Contact();
        contactObj.setSurName("testInsertContactInPrivateFolderWithoutPermission");
        contactObj.setParentFolderID(parentFolderId);
        try {
            PermissionTest.insertContact(this.getSecondWebConversation(), contactObj, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testInsertContactInPublicFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testInsertContactInPublicFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(3);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 0, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Contact contactObj = new Contact();
        contactObj.setSurName("testInsertContactInPublicFolderWithoutPermission");
        contactObj.setParentFolderID(parentFolderId);
        try {
            PermissionTest.insertContact(this.getSecondWebConversation(), contactObj, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testUpdateContactInPrivateFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testInsertContactInPrivateFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(3);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Contact contactObj = new Contact();
        contactObj.setSurName("testUpdateContactInPrivateFolderWithoutPermission");
        contactObj.setParentFolderID(parentFolderId);
        int contactObjectId = PermissionTest.insertContact(this.getWebConversation(), contactObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        contactObj.setObjectID(contactObjectId);
        try {
            PermissionTest.updateContact(this.getSecondWebConversation(), contactObj, contactObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testUpdateContactInPublicFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testUpdateContactInPublicFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(3);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Contact contactObj = new Contact();
        contactObj.setSurName("testUpdateContactInPublicFolderWithoutPermission");
        contactObj.setParentFolderID(parentFolderId);
        int contactObjectId = PermissionTest.insertContact(this.getWebConversation(), contactObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        contactObj.setObjectID(contactObjectId);
        try {
            PermissionTest.updateContact(this.getSecondWebConversation(), contactObj, contactObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testDeleteContactInPrivateFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testDeleteContactInPrivateFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(3);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Contact contactObj = new Contact();
        contactObj.setSurName("testDeleteContactInPrivateFolderWithoutPermission");
        contactObj.setParentFolderID(parentFolderId);
        int contactObjectId = PermissionTest.insertContact(this.getWebConversation(), contactObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        contactObj.setObjectID(contactObjectId);
        try {
            PermissionTest.deleteContact(this.getSecondWebConversation(), contactObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testDeleteContactInPublicFolderWithoutPermission() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testDeleteContactInPublicFolderWithoutPermission" + System.currentTimeMillis());
        folderObj.setModule(3);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 4, 0, 0, 2)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Contact contactObj = new Contact();
        contactObj.setSurName("testDeleteContactInPublicFolderWithoutPermission");
        contactObj.setParentFolderID(parentFolderId);
        int contactObjectId = PermissionTest.insertContact(this.getWebConversation(), contactObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        contactObj.setObjectID(contactObjectId);
        try {
            PermissionTest.deleteContact(this.getSecondWebConversation(), contactObjectId, parentFolderId, "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
            PermissionTest.fail((String)"permission exception expected!");
        }
        catch (OXException exc) {
            PermissionTest.assertExceptionMessage(exc.getMessage(), 1002);
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }
}

