/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.webdav.xml.appointment.FreeBusyInformation;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class FreeBusyTest
extends ManagedAppointmentTest {
    private Appointment appointment;
    private Date now;
    private Date inAnHour;
    private UserValues values;
    private int contextId;
    private final DateFormat formatter = new SimpleDateFormat("yyyyMMdd");

    public FreeBusyTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
        this.contextId = this.getContextID(this.getClient());
        this.appointment = new Appointment();
        this.now = new Date();
        this.inAnHour = new Date(this.now.getTime() + 3600000L);
        this.appointment.setStartDate(this.now);
        this.appointment.setEndDate(this.inAnHour);
        this.appointment.setParentFolderID(this.folder.getObjectID());
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReserved() throws Exception {
        this.checkFreeBusy(this.appointment, 1);
    }

    public void testTemporary() throws Exception {
        this.checkFreeBusy(this.appointment, 2);
    }

    public void testAbsentOnBusiness() throws Exception {
        this.checkFreeBusy(this.appointment, 3);
    }

    public void testFree() throws Exception {
        this.checkFreeBusy(this.appointment, 4);
    }

    private void checkFreeBusy(Appointment app, int expectedState) throws OXException, Exception {
        app.setShownAs(expectedState);
        this.calendarManager.insert(this.appointment);
        int actualState = this.getFreeBusyState(app);
        FreeBusyTest.assertEquals((String)"Wrong free/busy state", (int)expectedState, (int)actualState);
    }

    private int getFreeBusyState(Appointment app) throws IOException, SAXException, OXException, JSONException, ParseException {
        String[] address = this.values.getDefaultAddress().split("@");
        FreeBusyTest.assertEquals((String)("Default address (" + this.values.getDefaultAddress() + ") should contain one @"), (int)2, (int)address.length);
        List<FreeBusyInformation> freeBusyStates = this.getFreeBusyState(this.getSecondWebConversation(), address[0], address[1], app.getStartDate());
        for (FreeBusyInformation info : freeBusyStates) {
            if (Math.abs(info.start.getTime() - this.now.getTime()) >= 2000L || Math.abs(info.end.getTime() - this.inAnHour.getTime()) >= 2000L) continue;
            return info.type;
        }
        return -1;
    }

    protected List<FreeBusyInformation> getFreeBusyState(WebConversation webCon, String username, String mailserver, Date start) throws IOException, SAXException, ParseException {
        String startFreebusy = this.formatter.format(start);
        String endFreebusy = this.formatter.format(new Date(start.getTime() + 86400000L));
        String url = "http://" + this.getHostName() + "/servlet/webdav.freebusy?contextid=" + this.contextId + "&username=" + username + "&server=" + mailserver + "&start=" + startFreebusy + "&end=" + endFreebusy;
        GetMethodWebRequest request = new GetMethodWebRequest(url);
        WebResponse response = webCon.getResponse((WebRequest)request);
        List<FreeBusyInformation> states = this.parseFreeBusyResponse(response);
        return states;
    }

    private List<FreeBusyInformation> parseFreeBusyResponse(WebResponse response) throws IOException, ParseException {
        String[] lines;
        LinkedList<FreeBusyInformation> result = new LinkedList<FreeBusyInformation>();
        String text = response.getText();
        for (String line : lines = text.split("\n")) {
            if (!line.startsWith("FREEBUSY")) continue;
            Pattern pattern = Pattern.compile("FBTYPE=(.+)?:(.+)?/(.+)");
            Matcher matcher = pattern.matcher(line);
            matcher.find();
            FreeBusyTest.assertEquals((String)("Must find three groups." + System.getProperty("line.separator") + text), (int)3, (int)matcher.groupCount());
            String type = matcher.group(1);
            String start = matcher.group(2);
            String end = matcher.group(3);
            result.add(new FreeBusyInformation(type, start, end));
        }
        return result;
    }

    protected int getContextID(AJAXClient client) throws IOException, SAXException {
        String url = "http://" + this.getHostName() + "/ajax/config/context_id?session=" + client.getSession().getId();
        GetMethodWebRequest request = new GetMethodWebRequest(url);
        WebResponse response = client.getSession().getConversation().getResponse((WebRequest)request);
        String text = response.getText();
        String sub = text.substring(8, text.length() - 1);
        return Integer.parseInt(sub);
    }
}

