/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.groupware.container.Appointment;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.FolderTest;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Bug13262Test
extends AppointmentTest {
    private int objectId = -1;
    private Appointment appointment;
    private Calendar thirdOccurrence;

    public Bug13262Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        FolderTest.clearFolder(this.webCon, new int[]{this.appointmentFolderId}, new String[]{"calendar"}, new Date(), "http://" + this.hostName, this.login, this.password, this.context);
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(this.startTime);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.appointment = new Appointment();
        this.appointment.setTitle("testBug13262");
        this.appointment.setStartDate(cal.getTime());
        ((Calendar)cal).add(5, 1);
        this.appointment.setEndDate(cal.getTime());
        this.appointment.setFullTime(true);
        this.appointment.setParentFolderID(this.appointmentFolderId);
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(5);
        this.appointment.setIgnoreConflicts(true);
        ((Calendar)cal).add(5, 2);
        this.thirdOccurrence = cal;
    }

    public void tearDown() throws Exception {
        if (this.objectId != -1) {
            Bug13262Test.deleteAppointment(this.getWebConversation(), this.objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        }
        super.tearDown();
    }

    public void testBugAsWritten() throws Exception {
        this.objectId = Bug13262Test.insertAppointment(this.getWebConversation(), this.appointment, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug13262Test.assertTrue((String)"No object Id returned after creation", (this.objectId > 0 ? 1 : 0) != 0);
        Appointment exception = this.createException();
        int exceptionId = Bug13262Test.updateAppointment(this.getWebConversation(), exception, this.objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment loadAppointment = Bug13262Test.loadAppointment(this.getWebConversation(), this.objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug13262Test.assertNotNull((String)"Loaded Appointment is null", (Object)loadAppointment);
        Appointment loadException = Bug13262Test.loadAppointment(this.getWebConversation(), exceptionId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug13262Test.assertNotNull((String)"Loaded Exception is null", (Object)loadException);
        Bug13262Test.assertEquals((String)"Start date of exception is wrong", (long)this.thirdOccurrence.getTimeInMillis(), (long)loadException.getStartDate().getTime());
    }

    private Appointment createException() {
        Appointment exception = new Appointment();
        exception.setObjectID(this.objectId);
        exception.setParentFolderID(this.appointmentFolderId);
        exception.setLastModified(this.appointment.getLastModified());
        exception.setStartDate(new Date(this.thirdOccurrence.getTimeInMillis()));
        exception.setEndDate(new Date(this.thirdOccurrence.getTimeInMillis() + 86400000L));
        exception.setFullTime(true);
        exception.setRecurrenceDatePosition(this.thirdOccurrence.getTime());
        exception.setTitle("testBug13262 - Exception");
        return exception;
    }
}

