/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.exception.OXException;
import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockAction;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavAction;
import com.openexchange.webdav.action.WebdavMaxUploadSizeAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;

public class MaxUploadSizeActionTest
extends ActionTestCase {
    private MockAction mockAction;
    private WebdavPath INDEX_HTML_URL;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mockAction = new MockAction();
        this.INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index_new.html"});
    }

    public void testPassThru() throws OXException {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("content-length", "9");
        TestMaxUploadSizeAction action = new TestMaxUploadSizeAction();
        action.setNext((WebdavAction)this.mockAction);
        action.perform(req, res);
        MaxUploadSizeActionTest.assertTrue((boolean)this.mockAction.wasActivated());
    }

    public void testDeny() throws OXException {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("content-length", "11");
        TestMaxUploadSizeAction action = new TestMaxUploadSizeAction();
        action.setNext((WebdavAction)this.mockAction);
        try {
            action.perform(req, res);
        }
        catch (WebdavProtocolException x) {
            MaxUploadSizeActionTest.assertEquals((int)413, (int)x.getStatus());
        }
        MaxUploadSizeActionTest.assertFalse((boolean)this.mockAction.wasActivated());
    }

    public static final class TestMaxUploadSizeAction
    extends WebdavMaxUploadSizeAction {
        public boolean fits(WebdavRequest req) {
            return Long.valueOf(req.getHeader("content-length")) < 10L;
        }
    }
}

