/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.PermissionTools;
import java.util.List;
import junit.framework.TestCase;

public class PermissionToolsTest
extends TestCase {
    public void testOCLP() {
        PermissionToolsTest.assertPermissions("arwd", 12, false, false, 128, 4, 4, 4);
        PermissionToolsTest.assertPermissions("rwd", 12, false, false, 0, 4, 4, 4);
        PermissionToolsTest.assertPermissions("awd", 12, false, false, 128, 0, 4, 4);
        PermissionToolsTest.assertPermissions("ard", 12, false, false, 128, 4, 0, 4);
        PermissionToolsTest.assertPermissions("arw", 12, false, false, 128, 4, 4, 0);
        PermissionToolsTest.assertPermissions("arowodo", 12, false, false, 128, 2, 2, 2);
        PermissionToolsTest.assertPermissions("arawada", 12, false, false, 128, 128, 128, 128);
        PermissionToolsTest.assertPermissions("vrwd", 12, false, false, 2, 4, 4, 4);
        PermissionToolsTest.assertPermissions("crwd", 12, false, false, 4, 4, 4, 4);
        PermissionToolsTest.assertPermissions("srwd", 12, false, false, 8, 4, 4, 4);
        PermissionToolsTest.assertPermissions("arwd/ag", 12, true, true, 128, 4, 4, 4);
        PermissionToolsTest.assertPermissions("arwd/g", 12, true, false, 128, 4, 4, 4);
        PermissionToolsTest.assertPermissions("arwd/a", 12, false, true, 128, 4, 4, 4);
    }

    public void testP() {
        List<OCLPermission> oclps = PermissionTools.P(12, "arwd", 13, "arwd", 14, "arwd/g");
        PermissionToolsTest.assertEquals((int)3, (int)oclps.size());
        PermissionToolsTest.assertEquals((int)12, (int)oclps.get(0).getEntity());
        PermissionToolsTest.assertEquals((int)13, (int)oclps.get(1).getEntity());
        PermissionToolsTest.assertEquals((int)14, (int)oclps.get(2).getEntity());
    }

    private static void assertPermissions(String permissionString, int entity, boolean group, boolean folderAdmin, int folderPermission, int readPermission, int writePermission, int deletePermission) {
        OCLPermission oclp = PermissionTools.OCLP(entity, permissionString);
        PermissionToolsTest.assertNotNull((Object)oclp);
        PermissionToolsTest.assertEquals((int)entity, (int)oclp.getEntity());
        PermissionToolsTest.assertEquals((boolean)group, (boolean)oclp.isGroupPermission());
        PermissionToolsTest.assertEquals((boolean)folderAdmin, (boolean)oclp.isFolderAdmin());
        PermissionToolsTest.assertEquals((int)folderPermission, (int)oclp.getFolderPermission());
        PermissionToolsTest.assertEquals((int)readPermission, (int)oclp.getReadPermission());
        PermissionToolsTest.assertEquals((int)writePermission, (int)oclp.getWritePermission());
        PermissionToolsTest.assertEquals((int)deletePermission, (int)oclp.getDeletePermission());
    }
}

