/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport.importers;

import com.openexchange.tools.versit.VCard;
import com.openexchange.tools.versit.VersionedObjectDefinition;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;

public class ExpressiveErrorMessageWhileParsingVCard
extends TestCase {
    private final String vcard = "BEGIN:VCARDVERSION:2.1\nSOURCE:Yahoo! AddressBook (http://address.yahoo.com)\nPRODID:-//Yahoo!/AddressBook/YAB3/2009\nFN;CHARSET=utf-8:Christine Wei\u221a\u00fcenbr\u221a\u00banner-Doppelname\nN;CHARSET=utf-8:Wei\u221a\u00fcenbr\u221a\u00banner-Doppelname;Christine;;;\nBDAY;CHARSET=utf-8:198041\nADR;HOME;CHARSET=utf-8:;;An der Luisenburg 2a;Leverkusen;NRW;51379;Germany\nADR;WORK;CHARSET=utf-8:;;Bonner Str 207;K\u221a\u2202ln;NRW;90768;Germany\nLABEL;HOME;CHARSET=utf-8;ENCODING=QUOTED-PRINTABLE: =\n;;An der Luisenburg 2a;Leverkusen;NRW;51379;Germany=0A=0A51379 Leverkusen=\n=0AGermany\nLABEL;WORK;CHARSET=utf-8;ENCODING=QUOTED-PRINTABLE: =\n;;Bonner Str 207;K=C3=B6ln;NRW;90768;Germany=0A=0A90768 K=C3=B6ln=0AGermany\nTEL;HOME;CHARSET=utf-8:02171 123456\nTEL;WORK;PREF;CHARSET=utf-8:0221 987654\nTEL;CELL;CHARSET=utf-8:0171 456987\nEMAIL;INTERNET;PREF;CHARSET=utf-8:christine@example.com\nTITLE;CHARSET=utf-8:Gesch\u221a\u00a7ftsf\u221a\u00bahrerin\nORG;CHARSET=utf-8:Christines L\u221a\u00a7dchen\nNOTE;CHARSET=utf-8:My private note on Christine\nUID;CHARSET=utf-8:2310c7412cc08237f3b57dfd7fbcf90c\nX-SKYPE-ID;CHARSET=utf-8:christine.weissenbruenner\nX-IM;SKYPE;CHARSET=utf-8:christine.weissenbruenner\nX-CID;CHARSET=utf-8:1\nX-CREATED;CHARSET=utf-8:1252943361\nX-MODIFIED;CHARSET=utf-8:1252943452\nREV;CHARSET=utf-8:2\nX-PRIMARY-PHONE;CHARSET=utf-8:1\nEND:VCARD\n";

    public void testBug13557() throws Throwable {
        String charset = "UTF-8";
        ByteArrayInputStream stream = new ByteArrayInputStream("BEGIN:VCARDVERSION:2.1\nSOURCE:Yahoo! AddressBook (http://address.yahoo.com)\nPRODID:-//Yahoo!/AddressBook/YAB3/2009\nFN;CHARSET=utf-8:Christine Wei\u221a\u00fcenbr\u221a\u00banner-Doppelname\nN;CHARSET=utf-8:Wei\u221a\u00fcenbr\u221a\u00banner-Doppelname;Christine;;;\nBDAY;CHARSET=utf-8:198041\nADR;HOME;CHARSET=utf-8:;;An der Luisenburg 2a;Leverkusen;NRW;51379;Germany\nADR;WORK;CHARSET=utf-8:;;Bonner Str 207;K\u221a\u2202ln;NRW;90768;Germany\nLABEL;HOME;CHARSET=utf-8;ENCODING=QUOTED-PRINTABLE: =\n;;An der Luisenburg 2a;Leverkusen;NRW;51379;Germany=0A=0A51379 Leverkusen=\n=0AGermany\nLABEL;WORK;CHARSET=utf-8;ENCODING=QUOTED-PRINTABLE: =\n;;Bonner Str 207;K=C3=B6ln;NRW;90768;Germany=0A=0A90768 K=C3=B6ln=0AGermany\nTEL;HOME;CHARSET=utf-8:02171 123456\nTEL;WORK;PREF;CHARSET=utf-8:0221 987654\nTEL;CELL;CHARSET=utf-8:0171 456987\nEMAIL;INTERNET;PREF;CHARSET=utf-8:christine@example.com\nTITLE;CHARSET=utf-8:Gesch\u221a\u00a7ftsf\u221a\u00bahrerin\nORG;CHARSET=utf-8:Christines L\u221a\u00a7dchen\nNOTE;CHARSET=utf-8:My private note on Christine\nUID;CHARSET=utf-8:2310c7412cc08237f3b57dfd7fbcf90c\nX-SKYPE-ID;CHARSET=utf-8:christine.weissenbruenner\nX-IM;SKYPE;CHARSET=utf-8:christine.weissenbruenner\nX-CID;CHARSET=utf-8:1\nX-CREATED;CHARSET=utf-8:1252943361\nX-MODIFIED;CHARSET=utf-8:1252943452\nREV;CHARSET=utf-8:2\nX-PRIMARY-PHONE;CHARSET=utf-8:1\nEND:VCARD\n".getBytes(charset));
        VersionedObjectDefinition def = VCard.definition;
        try {
            VersitDefinition.Reader reader = def.getReader((InputStream)stream, charset);
            def.parse(reader);
            ExpressiveErrorMessageWhileParsingVCard.fail((String)"Should not parse this.");
        }
        catch (VersitException e) {
            String msg = e.getMessage();
            ExpressiveErrorMessageWhileParsingVCard.assertTrue((String)"Needs line information to be helpful", (boolean)msg.contains("line"));
            ExpressiveErrorMessageWhileParsingVCard.assertTrue((String)"Needs column information to be helpful", (boolean)msg.contains("column"));
        }
    }
}

