/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.helpers;

import com.openexchange.groupware.contact.helpers.ContactMerger;
import com.openexchange.groupware.container.Contact;
import junit.framework.TestCase;

public class ContactMergerTest
extends TestCase {
    private Contact c1;
    private Contact c2;

    protected void setUp() throws Exception {
        super.setUp();
        this.c1 = new Contact();
        this.c1.setGivenName("Given Name 1");
        this.c1.setCompany("Company 1");
        this.c2 = new Contact();
        this.c2.setSurName("Surname 2");
        this.c2.setCompany("Company 2");
    }

    public void testNonConflictingElementsShouldBeMergedAnyway() {
        ContactMerger merger = new ContactMerger(true);
        Contact merged = merger.merge(this.c1, this.c2);
        ContactMergerTest.assertEquals((String)"Given name should be retained", (String)"Given Name 1", (String)merged.getGivenName());
        ContactMergerTest.assertEquals((String)"Surname should be transferred", (String)"Surname 2", (String)merged.getSurName());
    }

    public void testSecondElementShouldPrecedeWithOverwrite() {
        ContactMerger merger = new ContactMerger(true);
        Contact merged = merger.merge(this.c1, this.c2);
        ContactMergerTest.assertEquals((String)"Company should be same of second", (String)"Company 2", (String)merged.getCompany());
    }

    public void testEmptyElementShouldNotOverwriteEvenWithOverwriteEnabled() {
        ContactMerger merger = new ContactMerger(true);
        Contact merged = merger.merge(this.c1, this.c2);
        ContactMergerTest.assertEquals((String)"Given name should be retained if second one's is null", (String)"Given Name 1", (String)merged.getGivenName());
    }

    public void testFirstElementShouldPrecedeWithoutOverwrite() {
        ContactMerger merger = new ContactMerger(false);
        Contact merged = merger.merge(this.c1, this.c2);
        ContactMergerTest.assertEquals((String)"Company should be same of first, still", (String)"Company 1", (String)merged.getCompany());
    }
}

